/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import sonar.logistics.base.listeners.ListenerType;

public class UpdateListenerList {
    private Map<ListenerType.UpdateType, ListenerType> types = new HashMap<ListenerType.UpdateType, ListenerType>();
    private Map<ListenerType.UpdateType, Boolean> canAdd = new HashMap<ListenerType.UpdateType, Boolean>();
    private ListenerType.UpdateType[] validTypes;

    public UpdateListenerList() {
        this.validTypes = ListenerType.UpdateType.values();
    }

    public UpdateListenerList(ListenerType.UpdateType[] types) {
        this.validTypes = types;
    }

    public void reset() {
        this.types.clear();
        this.canAdd.clear();
    }

    public boolean isValid(ListenerType.UpdateType type) {
        for (ListenerType.UpdateType t : this.validTypes) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public void add(ListenerType type) {
        ListenerType current;
        if (this.canAdd(type.getUpdateType()) && ((current = this.types.get((Object)type.getUpdateType())) == null || ListenerType.canReplace(current, type).getBoolean())) {
            this.types.put(type.getUpdateType(), type);
            if (type.order == 10) {
                this.setMax(type.getUpdateType());
            }
        }
    }

    public boolean canAdd(ListenerType.UpdateType updateType) {
        if (!this.isValid(updateType)) {
            return false;
        }
        Boolean bool = this.canAdd.get((Object)updateType);
        return bool == null ? true : bool;
    }

    public void setMax(ListenerType.UpdateType updateType) {
        this.canAdd.put(updateType, false);
    }

    public boolean canForceUpdate(ListenerType.UpdateType ... updateTypes) {
        for (ListenerType.UpdateType updateType : updateTypes) {
            ListenerType type = this.types.get((Object)updateType);
            if (type == null || !type.shouldForceUpdate()) continue;
            return true;
        }
        return false;
    }

    public boolean canSyncUpdate(ListenerType.UpdateType ... updateTypes) {
        for (ListenerType.UpdateType updateType : updateTypes) {
            ListenerType type = this.types.get((Object)updateType);
            if (type == null || !type.shouldSyncUpdate()) continue;
            return true;
        }
        return false;
    }

    public Collection<ListenerType> getUpdates() {
        return this.types.values();
    }

    public boolean canAccept() {
        for (ListenerType.UpdateType type : ListenerType.UpdateType.values()) {
            if (!this.canAdd(type)) continue;
            return true;
        }
        return false;
    }
}

