/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.ASMLoader;
import sonar.core.helpers.NBTHelper;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.asm.ASMDisplayAction;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.asm.ASMEntityInfoProvider;
import sonar.logistics.api.asm.ASMFilter;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.asm.ASMInfoComparator;
import sonar.logistics.api.asm.ASMInfoError;
import sonar.logistics.api.asm.ASMInfoRegistry;
import sonar.logistics.api.asm.ASMListSorter;
import sonar.logistics.api.asm.ASMStyledString;
import sonar.logistics.api.asm.ASMTileInfoProvider;
import sonar.logistics.api.asm.ASMTileInventoryProvider;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.handlers.IEntityInfoProvider;
import sonar.logistics.api.core.tiles.displays.info.handlers.ITileInfoProvider;
import sonar.logistics.api.core.tiles.displays.info.register.IInfoRegistry;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.base.data.generators.items.ITileInventoryProvider;
import sonar.logistics.base.filters.INodeFilter;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.base.statements.comparators.ILogicComparator;
import sonar.logistics.core.tiles.displays.gsi.interaction.actions.IDisplayAction;
import sonar.logistics.core.tiles.displays.info.MasterInfoRegistry;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.info.types.text.styling.IStyledString;

public class PL2ASMLoader {
    public static LinkedHashMap<Integer, String> infoNames = new LinkedHashMap();
    public static LinkedHashMap<String, Integer> infoIds = new LinkedHashMap();
    public static LinkedHashMap<String, Class<? extends IInfo>> infoClasses = new LinkedHashMap();
    public static LinkedHashMap<Integer, String> elementNames = new LinkedHashMap();
    public static LinkedHashMap<String, Integer> elementIDs = new LinkedHashMap();
    public static LinkedHashMap<Integer, Class<? extends IDisplayElement>> elementIClasses = new LinkedHashMap();
    public static LinkedHashMap<String, Class<? extends IDisplayElement>> elementSClasses = new LinkedHashMap();
    public static LinkedHashMap<Integer, String> sstringNames = new LinkedHashMap();
    public static LinkedHashMap<String, Integer> sstringIDs = new LinkedHashMap();
    public static LinkedHashMap<Integer, Class<? extends IStyledString>> sstringIClasses = new LinkedHashMap();
    public static LinkedHashMap<String, Class<? extends IStyledString>> sstringSClasses = new LinkedHashMap();
    public static LinkedHashMap<Integer, String> comparatorNames = new LinkedHashMap();
    public static LinkedHashMap<String, Integer> comparatorIds = new LinkedHashMap();
    public static LinkedHashMap<String, ILogicComparator> comparatorClasses = new LinkedHashMap();
    public static LinkedHashMap<Integer, String> displayActionNames = new LinkedHashMap();
    public static LinkedHashMap<String, Integer> displayActionIDs = new LinkedHashMap();
    public static LinkedHashMap<Integer, Class<? extends IDisplayAction>> displayActionIClasses = new LinkedHashMap();
    public static LinkedHashMap<String, Class<? extends IDisplayAction>> displayActionSClasses = new LinkedHashMap();
    public static LinkedHashMap<Integer, String> changeableListSorterNames = new LinkedHashMap();
    public static LinkedHashMap<String, Integer> changeableListSorterIDs = new LinkedHashMap();
    public static LinkedHashMap<Integer, Class<? extends ILogicListSorter>> changeableListSorterIClasses = new LinkedHashMap();
    public static LinkedHashMap<String, Class<? extends ILogicListSorter>> changeableListSorterSClasses = new LinkedHashMap();
    public static LinkedHashMap<String, Class<? extends INodeFilter>> filterClasses = new LinkedHashMap();
    public static Map<Class, Map<Integer, Class<? extends INBTSyncable>>> asm_loadables_iC = new HashMap<Class, Map<Integer, Class<? extends INBTSyncable>>>();
    public static Map<Class, Map<Class<? extends INBTSyncable>, Integer>> asm_loadables_cI = new HashMap<Class, Map<Class<? extends INBTSyncable>, Integer>>();
    public static Map<Class, String> asm_loadables_nbt = new HashMap<Class, String>();

    private PL2ASMLoader() {
    }

    public static void init(FMLPreInitializationEvent event) {
        ASMDataTable asmDataTable = event.getAsmData();
        PL2ASMLoader.loadInfoTypes(asmDataTable);
        PL2ASMLoader.loadDisplayElementTypes(asmDataTable);
        PL2ASMLoader.loadDisplayActionTypes(asmDataTable);
        PL2ASMLoader.loadStyledStringTypes(asmDataTable);
        PL2ASMLoader.loadLogicListSorters(asmDataTable);
        PL2ASMLoader.loadComparatorTypes(asmDataTable);
        PL2ASMLoader.loadNodeFilters(asmDataTable);
        MasterInfoRegistry.INSTANCE.infoRegistries.addAll(PL2ASMLoader.getInfoRegistries(asmDataTable));
        MasterInfoRegistry.INSTANCE.tileProviders.addAll(PL2ASMLoader.getTileProviders(asmDataTable));
        MasterInfoRegistry.INSTANCE.entityProviders.addAll(PL2ASMLoader.getEntityProviders(asmDataTable));
        MasterInfoRegistry.INSTANCE.inventoryProviders.addAll(PL2ASMLoader.getInventoryProviders(asmDataTable));
        PL2ASMLoader.loadASMLoadable(asmDataTable, IInfoError.class, ASMInfoError.class, "IEuiD", true);
    }

    public static List<IInfoRegistry> getInfoRegistries(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMInfoRegistry.class, IInfoRegistry.class, (boolean)true, (boolean)false);
    }

    public static List<ITileInfoProvider> getTileProviders(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMTileInfoProvider.class, ITileInfoProvider.class, (boolean)true, (boolean)false);
    }

    public static List<IEntityInfoProvider> getEntityProviders(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMEntityInfoProvider.class, IEntityInfoProvider.class, (boolean)true, (boolean)false);
    }

    public static List<ITileInventoryProvider> getInventoryProviders(@Nonnull ASMDataTable asmDataTable) {
        return ASMLoader.getInstances((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMTileInventoryProvider.class, ITileInventoryProvider.class, (boolean)true, (boolean)true);
    }

    public static void loadComparatorTypes(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMInfoComparator.class, ILogicComparator.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = name.hashCode();
            comparatorNames.put(hashCode, name);
            comparatorIds.put(name, hashCode);
            try {
                comparatorClasses.put(name, (ILogicComparator)((Class)info.b).newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        PL2.logger.info("Loaded: " + comparatorIds.size() + " Comparator Types");
    }

    public static void loadInfoTypes(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMInfo.class, IInfo.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = name.hashCode();
            infoNames.put(hashCode, name);
            infoIds.put(name, hashCode);
            infoClasses.put(name, (Class<? extends IInfo>)info.b);
        }
        PL2.logger.info("Loaded: " + infoIds.size() + " Info Types");
    }

    public static void loadDisplayElementTypes(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMDisplayElement.class, IDisplayElement.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = name.hashCode();
            elementNames.put(hashCode, name);
            elementIDs.put(name, hashCode);
            elementSClasses.put(name, (Class<? extends IDisplayElement>)info.b);
            elementIClasses.put(hashCode, (Class<? extends IDisplayElement>)info.b);
        }
        PL2.logger.info("Loaded: " + elementIDs.size() + " Element Types");
    }

    public static void loadStyledStringTypes(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMStyledString.class, IStyledString.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = name.hashCode();
            sstringNames.put(hashCode, name);
            sstringIDs.put(name, hashCode);
            sstringSClasses.put(name, (Class<? extends IStyledString>)info.b);
            sstringIClasses.put(hashCode, (Class<? extends IStyledString>)info.b);
        }
        PL2.logger.info("Loaded: " + sstringIDs.size() + " Styled String Types");
    }

    public static void loadDisplayActionTypes(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMDisplayAction.class, IDisplayAction.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = name.hashCode();
            displayActionNames.put(hashCode, name);
            displayActionIDs.put(name, hashCode);
            displayActionSClasses.put(name, (Class<? extends IDisplayAction>)info.b);
            displayActionIClasses.put(hashCode, (Class<? extends IDisplayAction>)info.b);
        }
        PL2.logger.info("Loaded: " + displayActionIDs.size() + " Display Actions");
    }

    public static void loadLogicListSorters(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMListSorter.class, ILogicListSorter.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = name.hashCode();
            changeableListSorterNames.put(hashCode, name);
            changeableListSorterIDs.put(name, hashCode);
            changeableListSorterSClasses.put(name, (Class<? extends ILogicListSorter>)info.b);
            changeableListSorterIClasses.put(hashCode, (Class<? extends ILogicListSorter>)info.b);
        }
        PL2.logger.info("Loaded: " + changeableListSorterIDs.size() + " Logic List Sorter");
    }

    public static void loadNodeFilters(@Nonnull ASMDataTable asmDataTable) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, ASMFilter.class, INodeFilter.class, (boolean)true);
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            filterClasses.put(name, (Class<? extends INodeFilter>)info.b);
        }
        PL2.logger.info("Loaded: " + filterClasses.size() + " Filters");
    }

    public static int loadASMLoadable(@Nonnull ASMDataTable asmDataTable, Class type, Class asmClass, String nbtString, boolean checkModid) {
        List infoTypes = ASMLoader.getClasses((Logger)PL2.logger, (ASMDataTable)asmDataTable, (Class)asmClass, (Class)type, (boolean)checkModid);
        HashMap<Integer, Object> loadables_iC = new HashMap<Integer, Object>();
        HashMap<Object, Integer> loadables_cI = new HashMap<Object, Integer>();
        for (Pair info : infoTypes) {
            String name = (String)((ASMDataTable.ASMData)info.a).getAnnotationInfo().get("id");
            int hashCode = PL2ASMLoader.getRegisteredID(name);
            if (loadables_iC.containsKey(hashCode)) {
                PL2.logger.error("DUPLICATE ID: " + name + " shared by " + ((Class)info.b).getName() + " & " + ((Class)loadables_iC.get(hashCode)).getName());
                continue;
            }
            loadables_iC.put(hashCode, info.b);
            loadables_cI.put(info.b, hashCode);
        }
        asm_loadables_iC.put(type, loadables_iC);
        asm_loadables_cI.put(type, loadables_cI);
        asm_loadables_nbt.put(type, nbtString);
        return loadables_iC.size();
    }

    public static <T> int getRegisteredID(String id) {
        return id.hashCode();
    }

    public static <T> int getRegisteredID(Class<T> type, Class<? extends T> clazz) {
        return asm_loadables_cI.get(type).get(clazz);
    }

    public static <T extends INBTSyncable> Class<T> getRegisteredClass(Class<T> type, int id) {
        return asm_loadables_iC.get(type).get(id);
    }

    public static <T extends INBTSyncable> Class<T> getRegisteredClass(Class<T> type, String id) {
        return asm_loadables_iC.get(type).get(id.hashCode());
    }

    public static <T extends INBTSyncable> T instanceClass(Class<T> type, int id) {
        Class<T> clazz = PL2ASMLoader.getRegisteredClass(type, id);
        try {
            return (T)((INBTSyncable)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends INBTSyncable> T readFromNBT(Class<T> type, NBTTagCompound tag) {
        String stringID = asm_loadables_nbt.get(type);
        T instance = PL2ASMLoader.instanceClass(type, tag.func_74762_e(stringID));
        if (instance != null) {
            instance.readData(tag, NBTHelper.SyncType.SAVE);
        }
        return instance;
    }

    public static <T extends INBTSyncable> List<T> readListFromNBT(Class<T> type, NBTTagCompound tag) {
        ArrayList<T> loaded = new ArrayList<T>();
        String s = asm_loadables_nbt.get(type);
        NBTTagList list = tag.func_150295_c(s + "_list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subTag = list.func_150305_b(i);
            loaded.add(PL2ASMLoader.readFromNBT(type, subTag));
        }
        return loaded;
    }

    public static <T extends INBTSyncable> NBTTagCompound writeToNBT(Class<T> type, T instance, NBTTagCompound tag) {
        int id = PL2ASMLoader.getRegisteredID(type, instance.getClass());
        tag.func_74768_a(asm_loadables_nbt.get(type), id);
        instance.writeData(tag, NBTHelper.SyncType.SAVE);
        return tag;
    }

    public static <T extends INBTSyncable> NBTTagCompound writeListToNBT(Class<T> type, List<T> instances, NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        String s = asm_loadables_nbt.get(type);
        instances.forEach(i -> list.func_74742_a((NBTBase)PL2ASMLoader.writeToNBT(type, i, new NBTTagCompound())));
        tag.func_74782_a(s + "_list", (NBTBase)list);
        return tag;
    }
}

