/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.vao;

import code.elix_x.excore.utils.client.render.IVertexBuffer;
import code.elix_x.excore.utils.client.render.vao.VAO;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class VertexBuffer
implements IVertexBuffer {
    protected final VertexFormat format;
    protected final int drawMode;
    protected final int vertexCount;
    protected final VAO vao;

    public static <B extends Buffer> B createBuffer(int vertexCount, VertexFormatElement element) {
        switch (element.func_177367_b()) {
            case BYTE: {
                return (B)BufferUtils.createByteBuffer((int)(element.func_177370_d() * vertexCount));
            }
            case UBYTE: {
                return (B)BufferUtils.createByteBuffer((int)(element.func_177370_d() * vertexCount));
            }
            case SHORT: {
                return (B)BufferUtils.createShortBuffer((int)(element.func_177370_d() * vertexCount));
            }
            case USHORT: {
                return (B)BufferUtils.createShortBuffer((int)(element.func_177370_d() * vertexCount));
            }
            case INT: {
                return (B)BufferUtils.createIntBuffer((int)(element.func_177370_d() * vertexCount));
            }
            case UINT: {
                return (B)BufferUtils.createIntBuffer((int)(element.func_177370_d() * vertexCount));
            }
            case FLOAT: {
                return (B)BufferUtils.createFloatBuffer((int)(element.func_177370_d() * vertexCount));
            }
        }
        return (B)BufferUtils.createByteBuffer((int)(element.func_177370_d() * vertexCount));
    }

    public static ByteBuffer createByteBuffer(int vertexCount, VertexFormatElement element) {
        return BufferUtils.createByteBuffer((int)(element.func_177368_f() * vertexCount));
    }

    protected VertexBuffer(VertexFormat format, int drawMode, int vertexCount) {
        this.format = format;
        this.drawMode = drawMode;
        this.vertexCount = vertexCount;
        this.vao = new VAO();
    }

    @Override
    public final void draw() {
        this.renderPre();
        GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
        this.renderPost();
    }

    protected void renderPre() {
        this.vao.bind();
    }

    protected void renderPost() {
        this.vao.unbind();
    }

    @Override
    public void cleanUp() {
        this.vao.cleanUp();
    }
}

