/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockTreeFoliage;
import shetiphian.terraqueous.common.block.BlockTreeTrunk;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaBase;
import shetiphian.terraqueous.common.tileentity.TileEntitySFController;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeColored;

public class WailaDataProvider
implements IWailaDataProvider {
    public static WailaDataProvider INSTANCE = new WailaDataProvider();

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile;
        if (accessor.getBlock() instanceof BlockTreeTrunk || accessor.getBlock() instanceof BlockTreeFoliage) {
            return accessor.getBlock().getPickBlock(accessor.getBlockState(), accessor.getMOP(), accessor.getWorld(), accessor.getPosition(), accessor.getPlayer());
        }
        if (Values.blockTypeEarth != null && ((tile = accessor.getTileEntity()) instanceof TileEntitySFController || tile instanceof TileEntitySFStatic)) {
            return new ItemStack(Values.itemMain, 1, 500);
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaHead(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntityFlowerPot tile;
        if (accessor.getTileEntity() instanceof TileEntityFlowerPot) {
            tile = (TileEntityFlowerPot)accessor.getTileEntity();
            if (accessor.getTileEntity().func_145831_w().field_72995_K && Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                return tooltip;
            }
            if (tile.getPlantStack() != null) {
                tooltip.add("Plant: " + tile.getPlantStack().func_82833_r());
            }
        }
        if (accessor.getTileEntity() instanceof IRGB16_Tile) {
            tile = (IRGB16_Tile)accessor.getTileEntity();
            tooltip.add(tile.getRGB16(null).getTooltip());
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack stack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, TileEntityFlowerPot.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, TileEntityPergolaBase.class);
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, TileEntitySFController.class);
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, TileEntitySFStatic.class);
        registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, TileEntityTypeColored.class);
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockTreeTrunk.class);
        registrar.registerStackProvider((IWailaDataProvider)INSTANCE, BlockTreeFoliage.class);
    }
}

