/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockPergola;

public class Component_Vineyard
extends StructureVillagePieces.Village {
    private int averageGroundLevel = -1;

    public Component_Vineyard() {
    }

    public Component_Vineyard(StructureVillagePieces.Start startPiece, int componentType, StructureBoundingBox boundingBox, EnumFacing facing) {
        super(startPiece, componentType);
        this.func_186164_a(facing);
        this.field_74887_e = boundingBox;
    }

    public static Component_Vineyard buildComponent(StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, int x, int y, int z, EnumFacing facing, int componentType) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)12, (int)6, (int)12, (EnumFacing)facing);
        return Configuration.GENERATOR.VILLAGE.generateVillage_Vineyard && Values.blockPergola != null && Component_Vineyard.func_74895_a((StructureBoundingBox)boundingBox) && StructureComponent.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null ? new Component_Vineyard(startPiece, componentType, boundingBox, facing) : null;
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, box);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 4, 0);
        }
        this.func_74878_a(world, box, 1, 1, 1, 10, 3, 10);
        this.func_74878_a(world, box, 0, 3, 0, 11, 6, 11);
        IBlockState fill = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
        for (int x = 2; x <= 9; x = (int)((byte)(x + 1))) {
            for (int z = 2; z <= 9; z = (int)((byte)(z + 1))) {
                BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(-1), this.func_74873_b(x, z));
                if (!world.func_175623_d(pos)) continue;
                world.func_180501_a(pos, fill, 2);
            }
        }
        IBlockState cobblewall = Blocks.field_150463_bK.func_176223_P();
        IBlockState mosswall = Blocks.field_150463_bK.func_176223_P().func_177226_a((IProperty)BlockWall.field_176255_P, (Comparable)BlockWall.EnumType.MOSSY);
        fill = fill.func_177230_c() == Blocks.field_150322_A ? Blocks.field_150354_m.func_176223_P() : Blocks.field_150349_c.func_176223_P();
        boolean isGrass = fill.func_177230_c() == Blocks.field_150349_c;
        for (int x = 0; x <= 11; ++x) {
            for (int z = 0; z <= 11; ++z) {
                BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(0), this.func_74873_b(x, z));
                if (x == 0 || x == 11 || z == 0 || z == 11) {
                    if (!world.func_175623_d(pos = pos.func_177981_b(2)) && !(world.func_180495_p(pos).func_177230_c() instanceof BlockPergola)) {
                        world.func_180501_a(pos, fill, 2);
                        continue;
                    }
                    pos = pos.func_177979_c(2);
                }
                if (!world.func_175623_d(pos) && !(world.func_180495_p(pos).func_177230_c() instanceof BlockWall) || world.func_175623_d(pos) && !world.func_175623_d(pos.func_177977_b())) {
                    world.func_180501_a(pos, fill, 2);
                }
                if ((x != 1 && x != 10 || z < 1 || z > 10) && (z != 1 && z != 10 || x < 1 || x > 10) || !world.func_175623_d(pos)) continue;
                world.func_180501_a(pos, isGrass ? mosswall : cobblewall, 2);
                if (!(x > 4 && x < 7 || z > 4 && z < 7)) {
                    boolean moss = random.nextBoolean();
                    world.func_180501_a(pos.func_177977_b(), isGrass && moss ? mosswall : cobblewall, 2);
                }
                if (x != 1 && x != 4 && x != 7 && x != 10 || z != 1 && z != 4 && z != 7 && z != 10) continue;
                this.extendDownwards(world, x, -2, z, cobblewall, fill);
            }
        }
        long seed = world.func_72905_C() + (long)this.func_74862_a(box.field_78895_b);
        Random rand = new Random(seed);
        IBlockState wall = BlockPergola.getStateWithTypes(BlockPergola.EnumBase.WALL, this.getRandomCover(rand.nextInt(20)));
        this.func_175804_a(world, box, 1, 1, 1, 1, 3, 4, wall, wall, false);
        this.func_175804_a(world, box, 2, 1, 1, 4, 3, 1, wall, wall, false);
        wall = BlockPergola.getStateWithTypes(BlockPergola.EnumBase.WALL, this.getRandomCover(rand.nextInt(20)));
        this.func_175804_a(world, box, 1, 1, 7, 1, 3, 10, wall, wall, false);
        this.func_175804_a(world, box, 2, 1, 10, 4, 3, 10, wall, wall, false);
        wall = BlockPergola.getStateWithTypes(BlockPergola.EnumBase.WALL, this.getRandomCover(rand.nextInt(20)));
        this.func_175804_a(world, box, 10, 1, 1, 10, 3, 4, wall, wall, false);
        this.func_175804_a(world, box, 7, 1, 1, 9, 3, 1, wall, wall, false);
        wall = BlockPergola.getStateWithTypes(BlockPergola.EnumBase.WALL, this.getRandomCover(rand.nextInt(20)));
        this.func_175804_a(world, box, 10, 1, 7, 10, 3, 10, wall, wall, false);
        this.func_175804_a(world, box, 7, 1, 10, 9, 3, 10, wall, wall, false);
        IBlockState top = BlockPergola.getStateWithTypes(BlockPergola.EnumBase.TOP, BlockPergola.EnumCover.NONE);
        this.func_175804_a(world, box, 1, 4, 1, 10, 4, 10, top, top, false);
        return true;
    }

    private void extendDownwards(World world, int x, int y, int z, IBlockState wall, IBlockState filler) {
        int xPos = this.func_74865_a(x, z);
        int yPos = this.func_74862_a(y);
        int zPos = this.func_74873_b(x, z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(xPos, yPos, zPos);
        boolean useFiller = false;
        Material material = world.func_180495_p((BlockPos)pos).func_185904_a();
        while ((world.func_175623_d((BlockPos)pos) || material.func_76224_d() || material.func_76222_j()) && yPos > 1) {
            if (!useFiller && material.func_76224_d()) {
                useFiller = true;
            }
            world.func_180501_a((BlockPos)pos, useFiller ? filler : wall, 2);
            pos.func_185336_p(--yPos);
            material = world.func_180495_p((BlockPos)pos).func_185904_a();
        }
    }

    private BlockPergola.EnumCover getRandomCover(int value) {
        if (Configuration.BLOCKS.addPlants) {
            Configuration.Menu_Generator.SubMenu_Village config = Configuration.GENERATOR.VILLAGE;
            if (config.enableGrapeVines && this.contains(config.valuesGrapeVine, value)) {
                return BlockPergola.EnumCover.GRAPEVINE;
            }
            if (config.enableLifeFruitVines && this.contains(config.valuesLifeFruitVine, value)) {
                return BlockPergola.EnumCover.LIFEVINE;
            }
            if (config.enableDeathFruitVines && this.contains(config.valuesDeathFruitVine, value)) {
                return BlockPergola.EnumCover.DEATHVINE;
            }
        }
        return BlockPergola.EnumCover.NONE;
    }

    private boolean contains(int[] array, int value) {
        for (int entry : array) {
            if (entry != value) continue;
            return true;
        }
        return false;
    }
}

