/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.MyDamageSource;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.core.common.item.NameMapper;
import shetiphian.terraqueous.common.misc.FoodData;

public abstract class ItemMultiFoodBase
extends ItemFood {
    private List<FoodData> foodList = new ArrayList<FoodData>();
    private final String nameId;
    private final NameMapper nameMapper;

    public ItemMultiFoodBase(int amount, float saturation, boolean isWolfFood, List<FoodData> foodList, String nameId, NameMapper nameMapper) {
        super(amount, saturation, isWolfFood);
        this.func_77656_e(0);
        this.foodList = foodList;
        this.nameId = nameId;
        this.nameMapper = nameMapper;
        this.addToNameMap();
    }

    public List<FoodData> getFoodData() {
        return this.foodList;
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{CreativeTabs.field_78039_h};
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int x = 0; x < this.foodList.size(); ++x) {
                list.add((Object)new ItemStack((Item)this, 1, x));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        String name = this.nameMapper.getUnlocalizedNameFor(this.nameId, stack.func_77952_i());
        return name.endsWith("unused") ? name : this.func_77658_a() + "." + name;
    }

    public FoodData getFoodData(ItemStack stack) {
        if (stack != null && !this.foodList.isEmpty()) {
            int itemDmg;
            int n = itemDmg = this.field_77787_bX ? stack.func_77952_i() : 0;
            if (itemDmg >= 0 && itemDmg < this.foodList.size()) {
                return this.foodList.get(itemDmg);
            }
        }
        return null;
    }

    public int func_150905_g(ItemStack stack) {
        FoodData foodData = this.getFoodData(stack);
        return foodData != null ? foodData.getHealAmount() : super.func_150905_g(stack);
    }

    public float func_150906_h(ItemStack stack) {
        FoodData foodData = this.getFoodData(stack);
        return foodData != null ? foodData.getSaturationModifier() : super.func_150906_h(stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        FoodData foodData = this.getFoodData(stack);
        if (foodData == null) {
            return EnumActionResult.PASS;
        }
        return foodData.getFoodUseAction() != null && foodData.getFoodUseAction().doUseAction(stack, player, world, pos, facing) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        FoodData foodData = this.getFoodData(stack);
        if (foodData == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_71043_e(foodData.getAlwaysEdible())) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        FoodData foodData = this.getFoodData(stack);
        if (foodData != null) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.func_71024_bL().func_151686_a((ItemFood)this, stack);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if (foodData.getReturnedItem() != null) {
                    player.field_71071_by.func_70441_a(foodData.getReturnedItem());
                }
                if (foodData.getFoodFinishAction() != null) {
                    stack = foodData.getFoodFinishAction().doFinishAction(stack, world, player);
                }
            }
            stack.func_190918_g(1);
        }
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        FoodData foodData = this.getFoodData(stack);
        return foodData != null ? foodData.getUseAction() : EnumAction.EAT;
    }

    public int func_77626_a(ItemStack stack) {
        FoodData foodData = this.getFoodData(stack);
        return foodData != null ? foodData.getUseDuration() : 32;
    }

    public int getItemStackLimit(ItemStack stack) {
        FoodData foodData = this.getFoodData(stack);
        return foodData != null ? foodData.getStackLimit() : 64;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity victim) {
        FoodData foodData = this.getFoodData(stack);
        if (foodData == null || foodData.getDamageSource() == null) {
            return false;
        }
        return ItemToolWithDamageSource.onLeftClickEntity((EntityPlayer)player, (Entity)victim, (MyDamageSource)foodData.getDamageSource(), (ItemStack)ItemStack.field_190927_a);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        String info;
        FoodData foodData = this.getFoodData(stack);
        if (foodData != null && !Strings.isNullOrEmpty((String)(info = foodData.getTooltip()))) {
            tooltip.add(Localization.get((String)info));
        }
    }

    private void addToNameMap() {
        int index = 0;
        for (FoodData food : this.foodList) {
            this.nameMapper.add(this.nameId, index, "food/", food.getModel(), food.getName());
            ++index;
        }
    }
}

