/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class BlockTreeTrunk
extends BlockLog {
    private PropertyEnum<PlantAPI.TreeType> TREE;
    private final int index;
    protected final BlockStateContainer field_176227_L;

    public BlockTreeTrunk(int index) {
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.index = index;
        this.setBlockState();
        this.field_176227_L = this.func_180661_e();
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.setHarvestLevel("axe", 0);
    }

    private void setBlockState() {
        this.TREE = PropertyEnum.func_177708_a((String)"treevariant", PlantAPI.TreeType.class, (Predicate)new Predicate<PlantAPI.TreeType>(){

            public boolean apply(PlantAPI.TreeType treeType) {
                int base = BlockTreeTrunk.this.index * 5;
                byte id = treeType.getID();
                return id >= base && id < base + 5;
            }

            public boolean test(@Nullable PlantAPI.TreeType treeType) {
                return this.apply(treeType);
            }
        });
    }

    protected BlockStateContainer func_180661_e() {
        return this.TREE == null ? super.func_180661_e() : new BlockStateContainer((Block)this, new IProperty[]{BlockLog.field_176299_a, this.TREE});
    }

    public BlockStateContainer func_176194_O() {
        return this.field_176227_L;
    }

    public IBlockState func_176203_a(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)14);
        IBlockState state = this.func_176223_P().func_177226_a(this.TREE, (Comparable)((Object)PlantAPI.TreeType.byID(meta / 3 + this.index * 5)));
        state = state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)this.getAxis(meta % 3));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return this.getIndex((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)) + 3 * (this.getTreeType(state).getID() % 5);
    }

    private BlockLog.EnumAxis getAxis(int value) {
        return value == 1 ? BlockLog.EnumAxis.Z : (value == 2 ? BlockLog.EnumAxis.X : BlockLog.EnumAxis.Y);
    }

    private int getIndex(BlockLog.EnumAxis axis) {
        return axis == BlockLog.EnumAxis.Z ? 1 : (axis == BlockLog.EnumAxis.X ? 2 : 0);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public int func_180651_a(IBlockState state) {
        return this.getTreeType(state).getID() % 5;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, this.func_180651_a(state));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)) {
                    case X: {
                        return state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                    }
                    case Z: {
                        return state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public PlantAPI.TreeType getTreeType(IBlockState state) {
        PlantAPI.TreeType type;
        try {
            type = (PlantAPI.TreeType)((Object)state.func_177229_b(this.TREE));
        }
        catch (Exception e) {
            type = PlantAPI.TreeType.byID(this.index * 2);
            PlantAPI.errorPropertyNotFound("BlockTreeTrunk.TREE", type.func_176610_l().toUpperCase(), state.toString());
        }
        return type;
    }
}

