/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.block.BlockTreeFoliage;
import shetiphian.terraqueous.common.block.BlockTreeTrunk;
import shetiphian.terraqueous.common.entity.EntityCoconut;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockTreeFoliageCB
extends BlockTreeFoliage
implements IColored {
    private static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final PropertyEnum<PlantAPI.TreeType> TREE = PropertyEnum.func_177708_a((String)"treevariant", PlantAPI.TreeType.class, (Predicate)new Predicate<PlantAPI.TreeType>(){

        public boolean apply(PlantAPI.TreeType treeType) {
            return treeType == PlantAPI.TreeType.COCONUT || treeType == PlantAPI.TreeType.BANANA;
        }

        public boolean test(@Nullable PlantAPI.TreeType treeType) {
            return this.apply(treeType);
        }
    });
    private static final AxisAlignedBB AABB_STALK_BARE = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);
    private static final AxisAlignedBB AABB_STALK = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
    private boolean[] coconutCheckSides = new boolean[4];

    public BlockTreeFoliageCB() {
        super(-1);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, TREE, BlockTreeFoliage.FASTMODE, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta < 8) {
            state = state.func_177226_a(TREE, (Comparable)((Object)(meta % 4 == 1 ? PlantAPI.TreeType.BANANA : PlantAPI.TreeType.COCONUT)));
            state = state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(meta > 3)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
        } else {
            state = state.func_177226_a(TREE, (Comparable)((Object)PlantAPI.TreeType.BANANA)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
            state = state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta - 7)));
        }
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        byte value = this.getEnumType(state).getValue();
        if (value == 0) {
            return (this.getTreeType(state) == PlantAPI.TreeType.BANANA ? 1 : 0) + ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b) != false ? 4 : 0);
        }
        return 7 + value;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_180651_a(world.func_180495_p(pos)) < 8 && super.isFlammable(world, pos, face);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch (this.getEnumType(state)) {
            case NORMAL: {
                return Block.field_185505_j;
            }
            case STALK_BARE: {
                return AABB_STALK_BARE;
            }
        }
        return AABB_STALK;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isLeaves(state) ? super.func_180660_a(state, rand, fortune) : Items.field_151055_y;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.isLeaves(state) ? super.func_180651_a(state) : 0;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = this.getEnumType(state);
        PlantAPI.TreeType tree = this.getTreeType(state);
        if (type == EnumType.NORMAL) {
            if (PlantFunctions.dropSapling(world, pos, tree) && fortune > -100) {
                drops.add((Object)new ItemStack(Values.blockSapling, 1, (int)tree.getID()));
            }
        } else if (tree == PlantAPI.TreeType.BANANA) {
            if (type == EnumType.STALK_BARE || type == EnumType.STALK_GROW) {
                drops.add((Object)new ItemStack(Items.field_151055_y));
            } else if (type == EnumType.FRUIT) {
                drops.add((Object)new ItemStack(Items.field_151055_y));
                ItemStack fruit = Terraqueous.getCustomItemStack("banana", new Random().nextInt(5) + 4);
                if (!fruit.func_190926_b()) {
                    drops.add((Object)fruit);
                }
            }
        }
    }

    @Override
    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getEnumType(state) == EnumType.NORMAL) {
            super.func_180653_a(world, pos, state, chance, fortune);
        } else {
            Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151055_y));
            this.dropFruit(world, pos, state, null, false);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public boolean dropFruit(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean changeLeaves) {
        if (changeLeaves || this.getEnumType(state) != EnumType.FRUIT || Values.itemMultiFood == null) {
            return false;
        }
        ItemStack fruit = Terraqueous.getCustomItemStack("banana", world.field_73012_v.nextInt(5) + 4);
        if (player != null) {
            Function.giveItem((EntityPlayer)player, (ItemStack)fruit);
        } else {
            Function.dropItem((World)world, (BlockPos)pos, (ItemStack)fruit);
        }
        return true;
    }

    @Override
    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == this && this.isLeaves(state, world, pos);
    }

    @Override
    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLeaves(state);
    }

    private boolean isLeaves(IBlockState state) {
        return this.getEnumType(state).getValue() < 8;
    }

    @Override
    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return this.isFoliage(world, pos);
    }

    @Override
    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(world.func_180495_p(pos));
        if (meta < 8) {
            list.add(new ItemStack((Block)this, 1, meta % 2));
        }
        return list;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getEnumType(state) != EnumType.NORMAL && world.func_175623_d(pos.func_177984_a())) {
            world.func_175698_g(pos);
            this.func_180653_a(world, pos, state, 0.0f, 0);
        }
        super.func_189540_a(state, world, pos, neighbor, pos2);
    }

    @Override
    public boolean canGrow(World world, BlockPos pos, IBlockState state, boolean isClient) {
        if (this.getTreeType(state) == PlantAPI.TreeType.COCONUT) {
            return this.coconutCheck(world, pos);
        }
        switch (this.getEnumType(state)) {
            case NORMAL: {
                return this.flowerCheck(world, pos);
            }
            case FLOWER: {
                IBlockState upState;
                if (world.func_175623_d(pos.func_177977_b()) && (upState = world.func_180495_p(pos.func_177984_a())).func_177230_c() == this) {
                    EnumType upType = this.getEnumType(upState);
                    return upType == EnumType.NORMAL || upType != EnumType.STALK_BARE;
                }
                return false;
            }
            case STALK_BARE: 
            case STALK_GROW: {
                return world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && (world.func_175623_d(pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this);
            }
            case FRUIT: {
                return world.func_175623_d(pos.func_177977_b()) && world.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
            }
        }
        return false;
    }

    private boolean isBananaLeaf(IBlockState state) {
        return state.func_177230_c() == this && this.getEnumType(state) == EnumType.NORMAL && this.getTreeType(state) == PlantAPI.TreeType.BANANA;
    }

    private boolean isCoconutLeaf(IBlockState state) {
        return state.func_177230_c() == this && this.getEnumType(state) == EnumType.NORMAL && this.getTreeType(state) == PlantAPI.TreeType.COCONUT;
    }

    private boolean coconutCheck(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockPos down = pos.func_177977_b();
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                IBlockState state = world.func_180495_p(down.func_177972_a(facing));
                this.coconutCheckSides[facing.func_176736_b()] = this.isCoconutLeaf(state);
            }
            if (this.coconutCheckSides[0] && this.coconutCheckSides[1] || this.coconutCheckSides[1] && this.coconutCheckSides[2] || this.coconutCheckSides[2] && this.coconutCheckSides[3] || this.coconutCheckSides[3] && this.coconutCheckSides[0]) {
                List list = world.func_72872_a(EntityCoconut.class, new AxisAlignedBB(pos.func_177982_a(-1, -2, -1), pos.func_177982_a(2, 1, 2)));
                return list == null || list.size() <= 1;
            }
        }
        return false;
    }

    private boolean flowerCheck(World world, BlockPos pos) {
        if (world.func_175623_d(pos.func_177977_b())) {
            IBlockState sState;
            BlockPos sPos;
            BlockPos woodPos = pos;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                sPos = pos.func_177972_a(facing);
                sState = world.func_180495_p(sPos);
                if (!this.isBananaLeaf(sState) || !((sState = world.func_180495_p(sPos = pos.func_177967_a(facing, 2))).func_177230_c() instanceof BlockTreeTrunk) || ((BlockTreeTrunk)sState.func_177230_c()).getTreeType(sState) != PlantAPI.TreeType.BANANA) continue;
                woodPos = sPos;
                break;
            }
            if (woodPos != pos && this.isBananaLeaf(sState = world.func_180495_p(woodPos.func_177984_a()))) {
                boolean noFlower = true;
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    sPos = woodPos.func_177967_a(facing, 2);
                    sState = world.func_180495_p(sPos.func_177977_b());
                    if (sState.func_177230_c() != this || this.getEnumType(sState) == EnumType.NORMAL) continue;
                    noFlower = false;
                    break;
                }
                return noFlower;
            }
        }
        return false;
    }

    @Override
    public boolean canUseBonemeal(World world, Random random, BlockPos pos, IBlockState state) {
        return (this.getEnumType(state) != EnumType.FRUIT || world.func_175623_d(pos.func_177977_b())) && random.nextFloat() < 0.45f;
    }

    @Override
    public void grow(World world, Random rand, BlockPos pos, IBlockState state) {
        EnumType type = this.getEnumType(state);
        switch (type) {
            case NORMAL: {
                if (this.getTreeType(state) == PlantAPI.TreeType.COCONUT) {
                    if (world.field_72995_K) break;
                    world.func_72838_d((Entity)new EntityCoconut(world, pos, true));
                    break;
                }
                if (!world.func_175623_d(pos.func_177977_b())) break;
                Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.FLOWER)), (boolean)true);
                break;
            }
            case FLOWER: {
                if (!world.func_175623_d(pos.func_177977_b()) || this.getEnumType(world.func_180495_p(pos.func_177984_a())) == EnumType.STALK_BARE) break;
                Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.FLOWER)), (boolean)true);
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.STALK_BARE)), (boolean)true);
                break;
            }
            case STALK_BARE: 
            case STALK_GROW: {
                if (world.func_175623_d(pos.func_177977_b())) {
                    Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.FLOWER)), (boolean)true);
                    break;
                }
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)(type == EnumType.STALK_BARE ? EnumType.STALK_GROW : EnumType.FRUIT))), (boolean)true);
                break;
            }
            case FRUIT: {
                if (!world.func_175623_d(pos.func_177977_b())) break;
                Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.FLOWER)), (boolean)true);
            }
        }
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.passthroughUpdateTick(world, pos, state.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(this.getEnumType(state) == EnumType.NORMAL)), rand);
        if (!world.func_175623_d(pos) && this.canGrow(world, pos, state, world.field_72995_K)) {
            switch (this.getEnumType(state)) {
                case NORMAL: {
                    if (this.getTreeType(state) == PlantAPI.TreeType.COCONUT) {
                        if (!PlantFunctions.growFruit((IBlockAccess)world, pos.func_177977_b(), PlantAPI.TreeType.COCONUT)) break;
                        this.grow(world, rand, pos, state);
                        break;
                    }
                    if (!world.func_175623_d(pos.func_177977_b())) break;
                    this.grow(world, rand, pos, state);
                    break;
                }
                case FLOWER: {
                    if (!world.func_175623_d(pos.func_177977_b())) break;
                    this.grow(world, rand, pos, state);
                    break;
                }
                case STALK_BARE: {
                    if (!world.func_175623_d(pos.func_177977_b()) && !PlantFunctions.growFruitFlower((IBlockAccess)world, pos, PlantAPI.TreeType.BANANA)) break;
                    this.grow(world, rand, pos, state);
                    break;
                }
                case STALK_GROW: {
                    if (!world.func_175623_d(pos.func_177977_b()) && !PlantFunctions.growFruit((IBlockAccess)world, pos, PlantAPI.TreeType.BANANA)) break;
                    this.grow(world, rand, pos, state);
                    break;
                }
                case FRUIT: {
                    if (!world.func_175623_d(pos.func_177977_b())) break;
                    this.grow(world, rand, pos, state);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (data.state != null && this.getEnumType(data.state) == EnumType.NORMAL) {
            if (data.world != null && data.pos != null) {
                return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(this.getTreeType(data.state)));
            }
            FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.getTreeType(data.state)));
        }
        return 0xFFFFFF;
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int damage;
        byte value = this.getEnumType(state).getValue();
        int n = value == 0 ? (this.getTreeType(state) == PlantAPI.TreeType.BANANA ? 1 : 0) : (value == 1 ? 8 : (damage = value == 2 ? 11 : value + 6));
        if (value == 0 || player != null && player.field_71075_bZ.field_75098_d) {
            return new ItemStack((Block)this, 1, damage);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public PlantAPI.TreeType getTreeType(IBlockState state) {
        PlantAPI.TreeType type;
        try {
            type = (PlantAPI.TreeType)((Object)state.func_177229_b(TREE));
        }
        catch (Exception e) {
            type = PlantAPI.TreeType.COCONUT;
            PlantAPI.errorPropertyNotFound("BlockTreeFoliageCB.TREE", "COCONUT", state.toString());
        }
        return type;
    }

    private EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.NORMAL;
            Terraqueous.errorPropertyNotFound("BlockTreeFoliageCB.VARIANT", "NORMAL", state.toString());
        }
        return type;
    }

    private static enum EnumType implements IStringSerializable
    {
        NORMAL(0),
        FLOWER(1),
        FRUIT(2),
        STALK_BARE(3),
        STALK_GROW(4);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[5];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

