/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import teamroots.embers.ConfigManager;
import teamroots.embers.RegistryManager;

public class WorldGenOres
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (ConfigManager.isOreSpawnEnabled(world.field_73011_w.getDimension()) && !world.field_72995_K) {
            int z;
            int y;
            int x;
            int i;
            WorldGenMinable ore_copper = new WorldGenMinable(RegistryManager.ore_copper.func_176223_P(), ConfigManager.copperVeinSize);
            for (int i2 = 0; i2 < ConfigManager.copperVeinsPerChunk; ++i2) {
                int x2 = chunkX * 16 + random.nextInt(16);
                int y2 = random.nextInt(ConfigManager.copperMaxY - ConfigManager.copperMinY) + ConfigManager.copperMinY;
                int z2 = chunkZ * 16 + random.nextInt(16);
                ore_copper.func_180709_b(world, random, new BlockPos(x2, y2, z2));
            }
            WorldGenMinable ore_lead = new WorldGenMinable(RegistryManager.ore_lead.func_176223_P(), ConfigManager.leadVeinSize);
            for (int i3 = 0; i3 < ConfigManager.leadVeinsPerChunk; ++i3) {
                int x3 = chunkX * 16 + random.nextInt(16);
                int y3 = random.nextInt(ConfigManager.leadMaxY - ConfigManager.leadMinY) + ConfigManager.leadMinY;
                int z3 = chunkZ * 16 + random.nextInt(16);
                ore_lead.func_180709_b(world, random, new BlockPos(x3, y3, z3));
            }
            WorldGenMinable ore_silver = new WorldGenMinable(RegistryManager.ore_silver.func_176223_P(), ConfigManager.silverVeinSize);
            for (int i4 = 0; i4 < ConfigManager.silverVeinsPerChunk; ++i4) {
                int x4 = chunkX * 16 + random.nextInt(16);
                int y4 = random.nextInt(ConfigManager.silverMaxY - ConfigManager.silverMinY) + ConfigManager.silverMinY;
                int z4 = chunkZ * 16 + random.nextInt(16);
                ore_silver.func_180709_b(world, random, new BlockPos(x4, y4, z4));
            }
            WorldGenMinable ore_quartz = new WorldGenMinable(RegistryManager.ore_quartz.func_176223_P(), ConfigManager.quartzVeinSize);
            for (int i5 = 0; i5 < ConfigManager.quartzVeinsPerChunk; ++i5) {
                int x5 = chunkX * 16 + random.nextInt(16);
                int y5 = random.nextInt(ConfigManager.quartzMaxY - ConfigManager.quartzMinY) + ConfigManager.quartzMinY;
                int z5 = chunkZ * 16 + random.nextInt(16);
                ore_quartz.func_180709_b(world, random, new BlockPos(x5, y5, z5));
            }
            if (ConfigManager.enableAluminum) {
                WorldGenMinable ore_aluminum = new WorldGenMinable(RegistryManager.ore_aluminum.func_176223_P(), ConfigManager.aluminumVeinSize);
                for (i = 0; i < ConfigManager.aluminumVeinsPerChunk; ++i) {
                    x = chunkX * 16 + random.nextInt(16);
                    y = random.nextInt(ConfigManager.aluminumMaxY - ConfigManager.aluminumMinY) + ConfigManager.aluminumMinY;
                    z = chunkZ * 16 + random.nextInt(16);
                    ore_aluminum.func_180709_b(world, random, new BlockPos(x, y, z));
                }
            }
            if (ConfigManager.enableNickel) {
                WorldGenMinable ore_nickel = new WorldGenMinable(RegistryManager.ore_nickel.func_176223_P(), ConfigManager.nickelVeinSize);
                for (i = 0; i < ConfigManager.nickelVeinsPerChunk; ++i) {
                    x = chunkX * 16 + random.nextInt(16);
                    y = random.nextInt(ConfigManager.nickelMaxY - ConfigManager.nickelMinY) + ConfigManager.nickelMinY;
                    z = chunkZ * 16 + random.nextInt(16);
                    ore_nickel.func_180709_b(world, random, new BlockPos(x, y, z));
                }
            }
            if (ConfigManager.enableTin) {
                WorldGenMinable ore_tin = new WorldGenMinable(RegistryManager.ore_tin.func_176223_P(), ConfigManager.tinVeinSize);
                for (i = 0; i < ConfigManager.tinVeinsPerChunk; ++i) {
                    x = chunkX * 16 + random.nextInt(16);
                    y = random.nextInt(ConfigManager.tinMaxY - ConfigManager.tinMinY) + ConfigManager.tinMinY;
                    z = chunkZ * 16 + random.nextInt(16);
                    ore_tin.func_180709_b(world, random, new BlockPos(x, y, z));
                }
            }
        }
    }
}

