/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import teamroots.embers.ConfigManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberRemoveEvent;
import teamroots.embers.api.item.IHeldEmberCell;
import teamroots.embers.api.item.IInventoryEmberCell;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.compat.BaublesIntegration;

public class EmberInventoryUtil {
    public static double getEmberCapacityTotal(EntityPlayer player) {
        ItemStack heldItem;
        IEmberCapability capability;
        IEmberCapability capability2;
        double amount = 0.0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) || !((capability2 = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IInventoryEmberCell)) continue;
            amount += capability2.getEmberCapacity();
        }
        ItemStack offhandItem = player.func_184586_b(EnumHand.OFF_HAND);
        if (offhandItem.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability = (IEmberCapability)offhandItem.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IHeldEmberCell) {
            amount += capability.getEmberCapacity();
        }
        if ((heldItem = player.func_184586_b(EnumHand.MAIN_HAND)).hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability2 = (IEmberCapability)heldItem.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IHeldEmberCell) {
            amount += capability2.getEmberCapacity();
        }
        if (ConfigManager.isBaublesIntegrationEnabled()) {
            amount += BaublesIntegration.getEmberCapacityTotal(player);
        }
        return amount;
    }

    public static double getEmberTotal(EntityPlayer player) {
        ItemStack heldItem;
        IEmberCapability capability;
        IEmberCapability capability2;
        double amount = 0.0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) || !((capability2 = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IInventoryEmberCell)) continue;
            amount += capability2.getEmber();
        }
        ItemStack offhandItem = player.func_184586_b(EnumHand.OFF_HAND);
        if (offhandItem.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability = (IEmberCapability)offhandItem.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IHeldEmberCell) {
            amount += capability.getEmber();
        }
        if ((heldItem = player.func_184586_b(EnumHand.MAIN_HAND)).hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability2 = (IEmberCapability)heldItem.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IHeldEmberCell) {
            amount += capability2.getEmber();
        }
        if (ConfigManager.isBaublesIntegrationEnabled()) {
            amount += BaublesIntegration.getEmberTotal(player);
        }
        return amount;
    }

    public static void removeEmber(EntityPlayer player, double amount) {
        IEmberCapability capability;
        ItemStack heldItem;
        IEmberCapability capability2;
        EmberRemoveEvent event = new EmberRemoveEvent(player, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        double temp = event.getFinal();
        ItemStack offhandItem = player.func_184586_b(EnumHand.OFF_HAND);
        if (offhandItem.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability2 = (IEmberCapability)offhandItem.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IHeldEmberCell) {
            temp -= capability2.removeAmount(temp, true);
        }
        if ((heldItem = player.func_184586_b(EnumHand.MAIN_HAND)).hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability = (IEmberCapability)heldItem.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IHeldEmberCell) {
            temp -= capability.removeAmount(temp, true);
        }
        if (ConfigManager.isBaublesIntegrationEnabled()) {
            temp = BaublesIntegration.removeEmber(player, temp);
        }
        for (int i = 0; i < 36; ++i) {
            IEmberCapability capability3;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) || !((capability3 = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) instanceof IInventoryEmberCell)) continue;
            temp -= capability3.removeAmount(temp, true);
        }
    }
}

