/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityRelay
extends TileEntity
implements ITileEntityBase,
IEmberPacketProducer,
IEmberPacketReceiver,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    public BlockPos target = null;
    public long ticksExisted = 0L;
    Random random = new Random();
    int offset = this.random.nextInt(40);
    boolean polled = false;
    public EnumConnection up = EnumConnection.NONE;
    public EnumConnection down = EnumConnection.NONE;
    public EnumConnection north = EnumConnection.NONE;
    public EnumConnection south = EnumConnection.NONE;
    public EnumConnection east = EnumConnection.NONE;
    public EnumConnection west = EnumConnection.NONE;

    public static EnumConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumConnection.NONE;
            }
            case 1: {
                return EnumConnection.LEVER;
            }
        }
        return EnumConnection.NONE;
    }

    public TileEntityRelay() {
        this.capability.setEmberCapacity(0.0);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.DOWN);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        if (this.target != null) {
            tag.func_74768_a("targetX", this.target.func_177958_n());
            tag.func_74768_a("targetY", this.target.func_177956_o());
            tag.func_74768_a("targetZ", this.target.func_177952_p());
        }
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityRelay.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityRelay.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityRelay.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityRelay.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityRelay.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityRelay.connectionFromInt(tag.func_74762_e("east"));
        if (tag.func_74764_b("targetX")) {
            this.target = new BlockPos(tag.func_74762_e("targetX"), tag.func_74762_e("targetY"), tag.func_74762_e("targetZ"));
        }
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing face;
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150442_at && ((face = ((BlockLever.EnumOrientation)world.func_180495_p(pos).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN)) {
            return EnumConnection.LEVER;
        }
        return EnumConnection.NONE;
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        if (pos.compareTo((Vec3i)this.func_174877_v()) != 0) {
            this.capability.setEmberCapacity(200.0);
            this.target = pos;
            this.func_70296_d();
        }
    }

    @Override
    public boolean isFull() {
        TileEntity tile;
        this.polled = true;
        if (this.target != null && ((tile = this.func_145831_w().func_175625_s(this.target)) instanceof TileEntityRelay ? ((TileEntityRelay)tile).target != null && !((TileEntityRelay)tile).polled && ((TileEntityRelay)tile).target.compareTo((Vec3i)this.func_174877_v()) != 0 : tile instanceof IEmberPacketReceiver)) {
            return ((IEmberPacketReceiver)tile).isFull();
        }
        return true;
    }

    @Override
    public boolean onReceive(EntityEmberPacket packet) {
        if (this.target != null) {
            packet.dest = this.target;
            packet.lifetime = 80;
        } else {
            packet.dest = this.func_174877_v();
        }
        this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundManager.EMBER_RELAY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return false;
    }

    public void func_73660_a() {
        this.polled = false;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public static enum EnumConnection {
        NONE,
        LEVER;

    }
}

