/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.crafttweaker.CTUtil;
import teamroots.embers.recipe.DawnstoneAnvilRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenRegister
@ZenClass(value="mods.embers.DawnstoneAnvil")
public class DawnstoneAnvil {
    public static final String NAME = "DawnstoneAnvil";
    public static final String CLASS = "mods.embers.DawnstoneAnvil";

    @ZenMethod
    public static void add(IItemStack[] outputs, IIngredient bottom, IIngredient top) {
        DawnstoneAnvilRecipe recipe = new DawnstoneAnvilRecipe(CTUtil.toIngredient(bottom), CTUtil.toIngredient(top), CraftTweakerMC.getItemStacks((IItemStack[])outputs));
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack bottom, IItemStack top) {
        CraftTweakerAPI.apply((IAction)new RemoveByInput(CraftTweakerMC.getItemStack((IItemStack)bottom), CraftTweakerMC.getItemStack((IItemStack)top)));
    }

    @ZenMethod
    public static void blacklistRepair(IIngredient match) {
        CraftTweakerAPI.apply((IAction)new BlacklistRepair(CTUtil.toIngredient(match)));
    }

    @ZenMethod
    public static void blacklistMateriaRepair(IIngredient match) {
        CraftTweakerAPI.apply((IAction)new BlacklistMateria(CTUtil.toIngredient(match)));
    }

    @ZenMethod
    public static void blacklistBreakdown(IIngredient match) {
        CraftTweakerAPI.apply((IAction)new BlacklistBreakdown(CTUtil.toIngredient(match)));
    }

    private static List<DawnstoneAnvilRecipe> getRecipesByInput(ItemStack bottom, ItemStack top) {
        return RecipeRegistry.dawnstoneAnvilRecipes.stream().filter(recipe -> recipe.bottom.apply(bottom) && recipe.top.apply(top)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class BlacklistBreakdown
    implements IAction {
        Ingredient match;

        public BlacklistBreakdown(Ingredient match) {
            this.match = match;
        }

        public void apply() {
            RecipeRegistry.dawnstoneBreakdownBlacklist.add(this.match);
        }

        public String describe() {
            return String.format("Blacklisting %s from being broken down at Dawnstone Anvil.", this.match);
        }
    }

    public static class BlacklistMateria
    implements IAction {
        Ingredient match;

        public BlacklistMateria(Ingredient match) {
            this.match = match;
        }

        public void apply() {
            RecipeRegistry.dawnstoneMateriaBlacklist.add(this.match);
        }

        public String describe() {
            return String.format("Blacklisting %s from being repaired with Isolated Materia.", this.match);
        }
    }

    public static class BlacklistRepair
    implements IAction {
        Ingredient match;

        public BlacklistRepair(Ingredient match) {
            this.match = match;
        }

        public void apply() {
            RecipeRegistry.dawnstoneRepairBlacklist.add(this.match);
        }

        public String describe() {
            return String.format("Blacklisting %s from being repaired at Dawnstone Anvil.", this.match);
        }
    }

    public static class RemoveByInput
    implements IAction {
        ItemStack bottom;
        ItemStack top;

        public RemoveByInput(ItemStack bottom, ItemStack top) {
            this.bottom = bottom;
            this.top = top;
        }

        public void apply() {
            RecipeRegistry.dawnstoneAnvilRecipes.removeAll(DawnstoneAnvil.getRecipesByInput(this.bottom, this.top));
        }

        public String describe() {
            return String.format("Removing %s recipes with inputs: %s,%s", DawnstoneAnvil.NAME, this.bottom, this.top);
        }
    }

    public static class Add
    implements IAction {
        DawnstoneAnvilRecipe recipe;

        public Add(DawnstoneAnvilRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRegistry.dawnstoneAnvilRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", DawnstoneAnvil.NAME, this.recipe.toString());
        }
    }
}

