/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.alchemy;

import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.item.ItemAlchemicWaste;

public class AlchemyResult {
    double accuracy;
    HashMap<String, Integer> deltas = new HashMap();
    int totalAsh;
    boolean allPresent = true;

    public double getAccuracy() {
        return this.accuracy;
    }

    public double getTotal() {
        return this.totalAsh;
    }

    public boolean areAllPresent() {
        return this.allPresent;
    }

    public static AlchemyResult create(AspectList list, AspectList.AspectRangeList range, World world) {
        AlchemyResult result = new AlchemyResult();
        double totalDelta = 0.0;
        double totalCompare = 0.0;
        for (String aspect : range.minAspects.getAspects()) {
            int amt = list.getAspect(aspect);
            if (amt < range.getMin(aspect)) {
                result.allPresent = false;
            }
            int compareAmt = range.getExact(aspect, world);
            double delta = Math.abs(amt - compareAmt);
            result.totalAsh += amt;
            totalDelta += delta;
            totalCompare += (double)compareAmt;
            result.deltas.put(aspect, (int)delta);
        }
        result.accuracy = Math.max(0.0, 1.0 - totalDelta / totalCompare);
        result.accuracy = (double)Math.round(result.accuracy * 100.0) / 100.0;
        return result;
    }

    public ItemStack createFailure() {
        return ItemAlchemicWaste.create(new AspectList(this.deltas));
    }
}

