/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations;

import crafttweaker.CraftTweakerAPI;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.AltarRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.GameStageTweaks;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.GrindstoneRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.InfusionRecipe;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.LightTransmutations;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.LiquidInteraction;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.PerkTree;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.Utils;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.tweaks.WellRecipe;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;

public class ModIntegrationCrafttweaker {
    public static ModIntegrationCrafttweaker instance = new ModIntegrationCrafttweaker();
    public static List<SerializeableRecipe> recipeModifications = new LinkedList<SerializeableRecipe>();

    private ModIntegrationCrafttweaker() {
    }

    public void load() {
        CraftTweakerAPI.registerClass(InfusionRecipe.class);
        CraftTweakerAPI.registerClass(GrindstoneRecipe.class);
        CraftTweakerAPI.registerClass(LightTransmutations.class);
        CraftTweakerAPI.registerClass(AltarRecipe.class);
        CraftTweakerAPI.registerClass(WellRecipe.class);
        CraftTweakerAPI.registerClass(LiquidInteraction.class);
        CraftTweakerAPI.registerClass(PerkTree.class);
        CraftTweakerAPI.registerClass(Utils.class);
        CraftTweakerAPI.registerClass(GameStageTweaks.class);
        MinecraftForge.EVENT_BUS.register((Object)new PerkTree());
    }

    public void pushChanges() {
        AstralSorcery.log.info("Got " + recipeModifications.size() + " recipe modifications from CraftTweaker. - Applying...");
        for (SerializeableRecipe recipe : recipeModifications) {
            try {
                recipe.applyRecipe();
            }
            catch (Exception exc) {
                AstralSorcery.log.error("Couldn't apply RecipeModification for type " + recipe.getType().name().toLowerCase());
                exc.printStackTrace();
            }
        }
        AstralSorcery.log.info("Recipe changes applied.");
    }
}

