/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.config;

import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ConfigDataAdapter<T extends DataSet> {
    public Iterable<T> getDefaultDataSets();

    public String getDataFileName();

    public String getDescription();

    @Nullable
    public Optional<T> appendDataSet(String var1);

    public void resetRegistry();

    default public LoadPhase getLoadPhase() {
        return LoadPhase.PRE_INIT;
    }

    @Nonnull
    default public String[] serializeDataSet() {
        LinkedList<String> defaultValueStrings = new LinkedList<String>();
        for (DataSet data : this.getDefaultDataSets()) {
            defaultValueStrings.add(data.serialize());
        }
        String[] out = new String[defaultValueStrings.size()];
        return defaultValueStrings.toArray(out);
    }

    public static interface DataSet {
        @Nonnull
        public String serialize();

        public static class StringElement
        implements DataSet {
            private final String str;

            public StringElement(@Nonnull String str) {
                this.str = str;
            }

            @Override
            @Nonnull
            public String serialize() {
                return this.str;
            }
        }
    }

    public static enum LoadPhase {
        PRE_INIT,
        INIT,
        POST_INIT;

    }
}

