/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes.upgrade;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.common.block.BlockMarble;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.crafting.IAltarUpgradeRecipe;
import hellfirepvp.astralsorcery.common.crafting.INighttimeRecipe;
import hellfirepvp.astralsorcery.common.crafting.ISpecialCraftingEffects;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapeMap;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.OreDictAlias;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConstellationUpgradeRecipe
extends AttunementRecipe
implements IAltarUpgradeRecipe,
INighttimeRecipe,
ISpecialCraftingEffects {
    private static Vector3[] offsetPillars = new Vector3[]{new Vector3(3, 2, 3), new Vector3(-3, 2, 3), new Vector3(3, 2, -3), new Vector3(-3, 2, -3)};

    public ConstellationUpgradeRecipe() {
        super(ConstellationUpgradeRecipe.shapedRecipe("upgrade_tier3", new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_3.ordinal())).addPart(BlockMarble.MarbleBlockType.PILLAR.asStack(), ShapedRecipeSlot.LOWER_LEFT, ShapedRecipeSlot.LOWER_RIGHT).addPart(BlockMarble.MarbleBlockType.CHISELED.asStack(), ShapedRecipeSlot.RIGHT, ShapedRecipeSlot.LEFT).addPart(OreDictAlias.ITEM_STARMETAL_INGOT, ShapedRecipeSlot.LOWER_CENTER).addPart(OreDictAlias.ITEM_AQUAMARINE, ShapedRecipeSlot.UPPER_LEFT, ShapedRecipeSlot.UPPER_RIGHT).addPart(ItemHandle.getCrystalVariant(false, false), ShapedRecipeSlot.CENTER).unregisteredAccessibleShapedRecipe());
        this.setAttItem(BlockMarble.MarbleBlockType.CHISELED.asStack(), AttunementRecipe.AttunementAltarSlot.LOWER_LEFT, AttunementRecipe.AttunementAltarSlot.LOWER_RIGHT);
        this.setAttItem(OreDictAlias.ITEM_STARMETAL_DUST, AttunementRecipe.AttunementAltarSlot.UPPER_RIGHT, AttunementRecipe.AttunementAltarSlot.UPPER_LEFT);
    }

    @Override
    public TileAltar.AltarLevel getLevelUpgradingTo() {
        return TileAltar.AltarLevel.CONSTELLATION_CRAFT;
    }

    @Override
    @Nonnull
    public ItemStack getOutputForRender() {
        return new ItemStack((Block)BlocksAS.blockAltar, 1, BlockAltar.AltarType.ALTAR_3.ordinal());
    }

    @Override
    @Nonnull
    public ItemStack getOutput(ShapeMap centralGridMap, TileAltar tileAltar) {
        return ItemStack.field_190927_a;
    }

    @Override
    public int craftingTickTime() {
        return super.craftingTickTime() * 4;
    }

    @Override
    public AbstractAltarRecipe copyNewEffectInstance() {
        return new ConstellationUpgradeRecipe();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 altarVec = new Vector3(altar);
            Vector3 thisAltar = altarVec.clone().add(0.5, 0.5, 0.5);
            for (int i = 0; i < 3; ++i) {
                Vector3 dir = offsetPillars[rand.nextInt(offsetPillars.length)].clone();
                dir.multiply(rand.nextFloat()).add(thisAltar.clone());
                EntityFXFacingParticle particle = EffectHelper.genericFlareParticle(dir.getX(), dir.getY(), dir.getZ());
                particle.setColor(MiscUtils.calcRandomConstellationColor(rand.nextFloat())).scale(0.2f + 0.2f * rand.nextFloat()).gravity(0.004);
            }
            ParticleManager pm = Minecraft.func_71410_x().field_71452_i;
            if (rand.nextInt(18) == 0) {
                pm.func_180533_a(altar.func_174877_v(), BlocksAS.blockMarble.func_176223_P());
            }
            if (tick % 48L == 0L && rand.nextInt(2) == 0) {
                EffectHandler.getInstance().textureSpritePlane(SpriteLibrary.spriteCraftBurst, Vector3.RotAxis.Y_AXIS.clone()).setPosition(new Vector3(altar).add(0.5, 0.05, 0.5)).setScale(5 + rand.nextInt(2)).setNoRotation(rand.nextInt(360));
            }
        }
    }
}

