/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.ASMConstants;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;
import squeek.asmhelper.applecore.ObfHelper;

public class ModuleBlockFood
implements IClassTransformerModule {
    private static String isEdibleAtMaxHungerField = "AppleCore_isEdibleAtMaxHunger";

    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.block.BlockCake"};
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        this.implementIEdibleBlock(classNode);
        MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_180682_b", "eatCake", ASMHelper.toMethodDescriptor("Z", "net.minecraft.world.World", "net.minecraft.util.math.BlockPos", "net.minecraft.block.state.IBlockState", "net.minecraft.entity.player.EntityPlayer"));
        if (methodNode != null) {
            this.addOnBlockFoodEatenHook(classNode, methodNode);
            this.addAlwaysEdibleCheck(classNode, methodNode);
            return ASMHelper.writeClassToBytes(classNode, 2);
        }
        throw new RuntimeException("BlockCake: eatCake (func_180682_b) method not found");
    }

    private void implementIEdibleBlock(ClassNode classNode) {
        classNode.interfaces.add(ASMHelper.toInternalClassName("squeek.applecore.api.food.IEdible"));
        classNode.interfaces.add(ASMHelper.toInternalClassName("squeek.applecore.api.food.IEdibleBlock"));
        MethodVisitor mv = classNode.visitMethod(1, "getFoodValues", "(Lnet/minecraft/item/ItemStack;)Lsqueek/applecore/api/food/FoodValues;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitTypeInsn(187, "squeek/applecore/api/food/FoodValues");
        mv.visitInsn(89);
        mv.visitInsn(5);
        mv.visitLdcInsn((Object)new Float("0.1"));
        mv.visitMethodInsn(183, "squeek/applecore/api/food/FoodValues", "<init>", "(IF)V", false);
        mv.visitInsn(176);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", ASMHelper.toDescriptor(classNode.name), null, l0, l1, 0);
        mv.visitLocalVariable("itemStack", "Lnet/minecraft/item/ItemStack;", null, l0, l1, 1);
        mv.visitMaxs(4, 2);
        mv.visitEnd();
        classNode.fields.add(new FieldNode(1, isEdibleAtMaxHungerField, "Z", null, null));
        mv = classNode.visitMethod(1, "setEdibleAtMaxHunger", ASMHelper.toMethodDescriptor("V", "Z"), null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitFieldInsn(181, ASMHelper.toInternalClassName(classNode.name), isEdibleAtMaxHungerField, "Z");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    private void addOnBlockFoodEatenHook(ClassNode classNode, MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 4));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), "*", "*", false));
        needle.add((AbstractInsnNode)new InsnNode(5));
        needle.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.1f)));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.util.FoodStats"), "*", "(IF)V", false));
        InsnList replacement = new InsnList();
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 1));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 4));
        replacement.add((AbstractInsnNode)new MethodInsnNode(184, ASMConstants.HOOKS_INTERNAL_CLASS, "onBlockFoodEaten", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/World;Lnet/minecraft/entity/player/EntityPlayer;)V", false));
        if (ASMHelper.findAndReplace(method.instructions, needle, replacement) == null) {
            throw new RuntimeException("Could not replace FoodStats.addStats call in " + classNode.name + "." + method.name + "\n" + ASMHelper.getMethodAsString(method));
        }
    }

    private void addAlwaysEdibleCheck(ClassNode classNode, MethodNode method) {
        AbstractInsnNode pushFalse = ASMHelper.findFirstInstructionWithOpcode(method, 3);
        if (pushFalse == null) {
            throw new RuntimeException("ICONST_0 instruction not found in " + classNode.name + "." + method.name);
        }
        InsnList pushField = new InsnList();
        pushField.add((AbstractInsnNode)new VarInsnNode(25, 0));
        pushField.add((AbstractInsnNode)new FieldInsnNode(180, ASMHelper.toInternalClassName(classNode.name), isEdibleAtMaxHungerField, "Z"));
        method.instructions.insert(pushFalse, pushField);
        method.instructions.remove(pushFalse);
    }
}

