/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.refinedstorage.conduit;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeVisitor;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.util.Action;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.item.FunctionUpgrade;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.conduit.refinedstorage.RSHelper;
import crazypants.enderio.conduit.refinedstorage.conduit.IRefinedStorageConduit;
import crazypants.enderio.conduit.refinedstorage.init.ConduitRefinedStorageObject;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ConduitRefinedStorageNode
implements INetworkNode,
INetworkNodeVisitor {
    @Nonnull
    public static final String ID = "rs_conduit";
    @Nullable
    protected INetwork rsNetwork;
    @Nonnull
    protected World world;
    @Nonnull
    protected BlockPos pos;
    @Nonnull
    protected IRefinedStorageConduit con;
    protected int compare = 1;
    private int tickCount = 0;
    private int itemsPerTick = 4;
    @Nonnull
    private Queue<EnumFacing> dirsToCheck;
    private int currentSlot;
    private int importFilterSlot;
    private int exportFilterSlot;
    private int slotsToCheck;

    public ConduitRefinedStorageNode(@Nonnull IRefinedStorageConduit con) {
        this.con = con;
        this.world = con.getBundle().getBundleworld();
        this.pos = con.getBundle().getLocation();
        this.dirsToCheck = new LinkedList<EnumFacing>();
        for (EnumFacing dir : EnumFacing.values()) {
            this.dirsToCheck.offer(dir);
        }
    }

    public int getEnergyUsage() {
        return 0;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return new ItemStack(ConduitRefinedStorageObject.item_refined_storage_conduit.getItemNN(), 1);
    }

    public void onConnected(INetwork network) {
        this.rsNetwork = network;
    }

    public void onDisconnected(INetwork network) {
        this.rsNetwork = null;
    }

    public boolean canUpdate() {
        return this.con.hasExternalConnections();
    }

    @Nullable
    public INetwork getNetwork() {
        return this.rsNetwork;
    }

    public void update() {
        if (this.canUpdate()) {
            ++this.tickCount;
            if (this.rsNetwork != null && this.tickCount > 4) {
                this.tickCount = 0;
                for (int i = 0; i < this.dirsToCheck.size(); ++i) {
                    EnumFacing dir = this.dirsToCheck.poll();
                    this.dirsToCheck.offer(dir);
                    if (this.con.containsExternalConnection(dir) && this.updateDir(dir)) break;
                }
            }
        }
    }

    private boolean updateDir(@Nonnull EnumFacing dir) {
        TileEntity te = this.world.func_175625_s(this.pos.func_177972_a(dir));
        boolean done = false;
        if (te != null && !(te instanceof IStorageProvider)) {
            done = this.updateDirItems(dir, te);
            done = done || this.updateDirFluids(dir, te);
        }
        return done;
    }

    private boolean updateDirFluids(@Nonnull EnumFacing dir, @Nonnull TileEntity te) {
        IFluidHandler handler;
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()) && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())) != null) {
            IFilter inFilt;
            IFilter outFilt = this.con.getOutputFilter(dir);
            if (outFilt instanceof IFluidFilter) {
                IFluidFilter exportFilter = (IFluidFilter)outFilt;
                FluidStack stack = null;
                if (!exportFilter.isEmpty()) {
                    do {
                        if ((stack = exportFilter.getFluidStackAt(this.exportFilterSlot >= exportFilter.getSlotCount() ? (this.exportFilterSlot = 0) : this.exportFilterSlot)) != null) continue;
                        ++this.exportFilterSlot;
                    } while (stack == null);
                }
                ItemStack upgrade = this.con.getUpgradeStack(dir.ordinal());
                FunctionUpgrade up = null;
                if (!upgrade.func_190926_b()) {
                    up = ((ItemFunctionUpgrade)upgrade.func_77973_b()).getFunctionUpgrade();
                }
                if (stack != null) {
                    int toExtract = 1000;
                    FluidStack stackInStorage = (FluidStack)this.rsNetwork.getFluidStorageCache().getList().get((Object)stack, this.compare);
                    if (stackInStorage != null) {
                        int filled;
                        FluidStack took = this.rsNetwork.extractFluid(stack, toExtract = Math.min(toExtract, stackInStorage.amount), this.compare, Action.SIMULATE);
                        if (took != null && (filled = handler.fill(took, false)) > 0) {
                            took = this.rsNetwork.extractFluid(stack, filled, this.compare, Action.PERFORM);
                            handler.fill(took, true);
                            ++this.exportFilterSlot;
                            return true;
                        }
                    } else if (up != null && this.isCraftingUpgrade(up)) {
                        this.rsNetwork.getCraftingManager().request(stack, toExtract);
                    }
                }
            }
            if ((inFilt = this.con.getInputFilter(dir)) instanceof IFluidFilter) {
                IFluidFilter importFilter = (IFluidFilter)inFilt;
                boolean all = importFilter.isEmpty();
                FluidStack toDrain = handler.drain(1000, false);
                FluidStack stack = null;
                if (!all) {
                    do {
                        if ((stack = importFilter.getFluidStackAt(this.importFilterSlot >= importFilter.getSlotCount() ? (this.importFilterSlot = 0) : this.importFilterSlot)) != null) continue;
                        ++this.importFilterSlot;
                    } while (stack == null);
                }
                if ((all || stack != null && toDrain != null && stack.isFluidEqual(toDrain)) && toDrain != null) {
                    FluidStack remainder = this.rsNetwork.insertFluidTracked(toDrain, toDrain.amount);
                    if (remainder != null) {
                        toDrain.amount -= remainder.amount;
                    }
                    handler.drain(toDrain, true);
                    ++this.importFilterSlot;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean updateDirItems(@Nonnull EnumFacing dir, @Nonnull TileEntity te) {
        IItemHandler handler;
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()) && (handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) != null) {
            IFilter inFilt;
            ItemStack upgrade = this.con.getUpgradeStack(dir.ordinal());
            FunctionUpgrade up = null;
            if (!upgrade.func_190926_b()) {
                up = ((ItemFunctionUpgrade)upgrade.func_77973_b()).getFunctionUpgrade();
                this.itemsPerTick = up.getMaximumExtracted(64);
            } else {
                this.itemsPerTick = 4;
            }
            IFilter outFilt = this.con.getOutputFilter(dir);
            if (outFilt instanceof IItemFilter) {
                IItemFilter exportFilter = (IItemFilter)outFilt;
                ItemStack slot = ItemStack.field_190927_a;
                if (!exportFilter.isEmpty()) {
                    do {
                        if (!(slot = exportFilter.getInventorySlotContents(this.exportFilterSlot >= exportFilter.getSlotCount() ? (this.exportFilterSlot = 0) : this.exportFilterSlot)).func_190926_b()) continue;
                        ++this.exportFilterSlot;
                    } while (slot.func_190926_b());
                }
                if (!slot.func_190926_b()) {
                    ItemStack took = this.rsNetwork.extractItem(slot, Math.min(slot.func_77976_d(), this.itemsPerTick), this.compare, Action.SIMULATE);
                    if (took == null) {
                        if (up != null && this.isCraftingUpgrade(up)) {
                            this.rsNetwork.getCraftingManager().request(slot, this.itemsPerTick);
                        } else {
                            ++this.exportFilterSlot;
                        }
                        return false;
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true).func_190926_b() && (took = this.rsNetwork.extractItem(slot, Math.min(slot.func_77976_d(), this.itemsPerTick), this.compare, Action.PERFORM)) != null) {
                        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                        ++this.exportFilterSlot;
                        return true;
                    }
                }
            }
            if ((inFilt = this.con.getInputFilter(dir)) instanceof IItemFilter) {
                IItemFilter importFilter = (IItemFilter)inFilt;
                boolean all = importFilter.isEmpty();
                ItemStack slot = ItemStack.field_190927_a;
                if (!all) {
                    do {
                        if (!(slot = importFilter.getInventorySlotContents(this.importFilterSlot >= importFilter.getSlotCount() ? (this.importFilterSlot = 0) : this.importFilterSlot)).func_190926_b()) continue;
                        ++this.importFilterSlot;
                        this.slotsToCheck = 0;
                    } while (slot.func_190926_b());
                }
                if (all || !slot.func_190926_b()) {
                    if (this.currentSlot >= handler.getSlots()) {
                        this.currentSlot = 0;
                    }
                    if (handler.getSlots() > 0) {
                        while (this.currentSlot + 1 < handler.getSlots() && (handler.getStackInSlot(this.currentSlot).func_190926_b() || !all && !handler.getStackInSlot(this.currentSlot).func_77969_a(importFilter.getInventorySlotContents(this.importFilterSlot)))) {
                            ++this.currentSlot;
                            ++this.slotsToCheck;
                            if (this.slotsToCheck < handler.getSlots()) continue;
                            ++this.importFilterSlot;
                        }
                        ItemStack stack = handler.getStackInSlot(this.currentSlot);
                        ItemStack result = handler.extractItem(this.currentSlot, this.itemsPerTick, true);
                        if (!result.func_190926_b() && this.rsNetwork.insertItem(result, result.func_190916_E(), Action.SIMULATE) == null) {
                            result = handler.extractItem(this.currentSlot, this.itemsPerTick, false);
                            if (!result.func_190926_b()) {
                                this.rsNetwork.insertItemTracked(result, result.func_190916_E());
                            }
                        } else {
                            ++this.currentSlot;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean isCraftingUpgrade(@Nonnull FunctionUpgrade functionUpgrade) {
        return functionUpgrade == FunctionUpgrade.RS_CRAFTING_UPGRADE || functionUpgrade == FunctionUpgrade.RS_CRAFTING_SPEED_UPGRADE || functionUpgrade == FunctionUpgrade.RS_CRAFTING_SPEED_DOWNGRADE;
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        return tag;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    public void markDirty() {
        if (!this.world.field_72995_K) {
            RSHelper.API.getNetworkNodeManager(this.world).markForSaving();
        }
    }

    public String getId() {
        return ID;
    }

    public boolean equals(Object right) {
        return RSHelper.API.isNetworkNodeEqual((INetworkNode)this, right);
    }

    public int hashCode() {
        return RSHelper.API.getNetworkNodeHashCode((INetworkNode)this);
    }

    public boolean canConduct(@Nonnull EnumFacing direction) {
        return this.con.containsConduitConnection(direction) || this.con.getConnectionMode(direction) != ConnectionMode.DISABLED;
    }

    public void visit(INetworkNodeVisitor.Operator operator) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.canConduct(facing)) continue;
            operator.apply(this.world, this.pos.func_177972_a(facing), facing.func_176734_d());
        }
    }

    public void onConduitConnectionChange() {
        if (this.rsNetwork != null) {
            this.rsNetwork.getNodeGraph().rebuild();
        }
    }
}

