/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.base.Predicate;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.direct.DirectUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.alloy.Alloy;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.util.Prep;
import info.loenwind.autoconfig.factory.IValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemDarkSteelShears
extends ItemShears
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IOverlayRenderAware {
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();
    private final EntityComparator entityComparator = new EntityComparator();
    @Nonnull
    private static final Predicate<Entity> selectShearable = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof IShearable && !entity.field_70128_L && ((IShearable)entity).isShearable(Prep.getEmpty(), (IBlockAccess)entity.field_70170_p, entity.func_180425_c());
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    };

    public static boolean isEquipped(EntityPlayer player) {
        return player != null && player.func_184614_ca().func_77973_b() == ModObject.itemDarkSteelAxe.getItem();
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelShears.getStoredPower(player) > requiredPower;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, IValue<Integer> requiredPower) {
        return ItemDarkSteelShears.getStoredPower(player) > (Integer)requiredPower.get();
    }

    public static int getStoredPower(EntityPlayer player) {
        return EnergyUpgradeManager.getEnergyStored(player.func_184614_ca());
    }

    public static ItemDarkSteelShears create(@Nonnull IModObject modObject, @Nullable Block block) {
        ItemDarkSteelShears res = new ItemDarkSteelShears(modObject);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemDarkSteelShears(@Nonnull IModObject modObject) {
        this.func_77656_e(this.func_77612_l() * (Integer)DarkSteelConfig.shearsDurabilityFactor.get());
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 2;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            DirectUpgrade.INSTANCE.addToItem(is, this);
            list.add((Object)is);
        }
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        int powerStored = ItemDarkSteelShears.getStoredPower(player);
        if (powerStored < (Integer)DarkSteelConfig.shearsPowerUsePerDamagePoint.get()) {
            return this.super_onBlockStartBreak(itemstack, pos, player);
        }
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int dx = -((Integer)DarkSteelConfig.shearsBlockAreaBoostWhenPowered.get()).intValue(); dx <= (Integer)DarkSteelConfig.shearsBlockAreaBoostWhenPowered.get(); ++dx) {
            for (int dy = -((Integer)DarkSteelConfig.shearsBlockAreaBoostWhenPowered.get()).intValue(); dy <= (Integer)DarkSteelConfig.shearsBlockAreaBoostWhenPowered.get(); ++dy) {
                for (int dz = -((Integer)DarkSteelConfig.shearsBlockAreaBoostWhenPowered.get()).intValue(); dz <= (Integer)DarkSteelConfig.shearsBlockAreaBoostWhenPowered.get(); ++dz) {
                    Block block2 = player.field_70170_p.func_180495_p(new BlockPos(x + dx, y + dy, z + dz)).func_177230_c();
                    if (!(block2 instanceof IShearable) || !((IShearable)block2).isShearable(itemstack, (IBlockAccess)player.field_70170_p, new BlockPos(x + dx, y + dy, z + dz))) continue;
                    res.add(new BlockPos(x + dx, y + dy, z + dz));
                }
            }
        }
        NNList sortedTargets = new NNList(res);
        this.harvestComparator.refPoint = pos;
        Collections.sort(sortedTargets, this.harvestComparator);
        int maxBlocks = (Integer)DarkSteelConfig.shearsPowerUsePerDamagePoint.get() == 0 ? sortedTargets.size() : Math.min(sortedTargets.size(), powerStored / (Integer)DarkSteelConfig.shearsPowerUsePerDamagePoint.get());
        for (int i = 0; i < maxBlocks; ++i) {
            BlockPos bc2 = (BlockPos)sortedTargets.get(i);
            this.super_onBlockStartBreak(itemstack, bc2, player);
            if (bc2 == pos) continue;
            player.field_70170_p.func_175698_g(bc2);
        }
        return false;
    }

    public boolean super_onBlockStartBreak(@Nonnull ItemStack itemstack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return false;
        }
        IBlockState blockState = player.field_70170_p.func_180495_p(pos);
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, pos)) {
            List drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack));
            Random rand = new Random();
            drops = new NNList((Collection)drops);
            float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)player.field_70170_p, (BlockPos)pos, (IBlockState)blockState, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack), (float)1.0f, (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemstack) != 0 ? 1 : 0) != 0, (EntityPlayer)player);
            for (ItemStack stack : drops) {
                if (!(player.field_70170_p.field_73012_v.nextFloat() <= chance)) continue;
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            itemstack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71029_a(StatList.func_188055_a((Block)block));
            player.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            return true;
        }
        return false;
    }

    public boolean func_111207_a(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull EntityLivingBase entity, @Nonnull EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        int powerStored = ItemDarkSteelShears.getStoredPower(player);
        if (powerStored < (Integer)DarkSteelConfig.shearsPowerUsePerDamagePoint.get()) {
            return super.func_111207_a(itemstack, player, entity, hand);
        }
        if (entity instanceof IShearable) {
            AxisAlignedBB bb = new AxisAlignedBB(entity.field_70165_t - (double)((Float)DarkSteelConfig.shearsEntityAreaBoostWhenPowered.get()).floatValue(), entity.field_70163_u - (double)((Float)DarkSteelConfig.shearsEntityAreaBoostWhenPowered.get()).floatValue(), entity.field_70161_v - (double)((Float)DarkSteelConfig.shearsEntityAreaBoostWhenPowered.get()).floatValue(), entity.field_70165_t + (double)((Float)DarkSteelConfig.shearsEntityAreaBoostWhenPowered.get()).floatValue(), entity.field_70163_u + (double)((Float)DarkSteelConfig.shearsEntityAreaBoostWhenPowered.get()).floatValue(), entity.field_70161_v + (double)((Float)DarkSteelConfig.shearsEntityAreaBoostWhenPowered.get()).floatValue());
            ArrayList sortedTargets = new ArrayList(entity.field_70170_p.func_175647_a(Entity.class, bb, selectShearable));
            this.entityComparator.refPoint = entity;
            Collections.sort(sortedTargets, this.entityComparator);
            boolean result = false;
            int maxSheep = (Integer)DarkSteelConfig.shearsPowerUsePerDamagePoint.get() == 0 ? sortedTargets.size() : Math.min(sortedTargets.size(), powerStored / (Integer)DarkSteelConfig.shearsPowerUsePerDamagePoint.get());
            for (int i = 0; i < maxSheep; ++i) {
                Entity entity2 = (Entity)sortedTargets.get(i);
                if (!(entity2 instanceof EntityLivingBase) || !super.func_111207_a(itemstack, player, (EntityLivingBase)entity2, hand)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if ((double)evt.getOriginalSpeed() > 2.0 && ItemDarkSteelShears.isEquippedAndPowered(evt.getEntityPlayer(), DarkSteelConfig.shearsPowerUsePerDamagePoint)) {
            evt.setNewSpeed(evt.getOriginalSpeed() * ((Float)DarkSteelConfig.shearsEfficiencyBoostWhenPowered.get()).floatValue());
        }
    }

    public void setDamage(@Nonnull ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        }
        int damage = newDamage - oldDamage;
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * (Integer)DarkSteelConfig.shearsPowerUsePerDamagePoint.get(), false);
        } else {
            super.setDamage(stack, newDamage);
        }
        if (eu != null) {
            eu.writeToItem();
        }
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public int func_77619_b() {
        return EquipmentData.DARK_STEEL.getToolMaterial().func_77995_e();
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(Lang.SHEARS_MULTIHARVEST.get());
            list.add(Lang.SHEARS_POWERED.get(TextFormatting.WHITE, DarkSteelConfig.shearsEfficiencyBoostWhenPowered.get()));
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean isBlockBreakingTool() {
        return true;
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return EquipmentData.DARK_STEEL;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHEARS_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHEARS_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHEARS_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_SHEARS_ABSORPTION_RATIO;
    }

    private static class EntityComparator
    implements Comparator<Entity> {
        Entity refPoint;

        private EntityComparator() {
        }

        @Override
        public int compare(Entity paramT1, Entity paramT2) {
            double distanceSqToEntity2;
            double distanceSqToEntity1 = paramT1 == null ? 0.0 : this.refPoint.func_70068_e(paramT1);
            double d = distanceSqToEntity2 = paramT2 == null ? 0.0 : this.refPoint.func_70068_e(paramT2);
            if (distanceSqToEntity1 < distanceSqToEntity2) {
                return -1;
            }
            if (distanceSqToEntity1 > distanceSqToEntity2) {
                return 1;
            }
            return 0;
        }
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockPos> {
        BlockPos refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockPos arg0, BlockPos arg1) {
            double d1 = this.refPoint.func_177954_c((double)arg0.func_177958_n(), (double)arg0.func_177956_o(), (double)arg0.func_177952_p());
            double d2 = this.refPoint.func_177954_c((double)arg1.func_177958_n(), (double)arg1.func_177956_o(), (double)arg1.func_177952_p());
            return MultiHarvestComparator.compare(d1, d2);
        }

        public static int compare(double x, double y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

