/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config;

import com.enderio.core.common.event.ConfigFileChangedEvent;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.Log;
import info.loenwind.autoconfig.ConfigHandler;
import info.loenwind.autoconfig.factory.IRootFactory;
import java.io.File;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public final class Config
extends ConfigHandler {
    public Config(@Nonnull FMLPreInitializationEvent event, @Nonnull IRootFactory factory, String folder) {
        super(event, factory, folder);
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.getModID().equals(this.factory.getModid())) {
            Log.info("Reloading config file...");
            this.config.load();
            this.syncConfig();
            event.setSuccessful();
            Log.info("Config reload finished");
        }
    }

    @SubscribeEvent
    public void onConfigChanged(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(this.factory.getModid())) {
            Log.info("Updating config...");
            this.syncConfig();
            for (ModContainer modContainer : Loader.instance().getModList()) {
                if (!(modContainer.getMod() instanceof IEnderIOAddon) || modContainer.getModId().equals(this.factory.getModid())) continue;
                MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.OnConfigChangedEvent(modContainer.getModId(), null, event.isWorldRunning(), event.isRequiresMcRestart()));
            }
            Log.info("Config update finished");
        }
    }

    @SubscribeEvent
    public void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        if ("5.0.46".contains("-") || "5.0.46".contains("@")) {
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "This is an " + TextFormatting.BLACK + "Ender IO " + TextFormatting.DARK_RED + "development build!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "It may trash your world at any time!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Do not use it for anything but testing!"));
            evt.player.func_145747_a((ITextComponent)new TextComponentString("You have been warned..."));
        }
    }

    @Nonnull
    public File getConfigDirectory() {
        return this.configDirectory;
    }
}

