/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingRequest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketRequestsReady
implements IMessage {
    public BlockPos pos;
    public List<CraftingRequest> list;
    public String command;

    public PacketRequestsReady() {
    }

    public PacketRequestsReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketRequestsReady(BlockPos pos, String command, List<CraftingRequest> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<CraftingRequest>();
        this.list.addAll(list);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.command = NetworkTools.readString((ByteBuf)buf);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<CraftingRequest>(size);
            for (int i = 0; i < size; ++i) {
                String id = NetworkTools.readString((ByteBuf)buf);
                ItemStack stack = NetworkTools.readItemStack((ByteBuf)buf);
                int amount = buf.readInt();
                CraftingRequest request = new CraftingRequest(id, stack, amount);
                request.setOk(buf.readLong());
                request.setFailed(buf.readLong());
                this.list.add(request);
            }
        } else {
            this.list = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writeString((ByteBuf)buf, (String)this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (CraftingRequest item : this.list) {
                NetworkTools.writeString((ByteBuf)buf, (String)item.getTicket());
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)item.getStack());
                buf.writeInt(item.getTodo());
                buf.writeLong(item.getOk());
                buf.writeLong(item.getFailed());
            }
        }
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = RFToolsControl.proxy.getClientWorld().func_175625_s(this.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(CraftingRequest.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }
}

