/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual.wild;

import com.google.common.collect.Lists;
import epicsquid.mysticallib.util.ListUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.entity.EntityBeetle;
import epicsquid.mysticalworld.entity.EntityDeer;
import epicsquid.mysticalworld.entity.EntityFox;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.recipe.conditions.ConditionItems;
import epicsquid.roots.recipe.conditions.ConditionStandingStones;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.tileentity.TileEntityOffertoryPlate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class RitualSummonCreatures
extends RitualBase {
    private static Map<Class<? extends Entity>, List<ItemStack>> entityItem = new HashMap<Class<? extends Entity>, List<ItemStack>>();

    public RitualSummonCreatures(String name, int duration) {
        super(name, duration);
        this.addCondition(new ConditionItems(new ItemStack(ModItems.wildewheet), new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151110_aK), new ItemStack(Items.field_151078_bh), new ItemStack(ModItems.moonglow_leaf)));
        this.addCondition(new ConditionStandingStones(3, 3));
        entityItem.put(EntityChicken.class, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151076_bf)}));
        entityItem.put(EntityCow.class, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151082_bd)}));
        entityItem.put(EntityPig.class, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151147_al)}));
        entityItem.put(EntityFox.class, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(epicsquid.mysticalworld.init.ModItems.pelt)}));
        entityItem.put(EntityBeetle.class, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(epicsquid.mysticalworld.init.ModItems.carapace)}));
        entityItem.put(EntityDeer.class, Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151116_aA)}));
        this.setIcon(ModItems.ritual_summon_creatures);
        this.setColor(TextFormatting.DARK_PURPLE);
        this.setBold(true);
    }

    @Override
    public EntityRitualBase doEffect(World world, BlockPos pos) {
        List plateList = Util.getTileEntitiesWithin((World)world, TileEntityOffertoryPlate.class, (BlockPos)pos, (int)OFFERTORY_RADIUS);
        if (plateList.size() <= 0) {
            return null;
        }
        ArrayList<ItemStack> offertoryItems = new ArrayList<ItemStack>();
        for (TileEntityOffertoryPlate tileEntityOffertoryPlate : plateList) {
            if (tileEntityOffertoryPlate.getHeldItem().func_190926_b()) continue;
            offertoryItems.add(tileEntityOffertoryPlate.getHeldItem());
        }
        for (Map.Entry entry : entityItem.entrySet()) {
            if (!ListUtil.stackListsMatch((List)((List)entry.getValue()), offertoryItems)) continue;
            Entity entity = null;
            try {
                Constructor cons = ((Class)entry.getKey()).getDeclaredConstructor(World.class);
                entity = (Entity)cons.newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (entity == null) {
                return null;
            }
            entity.func_70107_b((double)pos.func_177958_n() + 1.5, (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (!world.field_72995_K) {
                world.func_72838_d(entity);
                for (TileEntityOffertoryPlate plate : plateList) {
                    plate.removeItem();
                }
                continue;
            }
            for (int i = 0; i < 10; ++i) {
                ParticleUtil.spawnParticleStar(world, (float)entity.field_70165_t + 0.5f * (Util.rand.nextFloat() - 0.5f), (float)(entity.field_70163_u + (double)(entity.field_70131_O / 2.5f) + (double)Util.rand.nextFloat()), (float)entity.field_70161_v + 0.5f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), 0.01875f * Util.rand.nextFloat(), 0.125f * (Util.rand.nextFloat() - 0.5f), 100.0f, 255.0f, 100.0f, 1.0f, 1.0f + 2.0f * Util.rand.nextFloat(), 40);
            }
        }
        return null;
    }
}

