/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.config.RitualConfig;
import epicsquid.roots.ritual.RitualAnimalHarvest;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualDivineProtection;
import epicsquid.roots.ritual.RitualFireStorm;
import epicsquid.roots.ritual.RitualFrostLands;
import epicsquid.roots.ritual.RitualGermination;
import epicsquid.roots.ritual.RitualHealingAura;
import epicsquid.roots.ritual.RitualHeavyStorms;
import epicsquid.roots.ritual.RitualOvergrowth;
import epicsquid.roots.ritual.RitualPurity;
import epicsquid.roots.ritual.RitualSpreadingForest;
import epicsquid.roots.ritual.RitualTransmutation;
import epicsquid.roots.ritual.RitualWardingProtection;
import epicsquid.roots.ritual.RitualWindwall;
import epicsquid.roots.ritual.natural.RitualFlowerGrowth;
import epicsquid.roots.ritual.natural.RitualWildGrowth;
import epicsquid.roots.ritual.wild.RitualSummonCreatures;
import epicsquid.roots.tileentity.TileEntityBonfire;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class RitualRegistry {
    public static Map<String, RitualBase> ritualRegistry = new HashMap<String, RitualBase>();
    public static RitualBase ritual_life;
    public static RitualBase ritual_storm;
    public static RitualBase ritual_light;
    public static RitualBase ritual_fire_storm;
    public static RitualBase ritual_regrowth;
    public static RitualBase ritual_windwall;
    public static RitualBase ritual_warden;
    public static RitualBase ritual_natural_aura;
    public static RitualBase ritual_purity;
    public static RitualBase ritual_frost;
    public static RitualBase ritual_animal_harvest;
    public static RitualBase ritual_summoning;
    public static RitualBase ritual_wild_growth;
    public static RitualBase ritual_overgrowth;
    public static RitualBase ritual_flower_growth;
    public static RitualBase ritual_transmutation;

    public static RitualBase getRitual(TileEntityBonfire tileEntity, EntityPlayer player) {
        for (int i = 0; i < ritualRegistry.size(); ++i) {
            RitualBase ritual = ritualRegistry.values().toArray(new RitualBase[ritualRegistry.size()])[i];
            if (!ritual.isRitualRecipe(tileEntity, player)) continue;
            return ritual;
        }
        return null;
    }

    public static RitualBase getRitual(String ritualName) {
        if (ritualName == null) {
            return null;
        }
        for (RitualBase ritual : ritualRegistry.values()) {
            if (!ritual.getName().equalsIgnoreCase(ritualName)) continue;
            return ritual;
        }
        return null;
    }

    public static void init() {
        if (!RitualConfig.disableRitualCategory.disableHealingAura) {
            ritual_life = new RitualHealingAura("ritual_healing_aura", 800);
            RitualRegistry.addRitual(ritual_life);
        }
        if (!RitualConfig.disableRitualCategory.disableHeavyStorms) {
            ritual_storm = new RitualHeavyStorms("ritual_heavy_storms", 2400);
            RitualRegistry.addRitual(ritual_storm);
        }
        if (!RitualConfig.disableRitualCategory.disableDivineProtection) {
            ritual_light = new RitualDivineProtection("ritual_divine_protection", 1200);
            RitualRegistry.addRitual(ritual_light);
        }
        if (!RitualConfig.disableRitualCategory.disableFireStorm) {
            ritual_fire_storm = new RitualFireStorm("ritual_fire_storm", 1200);
            RitualRegistry.addRitual(ritual_fire_storm);
        }
        if (!RitualConfig.disableRitualCategory.disableNaturalGrowth) {
            ritual_regrowth = new RitualSpreadingForest("ritual_spreading_forest", 2400);
            RitualRegistry.addRitual(ritual_regrowth);
        }
        if (!RitualConfig.disableRitualCategory.disableWindwall) {
            ritual_windwall = new RitualWindwall("ritual_windwall", 3000);
            RitualRegistry.addRitual(ritual_windwall);
        }
        if (!RitualConfig.disableRitualCategory.disableWardingProtection) {
            ritual_warden = new RitualWardingProtection("ritual_warding_protection", 1200);
            RitualRegistry.addRitual(ritual_warden);
        }
        if (!RitualConfig.disableRitualCategory.disableNaturalAura) {
            ritual_natural_aura = new RitualGermination("ritual_germination", 6400);
            RitualRegistry.addRitual(ritual_natural_aura);
        }
        if (!RitualConfig.disableRitualCategory.disablePurity) {
            ritual_purity = new RitualPurity("ritual_purity", 1200);
            RitualRegistry.addRitual(ritual_purity);
        }
        if (!RitualConfig.disableRitualCategory.disableFrostLands) {
            ritual_frost = new RitualFrostLands("ritual_frost_lands", 6400);
            RitualRegistry.addRitual(ritual_frost);
        }
        if (!RitualConfig.disableRitualCategory.disableAnimalHarvest) {
            ritual_animal_harvest = new RitualAnimalHarvest("ritual_animal_harvest", 3200);
            RitualRegistry.addRitual(ritual_animal_harvest);
        }
        if (!RitualConfig.disableRitualCategory.disableSummonCreatures) {
            ritual_summoning = new RitualSummonCreatures("ritual_summon_creatures", 0);
            RitualRegistry.addRitual(ritual_summoning);
        }
        if (!RitualConfig.disableRitualCategory.disableWildGrowth) {
            ritual_wild_growth = new RitualWildGrowth("ritual_wild_growth", 300);
            RitualRegistry.addRitual(ritual_wild_growth);
        }
        if (!RitualConfig.disableRitualCategory.disableOvergrowth) {
            ritual_overgrowth = new RitualOvergrowth("ritual_overgrowth", 4500);
            RitualRegistry.addRitual(ritual_overgrowth);
        }
        if (!RitualConfig.disableRitualCategory.disableFlowerGrowth) {
            ritual_flower_growth = new RitualFlowerGrowth("ritual_flower_growth", 3200);
            RitualRegistry.addRitual(ritual_flower_growth);
        }
        if (!RitualConfig.disableRitualCategory.disableTransmutation) {
            ritual_transmutation = new RitualTransmutation("ritual_transmutation", 2400);
            RitualRegistry.addRitual(ritual_transmutation);
        }
    }

    public static void addRitual(RitualBase ritual) {
        ritualRegistry.put(ritual.getName(), ritual);
    }
}

