/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.block.BlockBonfire;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.recipe.conditions.Condition;
import epicsquid.roots.recipe.conditions.ConditionItems;
import epicsquid.roots.tileentity.TileEntityBonfire;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class RitualBase {
    protected static int OFFERTORY_RADIUS = 6;
    protected static Random random = new Random();
    private List<Condition> conditions = new ArrayList<Condition>();
    private Item icon;
    private String name;
    private int duration;
    private TextFormatting color;
    private boolean bold;

    public RitualBase(String name, int duration) {
        this.name = name;
        this.duration = duration;
    }

    public String getFormat() {
        String format = this.color + "";
        if (this.bold) {
            format = format + TextFormatting.BOLD;
        }
        return format;
    }

    public void setColor(TextFormatting color) {
        this.color = color;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public Item getIcon() {
        return this.icon;
    }

    public void setIcon(Item icon) {
        this.icon = icon;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public boolean isRitualRecipe(TileEntityBonfire tileEntityBonfire, EntityPlayer player) {
        for (Condition condition : this.conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems conditionItems = (ConditionItems)condition;
            return conditionItems.checkCondition(tileEntityBonfire, player);
        }
        return false;
    }

    public boolean canFire(TileEntityBonfire tileEntityBonfire, EntityPlayer player) {
        IBlockState state = tileEntityBonfire.func_145831_w().func_180495_p(tileEntityBonfire.func_174877_v());
        if (((Boolean)state.func_177229_b((IProperty)BlockBonfire.BURNING)).booleanValue()) {
            return false;
        }
        for (Condition condition : this.conditions) {
            if (condition.checkCondition(tileEntityBonfire, player)) continue;
            return false;
        }
        return true;
    }

    public abstract EntityRitualBase doEffect(World var1, BlockPos var2);

    protected EntityRitualBase spawnEntity(World world, BlockPos pos, Class<? extends EntityRitualBase> entity) {
        List pastRituals = world.func_72872_a(entity, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 100), (double)(pos.func_177952_p() + 1)));
        if (pastRituals.size() == 0 && !world.field_72995_K) {
            EntityRitualBase ritual = null;
            try {
                Constructor<? extends EntityRitualBase> cons = entity.getDeclaredConstructor(World.class);
                ritual = cons.newInstance(world);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (ritual == null) {
                return null;
            }
            ritual.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)ritual);
            return ritual;
        }
        if (pastRituals.size() > 0) {
            for (EntityRitualBase ritual : pastRituals) {
                ritual.func_184212_Q().func_187227_b(ritual.getLifetime(), (Object)(this.duration + 20));
                ritual.func_184212_Q().func_187217_b(ritual.getLifetime());
            }
        }
        return null;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public List<ItemStack> getRecipe() {
        for (Condition condition : this.conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems conditionItems = (ConditionItems)condition;
            ItemStack[] stacks = (ItemStack[])conditionItems.getIngredients().stream().map(ingredient -> ingredient.func_193365_a()[0]).toArray(ItemStack[]::new);
            return Arrays.asList(stacks);
        }
        return new ArrayList<ItemStack>();
    }

    public List<Ingredient> getIngredients() {
        for (Condition condition : this.conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            return ((ConditionItems)condition).getIngredients();
        }
        return Collections.EMPTY_LIST;
    }
}

