/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemArrowBase;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.Roots;
import epicsquid.roots.entity.item.EntityLivingArrow;
import epicsquid.roots.handler.QuiverHandler;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.ItemLivingArrow;
import epicsquid.roots.util.QuiverInventoryUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemQuiver
extends ItemArrowBase {
    public static AxisAlignedBB bounding = new AxisAlignedBB(-2.5, -2.5, -2.5, 2.5, 2.5, 2.5);

    public ItemQuiver(@Nonnull String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(256);
    }

    public EntityArrow func_185052_a(World worldIn, ItemStack stack, EntityLivingBase shooter) {
        ItemStack livingArrow = ItemQuiver.findLivingArrow(stack);
        if (!livingArrow.func_190926_b()) {
            return ((ItemLivingArrow)livingArrow.func_77973_b()).func_185052_a(worldIn, livingArrow, shooter);
        }
        ItemStack normalArrow = ItemQuiver.findOtherArrow(stack);
        if (!normalArrow.func_190926_b()) {
            return ((ItemArrow)normalArrow.func_77973_b()).func_185052_a(worldIn, normalArrow, shooter);
        }
        EntityTippedArrow arrow = new EntityTippedArrow(worldIn, shooter);
        arrow.func_70239_b(1.5);
        arrow.getEntityData().func_74757_a("generated", true);
        stack.func_77972_a(field_77697_d.nextInt(2), shooter);
        return arrow;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, EntityPlayer player) {
        return true;
    }

    public static ItemStack findLivingArrow(ItemStack quiver) {
        QuiverHandler handler = QuiverHandler.getHandler(quiver);
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < handler.getInventory().getSlots(); ++i) {
            ItemStack stack = handler.getInventory().getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.living_arrow) continue;
            result = handler.getInventory().extractItem(i, 1, false);
            break;
        }
        return result;
    }

    public static ItemStack findOtherArrow(ItemStack quiver) {
        QuiverHandler handler = QuiverHandler.getHandler(quiver);
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < handler.getInventory().getSlots(); ++i) {
            ItemStack stack = handler.getInventory().getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemArrow) || stack.func_77973_b() == ModItems.living_arrow) continue;
            result = handler.getInventory().extractItem(i, 1, false);
            break;
        }
        return result;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.openGui((Object)Roots.getInstance(), 17, world, 0, 0, 0);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static void tryPickupArrows(EntityPlayer player) {
        ItemStack quiver = QuiverInventoryUtil.getQuiver(player);
        if (quiver.func_190926_b()) {
            return;
        }
        List arrows = player.field_70170_p.func_72872_a(EntityArrow.class, bounding.func_186670_a(player.func_180425_c()));
        if (arrows.isEmpty()) {
            return;
        }
        QuiverHandler handler = QuiverHandler.getHandler(quiver);
        if (!handler.canConsume()) {
            player.func_146105_b(new TextComponentTranslation("roots.quiver.quiver_full", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))), true);
            return;
        }
        int consumed = 0;
        int generated = 0;
        for (EntityArrow arrow : arrows) {
            ItemStack stack = new ItemStack(Items.field_151032_g);
            if (arrow instanceof EntityLivingArrow) {
                stack = new ItemStack(ModItems.living_arrow);
            }
            arrow.func_70106_y();
            if (arrow.getEntityData().func_74764_b("generated")) {
                ++generated;
                continue;
            }
            if (Util.rand.nextInt(3) == 0 && stack.func_77973_b() != ModItems.living_arrow || !ItemHandlerHelper.insertItemStacked((IItemHandler)handler.getInventory(), (ItemStack)stack, (boolean)false).func_190926_b()) continue;
            ++consumed;
        }
        if (consumed > 0) {
            player.func_146105_b(new TextComponentTranslation("roots.quiver.picked_up_arrow", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN).func_150227_a(Boolean.valueOf(true))), true);
        } else if (consumed == 0 && generated > 0) {
            player.func_146105_b(new TextComponentTranslation("roots.quiver.fragile", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN).func_150227_a(Boolean.valueOf(true))), true);
        } else {
            player.func_146105_b(new TextComponentTranslation("roots.quiver.broke", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN).func_150227_a(Boolean.valueOf(true))), true);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public int func_77619_b() {
        return 22;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (repair.func_77973_b() == ModItems.bark_wildwood) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public boolean isRepairable() {
        return true;
    }
}

