/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.handler;

import epicsquid.roots.init.ModItems;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.modules.ModuleRegistry;
import epicsquid.roots.spell.modules.SpellModule;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpellHandler
implements INBTSerializable<NBTTagCompound> {
    private Map<Integer, SpellBase> spells = new Int2ObjectOpenHashMap();
    private Map<Integer, List<SpellModule>> spellModules = new Int2ObjectOpenHashMap();
    private int selectedSlot = 0;
    private int cooldown = 0;
    private int lastCooldown = 0;
    private ItemStack stack;

    public SpellHandler(ItemStack stack) {
        this.stack = stack;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean hasSpell() {
        if (!this.spells.isEmpty()) {
            for (Map.Entry<Integer, SpellBase> entry : this.spells.entrySet()) {
                if (entry == null || entry.getValue() == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSpellInSlot() {
        return this.spells.getOrDefault(this.selectedSlot, null) != null;
    }

    public boolean isEmpty() {
        return this.spells.values().stream().filter(Objects::isNull).count() == 5L;
    }

    public SpellBase getSpellInSlot(int slot) {
        if (slot < 0 || slot >= 5) {
            return null;
        }
        return this.spells.getOrDefault(slot, null);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.saveToStack();
    }

    public int getLastCooldown() {
        return this.lastCooldown;
    }

    public void setLastCooldown(int lastCooldown) {
        this.lastCooldown = lastCooldown;
        this.saveToStack();
    }

    @Nullable
    public SpellBase getSelectedSpell() {
        return this.spells.get(this.selectedSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public String formatSelectedSpell() {
        SpellBase spell = this.spells.get(this.selectedSlot);
        if (spell == null) {
            return "";
        }
        return "(" + spell.getTextColor() + TextFormatting.BOLD + I18n.func_135052_a((String)("roots.spell." + spell.getName() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET + ")";
    }

    public void clearSelectedSlot() {
        this.spells.put(this.selectedSlot, null);
        this.saveToStack();
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    public void setSelectedSlot(int slot) {
        this.selectedSlot = slot;
        this.saveToStack();
    }

    public void previousSlot() {
        int i;
        if (this.isEmpty()) {
            this.setSelectedSlot(0);
            return;
        }
        int originalSlot = this.selectedSlot;
        for (i = this.selectedSlot - 1; i >= 0; --i) {
            if (this.spells.get(i) == null) continue;
            this.setSelectedSlot(i);
            return;
        }
        for (i = 5; i >= originalSlot; --i) {
            if (this.spells.get(i) == null) continue;
            this.setSelectedSlot(i);
            return;
        }
        this.setSelectedSlot(originalSlot);
    }

    public void nextSlot() {
        int i;
        if (this.isEmpty()) {
            this.setSelectedSlot(0);
            return;
        }
        int originalSlot = this.selectedSlot;
        for (i = this.selectedSlot + 1; i < 5; ++i) {
            if (this.spells.get(i) == null) continue;
            this.setSelectedSlot(i);
            return;
        }
        for (i = 0; i < originalSlot; ++i) {
            if (this.spells.get(i) == null) continue;
            this.setSelectedSlot(i);
            return;
        }
        this.setSelectedSlot(originalSlot);
    }

    public void setSpellToSlot(SpellBase spell) {
        assert (this.hasFreeSlot());
        this.setSelectedSlot(this.getNextFreeSlot());
        this.spells.put(this.selectedSlot, spell);
        this.spellModules.remove(this.selectedSlot);
        this.saveToStack();
    }

    public void addModule(SpellModule module) {
        if (this.spellModules.getOrDefault(this.selectedSlot, null) == null) {
            ArrayList<SpellModule> modules = new ArrayList<SpellModule>();
            modules.add(module);
            this.spellModules.put(this.selectedSlot, modules);
        } else {
            List<SpellModule> modules = this.spellModules.get(this.selectedSlot);
            modules.add(module);
        }
        this.saveToStack();
    }

    public List<SpellModule> getSelectedModules() {
        return this.spellModules.getOrDefault(this.selectedSlot, new ArrayList());
    }

    public int getNextFreeSlot() {
        for (int i = 0; i < 5; ++i) {
            if (this.spells.getOrDefault(i, null) != null) continue;
            return i;
        }
        return -1;
    }

    public boolean hasFreeSlot() {
        return this.getNextFreeSlot() != -1;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry<Integer, SpellBase> entry : this.spells.entrySet()) {
            compound.func_74778_a("spell_" + entry.getKey(), entry.getValue() == null ? "" : entry.getValue().getName());
        }
        for (Map.Entry<Integer, Object> entry : this.spellModules.entrySet()) {
            List modules = (List)entry.getValue();
            for (int i = 0; i < modules.size(); ++i) {
                compound.func_74778_a(entry.getKey() + "_spell_" + i, ((SpellModule)modules.get(i)).getName());
            }
        }
        compound.func_74768_a("selectedSlot", this.selectedSlot);
        compound.func_74768_a("cooldown", this.cooldown);
        compound.func_74768_a("lastCooldown", this.lastCooldown);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        int i;
        for (i = 0; i < 5; ++i) {
            if (tag.func_74779_i("spell_" + i).isEmpty()) continue;
            this.spells.put(i, SpellRegistry.getSpell(tag.func_74779_i("spell_" + i)));
        }
        for (i = 0; i < 5; ++i) {
            ArrayList<SpellModule> modules = new ArrayList<SpellModule>();
            for (int j = 0; j < 5; ++j) {
                if (tag.func_74779_i(i + "_spell_" + j).isEmpty()) continue;
                modules.add(ModuleRegistry.getModule(tag.func_74779_i(i + "_spell_" + j)));
            }
            if (modules.size() <= 0) continue;
            this.spellModules.put(i, modules);
        }
        this.selectedSlot = tag.func_74762_e("selectedSlot");
        this.cooldown = tag.func_74762_e("cooldown");
        this.lastCooldown = tag.func_74762_e("lastCooldown");
    }

    @Nonnull
    public static SpellHandler fromStack(ItemStack stack) {
        boolean correct;
        boolean bl = correct = stack.func_77973_b() == ModItems.spell_dust || stack.func_77973_b() == ModItems.staff;
        assert (correct);
        SpellHandler result = new SpellHandler(stack);
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("spell_holder")) {
            result.deserializeNBT(tag.func_74775_l("spell_holder"));
        }
        return result;
    }

    public void saveToStack() {
        boolean correct;
        boolean bl = correct = this.stack.func_77973_b() == ModItems.spell_dust || this.stack.func_77973_b() == ModItems.staff;
        assert (correct);
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.stack.func_77982_d(tag);
        }
        tag.func_74782_a("spell_holder", (NBTBase)this.serializeNBT());
    }
}

