/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.BlockBase;
import epicsquid.roots.api.CustomPlantType;
import epicsquid.roots.item.itemblock.ItemBlockElementalSoil;
import epicsquid.roots.util.EnumElementalSoilType;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockElementalSoil
extends BlockBase {
    public static final PropertyInteger waterSpeed = PropertyInteger.func_177719_a((String)"water", (int)0, (int)4);
    public static final PropertyInteger airSpeed = PropertyInteger.func_177719_a((String)"air", (int)0, (int)4);
    public static final PropertyInteger earthFertility = PropertyInteger.func_177719_a((String)"earth", (int)0, (int)4);
    public static final PropertyInteger fireCookingMultiplier = PropertyInteger.func_177719_a((String)"fire", (int)0, (int)4);
    @Nonnull
    private final Item itemBlock;
    private final EnumElementalSoilType soilType;

    public BlockElementalSoil(@Nonnull Material mat, @Nonnull SoundType type, @Nonnull String name, @Nonnull EnumElementalSoilType soilType) {
        super(mat, type, 0.8f, name);
        this.soilType = soilType;
        this.itemBlock = (Item)new ItemBlockElementalSoil((Block)this).setRegistryName(LibRegistry.getActiveModid(), name);
        this.setHarvestReqs("shovel", 0);
        PropertyInteger property = this.soilType == EnumElementalSoilType.WATER ? waterSpeed : (this.soilType == EnumElementalSoilType.EARTH ? earthFertility : (this.soilType == EnumElementalSoilType.AIR ? airSpeed : fireCookingMultiplier));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)property, (Comparable)Integer.valueOf(1)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        switch (this.soilType) {
            case AIR: {
                return this.func_176223_P().func_177226_a((IProperty)airSpeed, (Comparable)Integer.valueOf(meta + 1));
            }
            case FIRE: {
                return this.func_176223_P().func_177226_a((IProperty)fireCookingMultiplier, (Comparable)Integer.valueOf(meta + 1));
            }
            case EARTH: {
                return this.func_176223_P().func_177226_a((IProperty)earthFertility, (Comparable)Integer.valueOf(meta + 1));
            }
            case WATER: {
                return this.func_176223_P().func_177226_a((IProperty)waterSpeed, (Comparable)Integer.valueOf(meta + 1));
            }
        }
        return super.func_176203_a(meta);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{airSpeed, fireCookingMultiplier, earthFertility, waterSpeed});
    }

    public int func_176201_c(IBlockState state) {
        PropertyInteger property = this.soilType == EnumElementalSoilType.WATER ? waterSpeed : (this.soilType == EnumElementalSoilType.EARTH ? earthFertility : (this.soilType == EnumElementalSoilType.AIR ? airSpeed : fireCookingMultiplier));
        return (Integer)state.func_177229_b((IProperty)property) - 1 > 0 ? (Integer)state.func_177229_b((IProperty)property) - 1 : 0;
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        EnumPlantType plant = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plant) {
            case Nether: 
            case Cave: 
            case Crop: 
            case Desert: 
            case Plains: {
                return true;
            }
        }
        return plant == CustomPlantType.ELEMENT_FIRE && this.soilType == EnumElementalSoilType.FIRE || plant == CustomPlantType.ELEMENT_AIR && this.soilType == EnumElementalSoilType.AIR || plant == CustomPlantType.ELEMENT_EARTH && this.soilType == EnumElementalSoilType.EARTH || plant == CustomPlantType.ELEMENT_WATER && this.soilType == EnumElementalSoilType.WATER;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        Block upBlock = upState.func_177230_c();
        if (!(upBlock instanceof IGrowable)) {
            return;
        }
        if (rand.nextInt(5) == 0) {
            upBlock.func_180645_a(world, pos.func_177984_a(), upState, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d2;
        double d1;
        double d0;
        double y_offset;
        double x_offset;
        if (this.soilType == EnumElementalSoilType.FIRE && rand.nextInt(5) == 0) {
            double d8 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d4 = (double)pos.func_177956_o() + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e - (double)0.2f;
            double d6 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.soilType == EnumElementalSoilType.WATER) {
            for (int i = 0; i < 2; ++i) {
                x_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                y_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                d0 = (double)pos.func_177958_n() + x_offset;
                d1 = (double)pos.func_177956_o() + 1.0;
                d2 = (double)pos.func_177952_p() + y_offset;
                worldIn.func_175688_a(EnumParticleTypes.WATER_SPLASH, d0, d1, d2, 0.0, 1.5, 0.0, new int[0]);
            }
        }
        if (this.soilType == EnumElementalSoilType.AIR && rand.nextInt(13) == 0) {
            for (int i = 0; i < 2; ++i) {
                x_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                y_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                d0 = (double)pos.func_177958_n() + x_offset;
                d1 = (double)pos.func_177956_o() + 0.5;
                d2 = (double)pos.func_177952_p() + y_offset;
                worldIn.func_175688_a(EnumParticleTypes.CLOUD, d0, d1, d2, 0.0, 0.05, 0.0, new int[0]);
            }
        }
        if (this.soilType == EnumElementalSoilType.EARTH && rand.nextInt(6) == 0) {
            for (int i = 0; i < 2 + rand.nextInt(3); ++i) {
                x_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                y_offset = Math.min(Math.max(0.05, rand.nextDouble()), 0.95);
                d0 = (double)pos.func_177958_n() + x_offset;
                d1 = (double)pos.func_177956_o() + 1.0;
                d2 = (double)pos.func_177952_p() + y_offset;
                worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, d0, d1, d2, 0.0, 1.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
            }
        }
    }

    public Item getItemBlock() {
        return this.itemBlock;
    }

    public boolean isFertile(@Nonnull World world, @Nonnull BlockPos pos) {
        return true;
    }
}

