/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.api;

import epicsquid.roots.api.Herb;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

public class SpellRecipeProcessor
implements IComponentProcessor {
    private List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private List<ItemStack> herbs = new ArrayList<ItemStack>();
    private List<String> costs = new ArrayList<String>();
    private String spellName = null;

    public void setup(IVariableProvider<String> iVariableProvider) {
        this.spellName = (String)iVariableProvider.get("spell");
        SpellBase spell = SpellRegistry.spellRegistry.get(this.spellName);
        this.ingredients = spell.getIngredients();
        for (Map.Entry cost : spell.getCosts().entrySet()) {
            this.herbs.add(new ItemStack(((Herb)((Object)cost.getKey())).getItem()));
            this.costs.add(String.format("x %.3f", cost.getValue()));
        }
    }

    public String process(String s) {
        if (s.startsWith("item")) {
            int index = Integer.parseInt(s.substring(4)) - 1;
            Ingredient ingredient = this.ingredients.get(index);
            return ItemStackUtil.serializeIngredient((Ingredient)ingredient);
        }
        if (s.equalsIgnoreCase("result")) {
            ItemStack dust = SpellRegistry.getSpell(this.spellName).getResult();
            return ItemStackUtil.serializeStack((ItemStack)dust);
        }
        if (s.equals("cost1")) {
            return ItemStackUtil.serializeStack((ItemStack)this.herbs.get(0));
        }
        if (s.equals("cost2")) {
            if (this.herbs.size() == 1) {
                return ItemStackUtil.serializeStack((ItemStack)ItemStack.field_190927_a);
            }
            return ItemStackUtil.serializeStack((ItemStack)this.herbs.get(1));
        }
        if (s.equals("cost1_text")) {
            return this.costs.get(0);
        }
        if (s.equals("cost2_text")) {
            if (this.costs.size() == 1) {
                return "";
            }
            return this.costs.get(1);
        }
        return null;
    }
}

