/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.plugins.constructs_armory.material;

import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.plugins.constructs_armory.material.ArmorMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.tinkers_construct.material.IToolMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class ArmorToolMaterial
extends ArmorMaterial
implements IToolMaterial {
    private HeadMaterialStats headMaterialStats;
    private HandleMaterialStats handleMaterialStats;
    private ExtraMaterialStats extraMaterialStats;

    ArmorToolMaterial(String identifier, int color) {
        super(identifier, color);
    }

    @Override
    public HeadMaterialStats getHeadMaterialStats() {
        return this.headMaterialStats;
    }

    @Override
    public HandleMaterialStats getHandleMaterialStats() {
        return this.handleMaterialStats;
    }

    @Override
    public ExtraMaterialStats getExtraMaterialStats() {
        return this.extraMaterialStats;
    }

    @Override
    public IToolMaterial addPrimaryToolTrait(String trait) {
        return (IToolMaterial)((Object)this.addTrait(trait, "head"));
    }

    @Override
    public IToolMaterial addSecondaryToolTrait(String trait) {
        return (IToolMaterial)((Object)this.addTrait(trait, "handle").addTrait(trait, "extra"));
    }

    @Override
    public IToolMaterial addGlobalToolTrait(String trait) {
        return this.addPrimaryToolTrait(trait).addSecondaryToolTrait(trait);
    }

    @Override
    public IToolMaterial addToolTrait(String trait1, String trait2) {
        return this.addPrimaryToolTrait(trait1).addSecondaryToolTrait(trait2);
    }

    @Override
    public boolean isToolMaterial() {
        return this.getHeadMaterialStats() != null || this.getHandleMaterialStats() != null || this.getExtraMaterialStats() != null;
    }

    @Override
    public boolean registerTinkersMaterialStats(MaterialConfigOptions properties) {
        Material material = TinkerRegistry.getMaterial((String)this.getIdentifier());
        if ("unknown".equals(material.getIdentifier())) {
            return false;
        }
        if (properties.isMaterialEnabled()) {
            this.registerArmorStats(material, properties);
            this.registerToolStats(material, properties);
            return true;
        }
        return false;
    }

    void registerToolStats(Material material, MaterialConfigOptions properties) {
        if (this.isToolMaterial()) {
            this.registerHeadStats(material, properties);
            this.registerHandleStats(material, properties);
            this.registerExtraStats(material, properties);
        }
    }

    private void registerHeadStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats("head") == null && this.getHeadMaterialStats() != null && properties.isHeadEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getHeadMaterialStats());
        }
    }

    private void registerHandleStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats("handle") == null && this.getHandleMaterialStats() != null && properties.isHandleEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getHandleMaterialStats());
        }
    }

    private void registerExtraStats(Material material, MaterialConfigOptions properties) {
        if (material.getStats("extra") == null && this.getExtraMaterialStats() != null && properties.isExtraEnabled()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)this.getExtraMaterialStats());
        }
    }

    public void setHeadMaterialStats(HeadMaterialStats headMaterialStats) {
        this.headMaterialStats = headMaterialStats;
    }

    public void setHandleMaterialStats(HandleMaterialStats handleMaterialStats) {
        this.handleMaterialStats = handleMaterialStats;
    }

    public void setExtraMaterialStats(ExtraMaterialStats extraMaterialStats) {
        this.extraMaterialStats = extraMaterialStats;
    }
}

