/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.network;

import com.teamwizardry.librarianlib.features.autoregister.PacketRegister;
import com.teamwizardry.librarianlib.features.network.PacketBase;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.wizardry.api.spell.CommonWorktableModule;
import com.teamwizardry.wizardry.common.tile.TileMagiciansWorktable;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@PacketRegister(value=Side.SERVER)
public class PacketSyncWorktable
extends PacketBase {
    @Save
    public NBTTagList commonModules;
    @Save
    private int world;
    @Save
    private BlockPos pos;

    public PacketSyncWorktable() {
    }

    public PacketSyncWorktable(int world, BlockPos pos, Set<CommonWorktableModule> commonModules) {
        this.world = world;
        this.pos = pos;
        if (commonModules == null) {
            return;
        }
        NBTTagList compiledList = new NBTTagList();
        for (CommonWorktableModule commonModule : commonModules) {
            compiledList.func_74742_a((NBTBase)commonModule.serializeNBT());
        }
        this.commonModules = compiledList;
    }

    public void handle(@Nonnull MessageContext messageContext) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.world);
        TileEntity entity = world.func_175625_s(this.pos);
        if (entity instanceof TileMagiciansWorktable) {
            ((TileMagiciansWorktable)entity).setCommonModules(this.commonModules);
            BlockPos sister = ((TileMagiciansWorktable)entity).linkedTable;
            TileEntity sisterTile = world.func_175625_s(sister);
            if (sisterTile instanceof TileMagiciansWorktable) {
                ((TileMagiciansWorktable)sisterTile).setCommonModules(this.commonModules);
            }
        }
    }
}

