/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.capability.player.miscdata.IMiscCapability;
import com.teamwizardry.wizardry.api.capability.player.miscdata.MiscCapabilityProvider;
import com.teamwizardry.wizardry.api.entity.FairyData;
import com.teamwizardry.wizardry.common.entity.EntityFairy;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemFairyBell
extends ItemMod {
    public ItemFairyBell() {
        super("fairy_bell", new String[0]);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (playerIn.field_70170_p.field_72995_K || playerIn.func_70093_af()) {
            return super.func_111207_a(stack, playerIn, target, hand);
        }
        if (target instanceof EntityFairy) {
            IMiscCapability cap;
            EntityFairy fairy = (EntityFairy)target;
            FairyData fairyData = fairy.getDataFairy();
            if (fairyData == null) {
                return super.func_111207_a(stack, playerIn, target, hand);
            }
            if (fairyData.isDepressed && (cap = MiscCapabilityProvider.getCap((Entity)playerIn)) != null) {
                UUID selected = cap.getSelectedFairyUUID();
                if (selected != null && selected.equals(fairy.func_110124_au())) {
                    cap.setSelectedFairy(null);
                    playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 0.25f);
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("item.wizardry:fairy_bell.status.deselected", new Object[0]), true);
                } else {
                    cap.setSelectedFairy(fairy.func_110124_au());
                    boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
                    if (!movingMode) {
                        playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 0.75f);
                    } else {
                        playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 1.25f);
                    }
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(movingMode ? "item.wizardry:fairy_bell.status.fairy_moving" : "item.wizardry:fairy_bell.status.fairy_aiming", new Object[0]), true);
                }
                cap.dataChanged((Entity)playerIn);
            }
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    @NotNull
    public String func_77653_i(@NotNull ItemStack stack) {
        boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
        if (movingMode) {
            return LibrarianLib.PROXY.translate("item.wizardry:fairy_bell_moving_mode", new Object[0]);
        }
        return LibrarianLib.PROXY.translate("item.wizardry:fairy_bell_aiming_mode", new Object[0]);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @NotNull EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af() && !worldIn.field_72995_K) {
            NBTHelper.setBoolean((ItemStack)stack, (String)"moving_mode", (!NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true) ? 1 : 0) != 0);
            IMiscCapability cap = MiscCapabilityProvider.getCap((Entity)playerIn);
            if (cap == null) {
                return super.func_77659_a(worldIn, playerIn, handIn);
            }
            cap.setSelectedFairy(null);
            cap.dataChanged((Entity)playerIn);
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        if (!worldIn.field_72995_K) {
            IBlockState state;
            IMiscCapability cap = MiscCapabilityProvider.getCap((Entity)playerIn);
            if (cap == null) {
                return super.func_77659_a(worldIn, playerIn, handIn);
            }
            EntityFairy entityFairy = cap.getSelectedFairyEntity(worldIn);
            if (entityFairy == null) {
                return super.func_77659_a(worldIn, playerIn, handIn);
            }
            double reach = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
            Vec3d posEyes = playerIn.func_174791_d().func_72441_c(0.0, (double)playerIn.func_70047_e(), 0.0);
            RayTraceResult rayTraceResult = worldIn.func_147447_a(posEyes, posEyes.func_178787_e(playerIn.func_70676_i(1.0f).func_186678_a(reach)), false, false, true);
            if (rayTraceResult == null || rayTraceResult.field_72307_f == null || rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                return super.func_77659_a(worldIn, playerIn, handIn);
            }
            if (worldIn.func_175667_e(rayTraceResult.func_178782_a()) && (state = worldIn.func_180495_p(rayTraceResult.func_178782_a())).func_177230_c().func_149703_v()) {
                boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
                if (entityFairy.originPos != null && !movingMode) {
                    Vec3d hitVec = rayTraceResult.field_72307_f;
                    Vec3d subtract = hitVec.func_178788_d(entityFairy.func_174791_d());
                    double length = subtract.func_72433_c();
                    hitVec = entityFairy.func_174791_d().func_178787_e(subtract.func_72432_b().func_186678_a(MathHelper.func_151237_a((double)length, (double)-3.0, (double)3.0)));
                    entityFairy.setLookTarget(hitVec);
                    playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 0.75f);
                    cap.setSelectedFairy(null);
                    cap.dataChanged((Entity)playerIn);
                }
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @NotNull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        if (worldIn.field_72995_K || playerIn.func_70093_af()) {
            return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        IMiscCapability cap = MiscCapabilityProvider.getCap((Entity)playerIn);
        if (cap == null) {
            return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        EntityFairy entityFairy = cap.getSelectedFairyEntity(worldIn);
        if (entityFairy == null) {
            return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        cap.setSelectedFairy(null);
        cap.dataChanged((Entity)playerIn);
        if (worldIn.func_175667_e(pos) && !worldIn.func_175623_d(pos) && (state = worldIn.func_180495_p(pos)).func_177230_c().func_149703_v()) {
            ItemStack stack = playerIn.func_184586_b(hand);
            boolean movingMode = NBTHelper.getBoolean((ItemStack)stack, (String)"moving_mode", (boolean)true);
            if (entityFairy.originPos != null && movingMode) {
                entityFairy.moveTo(pos.func_177972_a(facing));
                entityFairy.setLookTarget(null);
                playerIn.field_70170_p.func_184133_a(null, playerIn.func_180425_c(), (SoundEvent)ModSounds.TINY_BELL, SoundCategory.NEUTRAL, 1.0f, 1.25f);
            }
        }
        return super.func_180614_a(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }
}

