/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity;

import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.entity.FairyData;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.entity.EntitySpiritWight;
import com.teamwizardry.wizardry.common.entity.EntityUnicorn;
import com.teamwizardry.wizardry.common.entity.ai.FairyAIWanderAvoidWaterFlying;
import com.teamwizardry.wizardry.common.entity.ai.FairyMoveHelper;
import com.teamwizardry.wizardry.common.entity.ai.WizardryFlyablePathNavigator;
import com.teamwizardry.wizardry.common.network.PacketExplode;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIFollowOwnerFlying;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class EntityFairy
extends EntityTameable
implements EntityFlying {
    private static final DataParameter<NBTTagCompound> DATA_FAIRY = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<NBTTagCompound> DATA_LOOK_TARGET = EntityDataManager.func_187226_a(EntityFairy.class, (DataSerializer)DataSerializers.field_192734_n);
    private EntityAIAvoidEntity<EntityPlayer> avoidEntity;
    public BlockPos originPos = null;
    public BlockPos moveTargetPos = null;
    private double previousDist = Double.MAX_VALUE;
    private long lastFreeTime = Long.MAX_VALUE;
    private boolean adjustingPath = false;
    private boolean moving = false;

    public EntityFairy(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70160_al = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new FairyMoveHelper((EntityLiving)this);
        this.setDataFairy(new FairyData());
        this.setLookTarget(null);
    }

    public EntityFairy(World worldIn, FairyData fairyData) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70160_al = true;
        this.field_70728_aV = 5;
        this.field_70765_h = new FairyMoveHelper((EntityLiving)this);
        this.setDataFairy(fairyData);
        this.setLookTarget(null);
    }

    @Nullable
    public Vec3d getLookTarget() {
        NBTTagCompound compound = (NBTTagCompound)this.func_184212_Q().func_187225_a(DATA_LOOK_TARGET);
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"look_target_z")) {
            return new Vec3d(NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_x"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_y"), NBTHelper.getDouble((NBTTagCompound)compound, (String)"look_target_z"));
        }
        return null;
    }

    public void setLookTarget(Vec3d lookTarget) {
        NBTTagCompound compound = new NBTTagCompound();
        if (lookTarget == null) {
            return;
        }
        compound.func_74780_a("look_target_x", lookTarget.field_72450_a);
        compound.func_74780_a("look_target_y", lookTarget.field_72448_b);
        compound.func_74780_a("look_target_z", lookTarget.field_72449_c);
        this.func_184212_Q().func_187227_b(DATA_LOOK_TARGET, (Object)compound);
        this.func_184212_Q().func_187217_b(DATA_LOOK_TARGET);
    }

    @Nullable
    public FairyData getDataFairy() {
        NBTTagCompound compound = (NBTTagCompound)this.func_184212_Q().func_187225_a(DATA_FAIRY);
        return FairyData.deserialize(compound);
    }

    public void setDataFairy(FairyData fairy) {
        if (fairy == null) {
            return;
        }
        this.func_184212_Q().func_187227_b(DATA_FAIRY, (Object)fairy.serializeNBT());
        this.func_184212_Q().func_187217_b(DATA_FAIRY);
    }

    @Nullable
    public EntityAgeable func_90011_a(@NotNull EntityAgeable ageable) {
        return null;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70878_b(@NotNull EntityAnimal otherAnimal) {
        return false;
    }

    public boolean func_70652_k(@NotNull Entity entityIn) {
        if (entityIn instanceof EntityUnicorn) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    public boolean func_70097_a(@NotNull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_FAIRY, (Object)new FairyData().serializeNBT());
        this.func_184212_Q().func_187214_a(DATA_LOOK_TARGET, (Object)new NBTTagCompound());
    }

    public void func_184651_r() {
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy != null && dataFairy.isDepressed) {
            return;
        }
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowOwnerFlying((EntityTameable)this, 1.0, 5.0f, 1.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new FairyAIWanderAvoidWaterFlying((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 3.0f, 7.0f));
    }

    protected void func_175544_ck() {
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy != null && dataFairy.isDepressed) {
            return;
        }
        if (this.avoidEntity == null) {
            this.avoidEntity = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 2.0, 3.0);
        }
        this.field_70714_bg.func_85156_a(this.avoidEntity);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(0, this.avoidEntity);
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityUnicorn.class, 16.0f, 2.0, 3.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntitySpiritWight.class, 16.0f, 2.0, 3.0));
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(RandUtil.nextDouble(2.0, 3.0));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @NotNull
    public PathNavigate func_175447_b(@NotNull World worldIn) {
        return new WizardryFlyablePathNavigator((EntityLiving)this, worldIn);
    }

    public void func_82167_n(Entity entity) {
        if (this.func_110143_aJ() > 0.0f) {
            if (entity.func_70005_c_().equals(this.func_70005_c_())) {
                return;
            }
            ((EntityLivingBase)entity).field_70181_x += 0.3;
            ((EntityLivingBase)entity).func_70604_c((EntityLivingBase)this);
        }
        entity.field_70143_R = 0.0f;
    }

    public void func_70071_h_() {
        PathPoint pathPoint;
        super.func_70071_h_();
        this.func_189654_d(true);
        this.field_70143_R = 0.0f;
        FairyData dataFairy = this.getDataFairy();
        float size = dataFairy != null && dataFairy.wasTamperedWith ? 0.2f : 1.0f;
        this.func_98055_j(size);
        if (this.field_70128_L) {
            return;
        }
        if (dataFairy != null && dataFairy.isDepressed) {
            Vec3d lookTarget = this.getLookTarget();
            if (lookTarget != null) {
                this.func_70671_ap().func_75650_a(lookTarget.field_72450_a, lookTarget.field_72448_b, lookTarget.field_72449_c, 20.0f, 20.0f);
            }
            ArrayList tempTasks = new ArrayList(this.field_70714_bg.field_75782_a);
            for (EntityAITasks.EntityAITaskEntry taskEntry : tempTasks) {
                this.field_70714_bg.func_85156_a(taskEntry.field_75733_a);
            }
            ArrayList tempTargetTasks = new ArrayList(this.field_70715_bh.field_75782_a);
            for (EntityAITasks.EntityAITaskEntry taskEntry : tempTargetTasks) {
                this.field_70715_bh.func_85156_a(taskEntry.field_75733_a);
            }
        }
        if (this.func_70661_as().func_75505_d() == null || (pathPoint = this.func_70661_as().func_75505_d().func_75870_c()) != null) {
            // empty if block
        }
        if (!this.moving) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
            this.func_174829_m();
        }
        if ((dataFairy == null || !dataFairy.isDepressed) && this.func_70661_as().func_75500_f()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t + RandUtil.nextDouble(-32.0, 32.0), this.field_70163_u + RandUtil.nextDouble(-32.0, 32.0), this.field_70161_v + RandUtil.nextDouble(-32.0, 32.0), 2.0);
        } else if (this.moving && this.moveTargetPos != null && dataFairy != null && dataFairy.isDepressed && this.func_70661_as().func_75500_f()) {
            Vec3d target = new Vec3d((double)this.moveTargetPos.func_177958_n(), (double)this.moveTargetPos.func_177956_o(), (double)this.moveTargetPos.func_177952_p()).func_72441_c(0.5, 0.5, 0.5);
            double dist = target.func_72436_e(this.func_174791_d());
            if (Math.abs(dist - this.previousDist) < 0.01) {
                this.func_70605_aq().func_75642_a(RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0), RandUtil.nextDouble(-1.0, 1.0), 0.5);
                this.previousDist = dist;
                this.lastFreeTime = 5L;
                this.adjustingPath = true;
                return;
            }
            if (this.adjustingPath && this.lastFreeTime <= 0L) {
                this.func_70605_aq().func_75642_a((double)this.moveTargetPos.func_177958_n() + 0.5, (double)this.moveTargetPos.func_177956_o() + 0.5, (double)this.moveTargetPos.func_177952_p() + 0.5, 0.5);
                this.adjustingPath = false;
            } else if (this.adjustingPath) {
                --this.lastFreeTime;
            }
            if (dist < 1.3) {
                this.func_70634_a((double)this.moveTargetPos.func_177958_n() + 0.5, (double)this.moveTargetPos.func_177956_o() + 0.5, (double)this.moveTargetPos.func_177952_p() + 0.5);
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.moving = false;
            }
            this.previousDist = dist;
        }
    }

    public void moveTo(BlockPos pos) {
        this.moveTargetPos = pos;
        this.func_70605_aq().func_75642_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0);
        this.moving = true;
    }

    @NotNull
    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        ItemStack jar = player.func_184614_ca();
        if (jar.func_77973_b() == ModItems.JAR_ITEM && jar.func_77952_i() == 0) {
            this.succFairy(jar, player);
            return EnumActionResult.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    private void succFairy(ItemStack stack, EntityPlayer player) {
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy == null) {
            return;
        }
        stack.func_190918_g(1);
        ItemStack jar = new ItemStack((Item)ModItems.JAR_ITEM);
        jar.func_77964_b(2);
        dataFairy.wasTamperedWith = true;
        NBTHelper.setTag((ItemStack)jar, (String)"fairy", (NBTBase)dataFairy.serializeNBT());
        player.func_191521_c(jar);
        this.field_70170_p.func_72900_e((Entity)this);
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy == null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() <= 0.0f) {
            PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketExplode(this.func_174791_d().func_72441_c(0.0, 0.25, 0.0), dataFairy.primaryColor, dataFairy.secondaryColor, 0.5, 0.5, RandUtil.nextInt(100, 200), 75, 25, true), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 256.0));
        }
    }

    public void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy == null) {
            return;
        }
        ItemStack fairyWings = new ItemStack((Item)ModItems.FAIRY_WINGS);
        ItemStack fairyDust = new ItemStack((Item)ModItems.FAIRY_DUST);
        NBTHelper.setInt((ItemStack)fairyWings, (String)"fairy_color", (int)dataFairy.primaryColor.getRGB());
        this.func_70099_a(fairyDust, RandUtil.nextFloat());
        this.func_70099_a(fairyWings, RandUtil.nextFloat());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDataFairy(FairyData.deserialize(NBTHelper.getCompoundTag((NBTTagCompound)compound, (String)"fairy")));
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"origin_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"origin_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"origin_z")) {
            this.originPos = new BlockPos(NBTHelper.getInteger((NBTTagCompound)compound, (String)"origin_x"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"origin_y"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"origin_z"));
        }
        if (NBTHelper.hasKey((NBTTagCompound)compound, (String)"move_target_x") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"move_target_y") && NBTHelper.hasKey((NBTTagCompound)compound, (String)"move_target_z")) {
            this.moveTargetPos = new BlockPos(NBTHelper.getInteger((NBTTagCompound)compound, (String)"move_target_x"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"move_target_y"), NBTHelper.getInteger((NBTTagCompound)compound, (String)"move_target_z"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        FairyData dataFairy = this.getDataFairy();
        if (dataFairy != null) {
            NBTHelper.setCompoundTag((NBTTagCompound)compound, (String)"fairy", (NBTTagCompound)dataFairy.serializeNBT());
        }
        if (this.originPos != null) {
            compound.func_74768_a("origin_x", this.originPos.func_177958_n());
            compound.func_74768_a("origin_y", this.originPos.func_177956_o());
            compound.func_74768_a("origin_z", this.originPos.func_177952_p());
        }
        if (this.moveTargetPos != null) {
            compound.func_74768_a("move_target_x", this.moveTargetPos.func_177958_n());
            compound.func_74768_a("move_target_y", this.moveTargetPos.func_177956_o());
            compound.func_74768_a("move_target_z", this.moveTargetPos.func_177952_p());
        }
    }
}

