/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.render.block;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.animations.BasicAnimation;
import com.teamwizardry.librarianlib.features.base.block.tile.TileMod;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpBezier3D;
import com.teamwizardry.librarianlib.features.tesr.TileRenderHandler;
import com.teamwizardry.wizardry.api.block.ICraftingPlateRecipe;
import com.teamwizardry.wizardry.api.block.IStructure;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.core.renderer.StructureErrorRenderer;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.tile.TileCraftingPlate;
import com.teamwizardry.wizardry.crafting.CraftingPlateRecipeManager;
import com.teamwizardry.wizardry.init.ModStructures;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

@SideOnly(value=Side.CLIENT)
public class TileCraftingPlateRenderer
extends TileRenderHandler<TileCraftingPlate> {
    private static Animator animator = new Animator();
    private WeakHashMap<Integer, LocationAndAngle> locationsAndAngles;

    public TileCraftingPlateRenderer(@Nonnull TileCraftingPlate tile) {
        super((TileMod)tile);
        animator.setUseWorldTicks(true);
        this.locationsAndAngles = new WeakHashMap();
        for (int i = 0; i < ((ItemStackHandler)tile.realInventory.getHandler()).getSlots(); ++i) {
            this.update(i);
        }
    }

    public void update(int slot) {
        ItemStack stack = ((ItemStackHandler)((TileCraftingPlate)this.tile).realInventory.getHandler()).getStackInSlot(slot);
        if (stack.func_190926_b()) {
            this.locationsAndAngles.remove(slot);
        } else {
            this.locationsAndAngles.put(slot, new LocationAndAngle((TileCraftingPlate)this.tile, 0.0, 0.5, 0.0, RandUtil.nextDouble(0.0, 360.0)));
        }
    }

    public void render(float partialTicks, int destroyStage, float alpha) {
        ICraftingPlateRecipe recipeForItem;
        ArrayList<BlockPos> errors = new ArrayList<BlockPos>(((IStructure)((TileCraftingPlate)this.tile).func_145838_q()).testStructure(((TileCraftingPlate)this.tile).func_145831_w(), ((TileCraftingPlate)this.tile).func_174877_v()));
        errors.sort(Vec3i::compareTo);
        ItemStack input = ((TileCraftingPlate)this.tile).getInput();
        if (input.func_190926_b() && (input = ((TileCraftingPlate)this.tile).getOutput()).func_190926_b()) {
            input = ItemStack.field_190927_a;
        }
        if ((recipeForItem = CraftingPlateRecipeManager.getRecipe(((TileCraftingPlate)this.tile).func_145831_w(), ((TileCraftingPlate)this.tile).func_174877_v(), input)) != null) {
            recipeForItem.renderInput(((TileCraftingPlate)this.tile).func_145831_w(), ((TileCraftingPlate)this.tile).func_174877_v(), input, partialTicks);
        }
        if (!errors.isEmpty() && ((TileCraftingPlate)this.tile).revealStructure && ((TileCraftingPlate)this.tile).func_145838_q() instanceof IStructure) {
            ModStructures.structureManager.draw(ModStructures.CRAFTING_PLATE, (float)(Math.sin((double)ClientTickHandler.getTicks() / 10.0) + 1.0) / 10.0f + 0.3f);
        }
        if (!errors.isEmpty()) {
            for (BlockPos error : errors) {
                StructureErrorRenderer.addError(error);
            }
            return;
        }
        if (((TileCraftingPlate)this.tile).func_145831_w().func_175623_d(((TileCraftingPlate)this.tile).func_174877_v().func_177972_a(EnumFacing.UP)) && !CraftingPlateRecipeManager.doesRecipeExist(((TileCraftingPlate)this.tile).func_145831_w(), ((TileCraftingPlate)this.tile).func_174877_v(), input) && RandUtil.nextInt(4) == 0) {
            LibParticles.CRAFTING_ALTAR_IDLE(((TileCraftingPlate)this.tile).func_145831_w(), new Vec3d((Vec3i)((TileCraftingPlate)this.tile).func_174877_v()).func_72441_c(0.5, 0.7, 0.5));
        }
        int mapSize = this.locationsAndAngles.size();
        for (Map.Entry<Integer, LocationAndAngle> entry : this.locationsAndAngles.entrySet()) {
            ItemStack stack = ((ItemStackHandler)((TileCraftingPlate)this.tile).realInventory.getHandler()).getStackInSlot(entry.getKey().intValue());
            LocationAndAngle locationsAndAngle = entry.getValue();
            if (stack.func_190926_b() || locationsAndAngle == null) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(0.5 + locationsAndAngle.location.field_72450_a), (double)(1.0 + locationsAndAngle.location.field_72448_b), (double)(0.5 + locationsAndAngle.location.field_72449_c));
            GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
            GlStateManager.func_179114_b((float)(locationsAndAngle.randX + ClientTickHandler.getTicks()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(locationsAndAngle.randY + ClientTickHandler.getTicks()), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(locationsAndAngle.randZ + ClientTickHandler.getTicks()), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            RenderHelper.func_74518_a();
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
            if (((TileCraftingPlate)this.tile).suckingCooldown <= 0) {
                if (RandUtil.nextInt(mapSize / 2) != 0) continue;
                LibParticles.CLUSTER_DRAPE(((TileCraftingPlate)this.tile).func_145831_w(), locationsAndAngle.location.func_178787_e(new Vec3d((Vec3i)((TileCraftingPlate)this.tile).func_174877_v())).func_72441_c(0.5, 0.5, 0.5));
                continue;
            }
            if (RandUtil.nextInt(mapSize / 4) != 0) continue;
            LibParticles.CRAFTING_ALTAR_CLUSTER_SUCTION(((TileCraftingPlate)this.tile).func_145831_w(), new Vec3d((Vec3i)((TileCraftingPlate)this.tile).func_174877_v()).func_72441_c(0.5, 0.75, 0.5), (InterpFunction<Vec3d>)new InterpBezier3D(locationsAndAngle.location, new Vec3d(0.0, 0.0, 0.0)));
        }
    }

    public static class LocationAndAngle {
        public double angle;
        public Vec3d location;
        private int randX;
        private int randY;
        private int randZ;
        private TileCraftingPlate tile;

        LocationAndAngle(TileCraftingPlate tile, double x, double y, double z, double angle) {
            this.tile = tile;
            this.location = new Vec3d(x, y, z);
            this.angle = angle;
            this.randX = RandUtil.nextInt(-1000, 1000);
            this.randY = RandUtil.nextInt(-1000, 1000);
            this.randZ = RandUtil.nextInt(-1000, 1000);
            this.animationLoop();
        }

        private void animationLoop() {
            if (this.tile.func_145837_r()) {
                return;
            }
            try (ManaManager.CapManagerBuilder manager = ManaManager.forObject(this.tile.getWizardryCap());){
                double t = this.tile.getWizardryCap() == null ? 1.0 : 1.0 - manager.getMana() / manager.getMaxMana();
                double radius = RandUtil.nextDouble(5.0, 8.0) * t;
                this.angle += RandUtil.nextDouble(-1.5, 1.5);
                double x = (double)MathHelper.func_76134_b((float)((float)this.angle)) * radius;
                double z = (double)MathHelper.func_76126_a((float)((float)this.angle)) * radius;
                Vec3d newDest = new Vec3d(x, (double)(2.0f + RandUtil.nextFloat() * 7.0f) * t, z);
                BasicAnimation anim = new BasicAnimation((Object)this, "location");
                anim.setTo((Object)newDest);
                anim.setDuration((float)(RandUtil.nextDouble(50.0, 100.0) * (this.tile.suckingCooldown <= 0 ? MathHelper.func_151237_a((double)(t * 2.0), (double)0.0, (double)1.0) : t)));
                anim.setEasing((Easing)(!manager.isManaEmpty() ? Easing.easeInOutQuint : Easing.easeInOutSine));
                anim.setCompletion(this::animationLoop);
                animator.add(new Animation[]{anim});
            }
        }
    }
}

