/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.entity;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.saving.AbstractSaveHandler;
import com.teamwizardry.librarianlib.features.saving.Savable;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.wizardry.api.capability.player.mana.CustomManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.util.ColorUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import java.awt.Color;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Savable
public class FairyData
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    @Save
    public boolean wasTamperedWith = false;
    @Save
    public Color primaryColor = ColorUtils.generateRandomColor();
    @Save
    public Color secondaryColor = ColorUtils.generateRandomColor();
    @Save
    public int age = RandUtil.nextInt(100, 500);
    @Save
    public boolean isDepressed = false;
    @Save
    @Nullable
    public SpellRing infusedSpell = null;
    @Save
    @Nullable
    public UUID owner = null;
    @Save
    public IManaCapability handler = new CustomManaCapability(1000.0, 1000.0, 0.0, 0.0);

    public FairyData() {
    }

    public FairyData(boolean wasTamperedWith, @NotNull Color primaryColor, @NotNull Color secondaryColor, int age, boolean isDepressed, @Nullable SpellRing infusedSpell, UUID owner, @NotNull IManaCapability handler) {
        this.wasTamperedWith = wasTamperedWith;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.age = age;
        this.isDepressed = isDepressed;
        this.infusedSpell = infusedSpell;
        this.owner = owner;
        this.handler = handler;
    }

    @Nullable
    public static FairyData deserialize(NBTTagCompound compound) {
        if (compound == null) {
            return null;
        }
        if (!compound.func_74764_b("save")) {
            return null;
        }
        FairyData fairyData = new FairyData();
        fairyData.deserializeNBT(compound);
        return fairyData;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, Vec3d pos, float partialTicks) {
        if (!this.wasTamperedWith && !this.isDepressed) {
            LibParticles.FAIRY_HEAD(world, pos.func_72441_c(0.0, 0.25, 0.0), this.primaryColor);
            ParticleBuilder glitter = new ParticleBuilder(this.age / 2);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
            if (RandUtil.nextInt(3) == 0) {
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1, (int)0, (i, build) -> {
                    build.setMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01)));
                    if (RandUtil.nextBoolean()) {
                        build.setColor(this.primaryColor);
                    } else {
                        build.setColor(this.secondaryColor);
                    }
                    if (this.isDepressed) {
                        build.setCollision(true);
                        build.enableMotionCalculation();
                        build.setAcceleration(new Vec3d(0.0, -0.005, 0.0));
                    }
                });
            }
        } else if (world.func_82737_E() % 2L == 0L) {
            float excitement = (float)(this.handler.getMana() / this.handler.getMaxMana()) * (float)(!this.isDepressed ? 1 : 0);
            Color color = this.primaryColor;
            ParticleBuilder glitter = new ParticleBuilder((int)((float)RandUtil.nextInt(3, 5) + 20.0f * (1.0f - excitement)));
            glitter.setColor(color);
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.2f, 1.0f));
            glitter.setScale(0.3f + excitement * 3.0f);
            if (RandUtil.nextBoolean()) {
                glitter.setColor(this.primaryColor);
            } else {
                glitter.setColor(this.secondaryColor);
            }
            if (this.isDepressed) {
                glitter.enableMotionCalculation();
                glitter.setCollision(true);
                glitter.setAcceleration(new Vec3d(0.0, -0.002, 0.0));
            }
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)pos), (int)1);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ManaCapabilityProvider.manaCapability;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == ManaCapabilityProvider.manaCapability ? this.handler : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("save", AbstractSaveHandler.writeAutoNBT((Object)this, (boolean)true));
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_74764_b("save")) {
            return;
        }
        AbstractSaveHandler.readAutoNBT((Object)this, (NBTBase)nbt.func_74775_l("save"), (boolean)true);
    }
}

