/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.api.ChiselAPIProps;
import team.chisel.api.IMC;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.compat.TConstruct;
import twilightforest.compat.Thaumcraft;
import twilightforest.compat.ie.IEShaderRegister;
import twilightforest.compat.ie.ItemTFShader;
import twilightforest.compat.ie.ItemTFShaderGrabbag;
import twilightforest.entity.boss.EntityTFHydra;
import twilightforest.entity.boss.EntityTFKnightPhantom;
import twilightforest.entity.boss.EntityTFLich;
import twilightforest.entity.boss.EntityTFMinoshroom;
import twilightforest.entity.boss.EntityTFNaga;
import twilightforest.entity.boss.EntityTFSnowQueen;
import twilightforest.entity.boss.EntityTFUrGhast;
import twilightforest.entity.boss.EntityTFYetiAlpha;
import twilightforest.enums.CastleBrickVariant;
import twilightforest.enums.DeadrockVariant;
import twilightforest.enums.MazestoneVariant;
import twilightforest.enums.TowerWoodVariant;
import twilightforest.enums.UnderBrickVariant;
import twilightforest.item.TFRegisterItemEvent;

@Optional.InterfaceList(value={@Optional.Interface(modid="chisel", iface="team.chisel.api.ChiselAPIProps"), @Optional.Interface(modid="chisel", iface="team.chisel.api.IMC")})
public enum TFCompat {
    BAUBLES("Baubles"){}
    ,
    CHISEL("Chisel"){

        @Override
        public void init() {
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.spiral_bricks));
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.etched_nagastone));
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.nagastone_pillar));
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.etched_nagastone_mossy));
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.nagastone_pillar_mossy));
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.etched_nagastone_weathered));
            this.addBlockToCarvingGroup("stonebrick", new ItemStack(TFBlocks.nagastone_pillar_weathered));
            for (MazestoneVariant mazestoneVariant : MazestoneVariant.values()) {
                this.addBlockToCarvingGroup("mazestone", new ItemStack(TFBlocks.maze_stone, 1, mazestoneVariant.ordinal()));
            }
            for (Enum enum_ : UnderBrickVariant.values()) {
                this.addBlockToCarvingGroup("underbrick", new ItemStack(TFBlocks.underbrick, 1, enum_.ordinal()));
            }
            for (Enum enum_ : TowerWoodVariant.values()) {
                this.addBlockToCarvingGroup("towerwood", new ItemStack(TFBlocks.tower_wood, 1, enum_.ordinal()));
            }
            for (Enum enum_ : DeadrockVariant.values()) {
                this.addBlockToCarvingGroup("deadrock", new ItemStack(TFBlocks.deadrock, 1, enum_.ordinal()));
            }
            for (Enum enum_ : CastleBrickVariant.values()) {
                this.addBlockToCarvingGroup("castlebrick", new ItemStack(TFBlocks.castle_brick, 1, enum_.ordinal()));
            }
            for (int i = 0; i < 4; ++i) {
                this.addBlockToCarvingGroup("castlebrick", new ItemStack(TFBlocks.castle_pillar, 1, i));
            }
            this.addBlockToCarvingGroup("castlebrickstairs", new ItemStack(TFBlocks.castle_stairs, 1, 0));
            this.addBlockToCarvingGroup("castlebrickstairs", new ItemStack(TFBlocks.castle_stairs, 1, 8));
        }

        private void addBlockToCarvingGroup(String group, ItemStack stack) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("group", group);
            nbt.func_74782_a("stack", (NBTBase)stack.serializeNBT());
            FMLInterModComms.sendMessage((String)ChiselAPIProps.MOD_ID, (String)IMC.ADD_VARIATION_V2.toString(), (NBTTagCompound)nbt);
        }
    }
    ,
    IMMERSIVEENGINEERING("Immersive Engineering"){

        @Override
        protected boolean preInit() {
            3.registerSidedHandler(Side.CLIENT, ItemTFShaderGrabbag.ClientEventHandler.class);
            return true;
        }

        @Override
        protected void initItems(TFRegisterItemEvent.ItemRegistryHelper items) {
            items.register("shader", ItemTFShader.shader.func_77655_b("tfEngineeringShader"));
            items.register("shader_bag", ItemTFShaderGrabbag.shader_bag.func_77655_b("tfEngineeringShaderBag"));
            new IEShaderRegister();
        }

        @Override
        protected void init() {
            RailgunHandler.projectilePropertyMap.add(Pair.of((Object)ApiUtils.createIngredientStack((Object)TFBlocks.cicada), (Object)new RailgunHandler.RailgunProjectileProperties(2.0, 0.25){

                public boolean overrideHitEntity(Entity entityHit, Entity shooter) {
                    World world = entityHit.func_130014_f_();
                    world.func_72838_d((Entity)new EntityFallingBlock(world, entityHit.field_70165_t, entityHit.field_70163_u, entityHit.field_70161_v, TFBlocks.cicada.func_176223_P()));
                    world.func_184148_a(null, entityHit.field_70165_t, entityHit.field_70163_u, entityHit.field_70161_v, TFSounds.CICADA, SoundCategory.NEUTRAL, 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    return false;
                }
            }));
            this.excludeFromShaderBags(EntityTFNaga.class);
            this.excludeFromShaderBags(EntityTFLich.class);
            this.excludeFromShaderBags(EntityTFMinoshroom.class);
            this.excludeFromShaderBags(EntityTFHydra.class);
            this.excludeFromShaderBags(EntityTFKnightPhantom.class);
            this.excludeFromShaderBags(EntityTFUrGhast.class);
            this.excludeFromShaderBags(EntityTFYetiAlpha.class);
            this.excludeFromShaderBags(EntityTFSnowQueen.class);
        }

        private void excludeFromShaderBags(Class<? extends Entity> entityClass) {
            FMLInterModComms.sendMessage((String)"immersiveengineering", (String)"shaderbag_exclude", (String)entityClass.getName());
        }
    }
    ,
    JEI("Just Enough Items"){}
    ,
    TCONSTRUCT("Tinkers' Construct"){

        @Override
        protected boolean preInit() {
            TConstruct.preInit();
            return true;
        }

        @Override
        protected void init() {
            TConstruct.init();
        }

        @Override
        protected void postInit() {
            TConstruct.postInit();
        }
    }
    ,
    THAUMCRAFT("Thaumcraft"){

        @Override
        protected boolean preInit() {
            MinecraftForge.EVENT_BUS.register(Thaumcraft.class);
            return true;
        }
    };

    private final String modName;
    private boolean isActivated = false;

    protected boolean preInit() {
        return true;
    }

    protected void init() {
    }

    protected void postInit() {
    }

    protected void initItems(TFRegisterItemEvent.ItemRegistryHelper items) {
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    private TFCompat(String modName) {
        this.modName = modName;
    }

    public static void initCompatItems(TFRegisterItemEvent.ItemRegistryHelper items) {
        for (TFCompat compat : TFCompat.values()) {
            if (!compat.isActivated) continue;
            try {
                compat.initItems(items);
            }
            catch (Exception e) {
                compat.isActivated = false;
                TwilightForestMod.LOGGER.info("twilightforest had a " + e.getLocalizedMessage() + " error loading " + compat.modName + " compatibility in initializing items!");
                TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    public static void preInitCompat() {
        for (TFCompat compat : TFCompat.values()) {
            if (Loader.isModLoaded((String)compat.name().toLowerCase())) {
                try {
                    compat.isActivated = compat.preInit();
                    if (compat.isActivated()) {
                        TwilightForestMod.LOGGER.info("twilightforest has loaded compatibility for mod " + compat.modName + ".");
                        continue;
                    }
                    TwilightForestMod.LOGGER.info("twilightforest couldn't activate compatibility for mod " + compat.modName + "!");
                }
                catch (Exception e) {
                    compat.isActivated = false;
                    TwilightForestMod.LOGGER.info("twilightforest had a " + e.getLocalizedMessage() + " error loading " + compat.modName + " compatibility!");
                    TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
                }
                continue;
            }
            compat.isActivated = false;
            TwilightForestMod.LOGGER.info("twilightforest has skipped compatibility for mod " + compat.modName + ".");
        }
    }

    public static void initCompat() {
        for (TFCompat compat : TFCompat.values()) {
            if (!compat.isActivated) continue;
            try {
                compat.init();
            }
            catch (Exception e) {
                compat.isActivated = false;
                TwilightForestMod.LOGGER.info("twilightforest had a " + e.getLocalizedMessage() + " error loading " + compat.modName + " compatibility in init!");
                TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    public static void postInitCompat() {
        for (TFCompat compat : TFCompat.values()) {
            if (!compat.isActivated) continue;
            try {
                compat.postInit();
            }
            catch (Exception e) {
                compat.isActivated = false;
                TwilightForestMod.LOGGER.info("twilightforest had a " + e.getLocalizedMessage() + " error loading " + compat.modName + " compatibility in postInit!");
                TwilightForestMod.LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    static void registerSidedHandler(Side side, Object handler) {
        if (FMLCommonHandler.instance().getSide() == side) {
            MinecraftForge.EVENT_BUS.register(handler);
        }
    }
}

