/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type.hanginglights;

import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.util.NBTSerializable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;

public final class ColoredLightVariant
implements NBTSerializable {
    private LightVariant variant;
    private EnumDyeColor color;

    private ColoredLightVariant() {
    }

    public ColoredLightVariant(LightVariant variant, EnumDyeColor color) {
        this.variant = variant;
        this.color = color;
    }

    public LightVariant getVariant() {
        return this.variant;
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public ColoredLightVariant withColor(EnumDyeColor color) {
        return new ColoredLightVariant(this.variant, color);
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("light", this.variant.ordinal());
        compound.func_74774_a("color", (byte)this.color.func_176767_b());
        return compound;
    }

    @Override
    public void deserialize(NBTTagCompound compound) {
        this.variant = LightVariant.getLightVariant(compound.func_74762_e("light"));
        this.color = EnumDyeColor.func_176766_a((int)compound.func_74771_c("color"));
    }

    public static ColoredLightVariant from(NBTTagCompound compound) {
        ColoredLightVariant light = new ColoredLightVariant();
        light.deserialize(compound);
        return light;
    }
}

