/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityFluxCompressor
extends TileEntityPneumaticBase
implements IRedstoneControlled,
IHeatExchanger {
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private int airPerTick;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();

    public TileEntityFluxCompressor() {
        this(20.0f, 25.0f, 10000, 4);
    }

    public TileEntityFluxCompressor(float dangerPressure, float criticalPressure, int volume, int upgradeSlots) {
        super(dangerPressure, criticalPressure, volume, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
        this.heatExchanger.setThermalCapacity(100.0);
    }

    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void func_73660_a() {
        List<Pair<EnumFacing, IAirHandler>> teList;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.airPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * (float)this.getEfficiency() * (float)ConfigHandler.machineProperties.fluxCompressorEfficiency / 100.0f / 100.0f);
                this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades());
            }
            if (this.redstoneAllows() && this.energy.getEnergyStored() >= this.rfPerTick) {
                this.addAir(this.airPerTick);
                this.energy.extractEnergy(this.rfPerTick, false);
                this.heatExchanger.addHeat((double)this.rfPerTick / 100.0);
            }
        }
        if (!this.func_145831_w().field_72995_K && (teList = this.getAirHandler(null).getConnectedPneumatics()).size() == 0) {
            this.getAirHandler(null).airLeak(this.getRotation().func_176734_d());
        }
    }

    @Override
    public String getName() {
        return Blockss.FLUX_COMPRESSOR.func_149739_a();
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side == this.getRotation().func_176734_d();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && facing != this.getRotation().func_176734_d() || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != this.getRotation().func_176734_d()) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.energy.writeToNBT(tag);
        tag.func_74774_a("redstoneMode", (byte)this.redstoneMode);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy.readFromNBT(tag);
        this.redstoneMode = tag.func_74771_c("redstoneMode");
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0 && ++this.redstoneMode > 2) {
            this.redstoneMode = 0;
        }
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.heatExchanger;
    }

    public int getInfoEnergyPerTick() {
        return this.rfPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getAirRate() {
        return this.airPerTick;
    }
}

