/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.BlockPressureChamberWallBase;
import me.desht.pneumaticcraft.common.util.PropertyObject;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPressureChamberGlass
extends BlockPressureChamberWallBase {
    public static final IUnlistedProperty<Integer> DOWN = new PropertyObject<Integer>("down", Integer.class);
    public static final IUnlistedProperty<Integer> UP = new PropertyObject<Integer>("up", Integer.class);
    public static final IUnlistedProperty<Integer> NORTH = new PropertyObject<Integer>("north", Integer.class);
    public static final IUnlistedProperty<Integer> SOUTH = new PropertyObject<Integer>("south", Integer.class);
    public static final IUnlistedProperty<Integer> WEST = new PropertyObject<Integer>("west", Integer.class);
    public static final IUnlistedProperty<Integer> EAST = new PropertyObject<Integer>("east", Integer.class);
    private static final int[] TEXTURE_LOOKUP_TABLE = new int[]{0, 0, 6, 6, 0, 0, 6, 6, 3, 3, 19, 15, 3, 3, 19, 15, 1, 1, 18, 18, 1, 1, 13, 13, 2, 2, 23, 31, 2, 2, 27, 14, 0, 0, 6, 6, 0, 0, 6, 6, 3, 3, 19, 15, 3, 3, 19, 15, 1, 1, 18, 18, 1, 1, 13, 13, 2, 2, 23, 31, 2, 2, 27, 14, 4, 4, 5, 5, 4, 4, 5, 5, 17, 17, 22, 26, 17, 17, 22, 26, 16, 16, 20, 20, 16, 16, 28, 28, 21, 21, 46, 42, 21, 21, 43, 38, 4, 4, 5, 5, 4, 4, 5, 5, 9, 9, 30, 12, 9, 9, 30, 12, 16, 16, 20, 20, 16, 16, 28, 28, 25, 25, 45, 37, 25, 25, 40, 32, 0, 0, 6, 6, 0, 0, 6, 6, 3, 3, 19, 15, 3, 3, 19, 15, 1, 1, 18, 18, 1, 1, 13, 13, 2, 2, 23, 31, 2, 2, 27, 14, 0, 0, 6, 6, 0, 0, 6, 6, 3, 3, 19, 15, 3, 3, 19, 15, 1, 1, 18, 18, 1, 1, 13, 13, 2, 2, 23, 31, 2, 2, 27, 14, 4, 4, 5, 5, 4, 4, 5, 5, 17, 17, 22, 26, 17, 17, 22, 26, 7, 7, 24, 24, 7, 7, 10, 10, 29, 29, 44, 41, 29, 29, 39, 33, 4, 4, 5, 5, 4, 4, 5, 5, 9, 9, 30, 12, 9, 9, 30, 12, 7, 7, 24, 24, 7, 7, 10, 10, 8, 8, 36, 35, 8, 8, 34, 11};

    BlockPressureChamberGlass() {
        super("pressure_chamber_glass");
        this.func_149752_b(20000.0f);
    }

    private boolean isGlass(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        return extendedBlockState.withProperty(DOWN, (Object)this.getTextureIndex(world, pos, EnumFacing.DOWN)).withProperty(UP, (Object)this.getTextureIndex(world, pos, EnumFacing.UP)).withProperty(NORTH, (Object)this.getTextureIndex(world, pos, EnumFacing.NORTH)).withProperty(SOUTH, (Object)this.getTextureIndex(world, pos, EnumFacing.SOUTH)).withProperty(WEST, (Object)this.getTextureIndex(world, pos, EnumFacing.WEST)).withProperty(EAST, (Object)this.getTextureIndex(world, pos, EnumFacing.EAST));
    }

    private int getTextureIndex(IBlockAccess world, BlockPos pos, EnumFacing face) {
        boolean[] bitMatrix = new boolean[8];
        switch (face) {
            case DOWN: 
            case UP: {
                bitMatrix[0] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.DOWN ? 1 : -1, 0, -1));
                bitMatrix[1] = this.isGlass(world, pos.func_177982_a(0, 0, -1));
                bitMatrix[2] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.UP ? 1 : -1, 0, -1));
                bitMatrix[3] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.DOWN ? 1 : -1, 0, 0));
                bitMatrix[4] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.UP ? 1 : -1, 0, 0));
                bitMatrix[5] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.DOWN ? 1 : -1, 0, 1));
                bitMatrix[6] = this.isGlass(world, pos.func_177982_a(0, 0, 1));
                bitMatrix[7] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.UP ? 1 : -1, 0, 1));
                break;
            }
            case NORTH: 
            case SOUTH: {
                bitMatrix[0] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.NORTH ? 1 : -1, 1, 0));
                bitMatrix[1] = this.isGlass(world, pos.func_177982_a(0, 1, 0));
                bitMatrix[2] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.SOUTH ? 1 : -1, 1, 0));
                bitMatrix[3] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.NORTH ? 1 : -1, 0, 0));
                bitMatrix[4] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.SOUTH ? 1 : -1, 0, 0));
                bitMatrix[5] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.NORTH ? 1 : -1, -1, 0));
                bitMatrix[6] = this.isGlass(world, pos.func_177982_a(0, -1, 0));
                bitMatrix[7] = this.isGlass(world, pos.func_177982_a(face == EnumFacing.SOUTH ? 1 : -1, -1, 0));
                break;
            }
            case WEST: 
            case EAST: {
                bitMatrix[0] = this.isGlass(world, pos.func_177982_a(0, 1, face == EnumFacing.EAST ? 1 : -1));
                bitMatrix[1] = this.isGlass(world, pos.func_177982_a(0, 1, 0));
                bitMatrix[2] = this.isGlass(world, pos.func_177982_a(0, 1, face == EnumFacing.WEST ? 1 : -1));
                bitMatrix[3] = this.isGlass(world, pos.func_177982_a(0, 0, face == EnumFacing.EAST ? 1 : -1));
                bitMatrix[4] = this.isGlass(world, pos.func_177982_a(0, 0, face == EnumFacing.WEST ? 1 : -1));
                bitMatrix[5] = this.isGlass(world, pos.func_177982_a(0, -1, face == EnumFacing.EAST ? 1 : -1));
                bitMatrix[6] = this.isGlass(world, pos.func_177982_a(0, -1, 0));
                bitMatrix[7] = this.isGlass(world, pos.func_177982_a(0, -1, face == EnumFacing.WEST ? 1 : -1));
            }
        }
        int idBuilder = 0;
        for (int i = 0; i < bitMatrix.length; ++i) {
            idBuilder |= bitMatrix[i] ? 1 << i : 0;
        }
        return idBuilder > 255 || idBuilder < 0 ? 0 : TEXTURE_LOOKUP_TABLE[idBuilder];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(side));
        return !iblockstate.func_185914_p() && iblockstate.func_177230_c() != this;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

