/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.guielements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiScrollElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiSlideControl;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementFactory;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.PiMarkdownReader;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.MarkdownVisitor;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.PITextures;
import com.brandon3055.projectintelligence.client.StyleHandler;
import com.brandon3055.projectintelligence.client.gui.PIPartRenderer;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.docmanagement.DocumentationPage;
import com.brandon3055.projectintelligence.docmanagement.ModStructurePage;
import com.brandon3055.projectintelligence.docmanagement.RootPage;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiPartMDWindow
extends MGuiElementBase<GuiPartMDWindow> {
    public static StyleHandler.PropertyGroup headerProps = new StyleHandler.PropertyGroup("md_window.header");
    public static StyleHandler.PropertyGroup bodyProps = new StyleHandler.PropertyGroup("md_window.body");
    public static StyleHandler.PropertyGroup scrollProps = new StyleHandler.PropertyGroup("md_window.scroll_bar");
    public static StyleHandler.PropertyGroup scrollSliderProps = new StyleHandler.PropertyGroup("md_window.scroll_bar.scroll_slider");
    public PIPartRenderer headerRenderer = new PIPartRenderer(headerProps).setSideTrims(true, true, false, true);
    public PIPartRenderer bodyRenderer = new PIPartRenderer(bodyProps);
    public PIPartRenderer tabRenderer = new PIPartRenderer(bodyProps).setSideTrims(true, true, false, true);
    protected Map<DisplayController.TabData, PageTab> tabMap = new HashMap<DisplayController.TabData, PageTab>();
    protected Map<PageTab, GuiScrollElement> pageElementMap = new HashMap<PageTab, GuiScrollElement>();
    private DisplayController controller;

    public GuiPartMDWindow(DisplayController controller) {
        this.controller = controller;
        this.disableOnRemove = true;
    }

    public void addChildElements() {
        super.addChildElements();
    }

    public void reloadElement() {
        this.updateDisplay();
        super.reloadElement();
    }

    public void updateDisplay() {
        this.tabMap.entrySet().removeIf(entry -> this.validateTab((DisplayController.TabData)entry.getKey()));
        for (DisplayController.TabData tabData2 : this.controller.getOpenTabs()) {
            if (this.tabMap.containsKey(tabData2)) continue;
            this.addTab(tabData2, new PageTab(this, tabData2, this.controller));
        }
        this.tabMap.forEach((tabData, tab) -> tab.updateSizePosition(false));
    }

    private void addTab(DisplayController.TabData tabData, PageTab tab) {
        this.tabMap.put(tabData, tab);
        tab.setYPosMod((t, i) -> this.yPos());
        this.addChild(tab);
    }

    private boolean validateTab(DisplayController.TabData tabData) {
        if (!this.controller.getOpenTabs().contains(tabData)) {
            if (this.tabMap.containsKey(tabData)) {
                this.removeChild((MGuiElementBase)this.tabMap.get(tabData));
            }
            return true;
        }
        return false;
    }

    public <C extends MGuiElementBase> C removeChild(C child) {
        if (this.pageElementMap.containsKey(child)) {
            this.removeChild((MGuiElementBase)this.pageElementMap.remove(child));
        }
        return (C)super.removeChild(child);
    }

    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        int tabBarSize = 12;
        this.headerRenderer.render(this, this.xPos(), this.yPos(), this.xSize(), tabBarSize);
        this.bodyRenderer.render(this, this.xPos(), this.yPos() + tabBarSize, this.xSize(), this.ySize() - tabBarSize);
        DisplayController.TabData selectedData = this.controller.getActiveTab();
        MGuiElementBase selectedTab = this.tabMap.get(selectedData);
        if (selectedTab != null) {
            selectedTab.preDraw(minecraft, mouseX, mouseY, partialTicks);
            selectedTab.renderElement(minecraft, mouseX, mouseY, partialTicks);
            selectedTab.postDraw(minecraft, mouseX, mouseY, partialTicks);
        }
        for (MGuiElementBase element : this.childElements) {
            if (!element.isEnabled() || element instanceof PageTab && selectedData == ((PageTab)element).tabData) continue;
            element.preDraw(minecraft, mouseX, mouseY, partialTicks);
            element.renderElement(minecraft, mouseX, mouseY, partialTicks);
            element.postDraw(minecraft, mouseX, mouseY, partialTicks);
        }
        if (!bodyProps.vanillaTex()) {
            this.zOffset += 100.0;
            this.drawMultiPassGradientRect(this.xPos() + 3, this.yPos() + 14, this.maxXPos() - 13, this.yPos() + 18, bodyProps.colour(), bodyProps.colour() & 0xFFFFFF, 2);
            this.drawMultiPassGradientRect(this.xPos() + 3, this.maxYPos() - 6, this.maxXPos() - 13, this.maxYPos() - 2, bodyProps.colour() & 0xFFFFFF, bodyProps.colour(), 2);
            this.zOffset -= 100.0;
        }
    }

    public static class PageTab
    extends MGuiElementBase<PageTab> {
        public PIPartRenderer scrollRenderer = new PIPartRenderer(scrollProps);
        public PIPartRenderer scrollSlideRenderer = new PIPartRenderer(scrollSliderProps);
        protected int moveX;
        protected int dragOffset = 0;
        protected String name;
        protected String pageURI;
        protected DisplayController.TabData tabData;
        private DisplayController controller;
        protected boolean isDragging = false;
        protected boolean shouldReloadMD = false;
        protected GuiButton closeButton;
        protected GuiPartMDWindow mdWindow;
        protected GuiSlideControl scrollBar;
        protected GuiScrollElement scrollElement;
        protected MDElementContainer markdownContainer;

        public PageTab(GuiPartMDWindow mdWindow, DisplayController.TabData tabData, DisplayController controller) {
            this.mdWindow = mdWindow;
            this.pageURI = tabData.pageURI;
            this.name = tabData.getDocPage().getDisplayName();
            this.tabData = tabData;
            this.controller = controller;
            this.setYSize(12);
        }

        public void addChildElements() {
            super.addChildElements();
            this.closeButton = (GuiButton)((GuiButton)((GuiButton)new GuiButton().setXPosMod((guiButton, integer) -> this.maxXPos() - 11)).setYPos(this.yPos() + 2)).setSize(9, 9);
            this.closeButton.setListener(() -> this.controller.closeTab(this.tabData));
            this.closeButton.setHoverText(I18n.func_135052_a((String)"pi.button.close", (Object[])new Object[0]));
            this.closeButton.addChild(((GuiTexture)new GuiTexture(64, 16, 5, 5, PITextures.PI_PARTS).setRelPos(0, 2)).setXPosMod((guiButton, integer) -> this.maxXPos() - 9));
            this.addChild((MGuiElementBase)this.closeButton);
            this.scrollBar = new GuiSlideControl(GuiSlideControl.SliderRotation.VERTICAL);
            this.scrollBar.setXPosMod((guiSlideControl, integer) -> this.mdWindow.maxXPos() - this.scrollBar.xSize() - 3);
            this.scrollBar.setYPosMod((guiSlideControl, integer) -> this.mdWindow.yPos() + 14);
            this.scrollBar.setXSize(8);
            this.scrollBar.setBackgroundElement((MGuiElementBase)this.scrollRenderer.asElement().setHoverStateSupplier(() -> this.scrollBar.isDragging()));
            this.scrollBar.setSliderElement((MGuiElementBase)this.scrollSlideRenderer.asElement().setHoverStateSupplier(() -> this.scrollBar.isDragging()));
            this.scrollBar.getBackgroundElement().setXPosMod((o, integer) -> this.scrollBar.xPos()).setYPosMod((o, integer) -> this.scrollBar.yPos());
            this.scrollBar.getSliderElement().setXPosMod((o, integer) -> this.scrollBar.getInsetRect().x);
            this.scrollBar.setInputListener(guiSlideControl -> {
                this.tabData.scrollPosition = guiSlideControl.getRawPos();
            });
            this.scrollElement = new GuiScrollElement();
            this.scrollElement.setVerticalScrollBar(this.scrollBar);
            this.scrollElement.setAllowedScrollAxes(true, false);
            ((GuiScrollElement)this.scrollElement.setXPosMod((e, i) -> this.mdWindow.xPos())).setYPosMod((e, i) -> this.mdWindow.yPos() + 12);
            ((GuiScrollElement)this.scrollElement.setXSizeMod((e, i) -> this.mdWindow.xSize())).setYSizeMod((e, i) -> this.mdWindow.ySize() - 12);
            this.scrollElement.setEnabledCallback(() -> this.controller.getActiveTab() == this.tabData);
            this.scrollElement.setInsets(2, 1, 2, 11);
            this.scrollElement.setStandardScrollBehavior();
            this.mdWindow.addChild((MGuiElementBase)this.scrollElement);
            this.mdWindow.pageElementMap.put(this, this.scrollElement);
            this.markdownContainer = new MDElementContainer((MGuiElementBase)this);
            this.markdownContainer.setInsets(6, 6, 6, 6);
            this.markdownContainer.addAndFireReloadCallback(guiMarkdownElement -> {
                MDElementContainer cfr_ignored_0 = (MDElementContainer)guiMarkdownElement.setPosAndSize(this.scrollElement.getInsetRect());
            });
            this.markdownContainer.setLinkClickCallback(this::openLink);
            this.markdownContainer.linkDisplayTarget = this.scrollElement;
            this.scrollElement.addElement((MGuiElementBase)this.markdownContainer);
        }

        private void openLink(String link, int button) {
            GuiButton.playGenericClick((Minecraft)this.mc);
            if (link.startsWith("https://") || link.startsWith("http://") || !link.contains(":")) {
                PIGuiHelper.displayLinkConfirmDialog(this, link);
                return;
            }
            DocumentationPage page = DocumentationManager.getPage(link);
            if (!(page instanceof RootPage)) {
                if (page == null) {
                    PIGuiHelper.displayError("The specified page \"" + link + "\" could not be found!\nThis is ether a broken link or the mod to which the specified page belongs is not installed.");
                } else {
                    this.controller.openPage(link, button == 2);
                }
            }
        }

        public void reloadElement() {
            this.moveX = 0;
            if (this.tabData == null || this.tabData.getDocPage() == null) {
                LogHelper.bigDev("Null Tab Data", new Object[0]);
                return;
            }
            this.name = this.tabData.getDocPage().getDisplayName();
            this.scrollBar.setYSize(this.mdWindow.ySize() - 17);
            this.scrollBar.getBackgroundElement().setSize((MGuiElementBase)this.scrollBar);
            this.scrollElement.resetScrollPositions();
            this.updateSizePosition(false);
            super.reloadElement();
            this.closeButton.setEnabled(this.controller.getOpenTabs().size() > 1);
            this.shouldReloadMD = true;
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            boolean clickCaptured = super.mouseClicked(mouseX, mouseY, mouseButton);
            if (!clickCaptured && this.isMouseOver(mouseX, mouseY)) {
                this.isDragging = true;
                this.closeButton.setEnabled(false);
                this.dragOffset = mouseX - this.xPos();
                if (this.controller.getActiveTab() != this.tabData) {
                    this.controller.switchTab(this.tabData);
                    GuiButton.playGenericClick((Minecraft)this.mc);
                }
                return true;
            }
            return clickCaptured;
        }

        public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
            if (this.isDragging) {
                int tabWidth = Math.min(130, this.mdWindow.xSize() / this.controller.getOpenTabs().size());
                int xPos = this.mdWindow.xPos() + this.controller.getOpenTabs().indexOf(this.tabData) * tabWidth;
                int dragAmount = xPos - (mouseX - this.dragOffset);
                if ((double)Math.abs(dragAmount) > (double)this.xSize() * 0.5) {
                    this.controller.dragTab(this.tabData, dragAmount > 0 ? -1 : 1);
                }
            }
            return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }

        public boolean mouseReleased(int mouseX, int mouseY, int state) {
            this.isDragging = false;
            this.closeButton.setEnabled(this.controller.getOpenTabs().size() > 1);
            return super.mouseReleased(mouseX, mouseY, state);
        }

        public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
            return super.handleMouseScroll(mouseX, mouseY, scrollDirection);
        }

        public void updateSizePosition(boolean animated) {
            int tabWidth = Math.min(130, this.mdWindow.xSize() / this.controller.getOpenTabs().size());
            if (this.xSize() != tabWidth) {
                this.setXSize(tabWidth);
            }
            int xPos = this.mdWindow.xPos() + this.controller.getOpenTabs().indexOf(this.tabData) * tabWidth;
            if (this.xPos() != xPos) {
                if (!animated) {
                    this.setXPos(xPos);
                } else {
                    this.moveX = xPos - this.xPos();
                }
            }
            if (this.moveX > 0) {
                this.setXPos(this.xPos() + Math.max(1, this.moveX / 2));
                this.moveX -= Math.max(1, this.moveX / 2);
            } else if (this.moveX < 0) {
                this.setXPos(this.xPos() + Math.min(-1, this.moveX / 2));
                this.moveX -= Math.max(1, this.moveX / 2);
            }
        }

        public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            int renderX = this.xPos();
            boolean selected = this.scrollElement.isEnabled();
            if (this.isDragging) {
                renderX = MathHelper.clip((int)(mouseX - this.dragOffset), (int)this.mdWindow.xPos(), (int)(this.mdWindow.maxXPos() - this.xSize()));
                this.zOffset += 10.0;
            }
            this.mdWindow.tabRenderer.setTabRender(selected ? 2 : 0).render(this, renderX, this.yPos(), this.xSize(), this.ySize());
            this.drawCustomString(this.fontRenderer, this.name, renderX + 3, this.yPos() + 3, this.xSize() - (this.closeButton.isEnabled() ? 10 : 3), bodyProps.textColour(), GuiAlign.LEFT, GuiAlign.TextRotation.NORMAL, false, true, false);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isDragging) {
                this.zOffset -= 10.0;
            }
            super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        }

        public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            if (super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks)) {
                return true;
            }
            if (this.isMouseOver(mouseX, mouseY) && this.hoverTime > 10 && !this.isDragging) {
                ArrayList<String> list = new ArrayList<String>();
                DocumentationPage page = this.tabData.getDocPage();
                if (page instanceof RootPage) {
                    page = ((RootPage)page).getHomePage();
                }
                if (page != null) {
                    if (page instanceof ModStructurePage) {
                        list.add(TextFormatting.BLUE + page.getModName());
                    } else {
                        list.add(TextFormatting.BLUE + page.getModName() + ": " + TextFormatting.GOLD + this.name);
                    }
                    list.add(TextFormatting.GRAY + page.getPageURI());
                    this.drawHoveringText(list, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
                }
                return true;
            }
            return false;
        }

        public boolean onUpdate() {
            if (!this.pageURI.equals(this.tabData.pageURI)) {
                this.pageURI = this.tabData.pageURI;
                this.name = this.tabData.getDocPage().getDisplayName();
                this.reloadElement();
            }
            if (this.scrollBar.getRawPos() != this.tabData.scrollPosition) {
                this.scrollBar.updateRawPos(this.tabData.scrollPosition, true);
            }
            if (this.tabData.requiresEditReload) {
                this.tabData.requiresEditReload = false;
                this.shouldReloadMD = true;
            }
            if (this.shouldReloadMD && this.isEnabled()) {
                this.shouldReloadMD = false;
                DocumentationPage page = this.tabData.getDocPage();
                if (page == null) {
                    Object[] errorText = new String[]{"An error occurred while loading the page!", "Page at " + this.tabData.pageURI + " could not be found.", "This error should not be possible unless PI is in an invalid state.", "I suggest you try reloading PI."};
                    this.updateMarkdown(Lists.newArrayList((Object[])errorText));
                } else {
                    this.updateMarkdown(page.getMarkdownLines());
                }
            }
            this.updateSizePosition(true);
            return super.onUpdate();
        }

        private void updateMarkdown(List<String> mdLines) {
            this.markdownContainer.clearContainer();
            PiMarkdownReader reader = new PiMarkdownReader(mdLines);
            MDElementFactory factory = new MDElementFactory(this.markdownContainer);
            factory.setColourSupplier(() -> bodyProps.textColour());
            reader.accept((MarkdownVisitor)factory);
            this.markdownContainer.layoutMarkdownElements();
        }
    }
}

