/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator.gui;

import com.ezrol.terry.lib.huffstruct.Huffstruct;
import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.BooleanTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.ConfigurationFile;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.QuadStateTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringListTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.UuidTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.gui.ConfigChooseWorldType;
import com.ezrol.terry.minecraft.defaultworldgenerator.gui.ConfigWorldDataListGui;
import com.ezrol.terry.minecraft.defaultworldgenerator.gui.GuiConfigStateButton;
import com.ezrol.terry.minecraft.defaultworldgenerator.gui.StringListGui;
import com.ezrol.terry.minecraft.defaultworldgenerator.integration.PackModeInterface;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.WorldType;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class ConfigWorldDataGui
extends GuiScreen
implements GuiPageButtonList.GuiResponder {
    private ConfigWorldDataListGui parent;
    private WorldTypeNode activeNode;
    private final byte[] origData;
    private static final int BTN_REVERT_ID = 101;
    private static final int BTN_DONE_ID = 102;
    private static final int TXT_WORLD_NAME_ID = 201;
    private static final int TXT_DESCRIPTION_ID = 202;
    private static final int TXT_UUID_ID = 203;
    private static final int TOGGLE_LOCKTYPE_ID = 204;
    private static final int TOGGLE_IN_LIST_ID = 205;
    private static final int TXT_WORLD_SEED_ID = 206;
    private static final int TOGGLE_STRUCTURES_ID = 207;
    private static final int TOGGLE_BONUSCHEST_ID = 208;
    private static final int TOGGLE_ICON_ID = 209;
    private static final int BTN_SET_WORLD_TYPE_ID = 210;
    private static final int BTN_CUSTOMIZE_WORLD_ID = 211;
    private static final int BTN_LOAD_COMMANDS_ID = 212;
    private static final int BTN_DATA_PACKS_ID = 213;
    private static final int TOGGLE_PACK_MODE = 214;
    private final String title;
    private String[] booleanValues;
    private String[] stateValues;
    private String[] pngFiles;
    private String[] packModes;
    private int leftRow = 0;
    private int rightRow = 0;
    private int rowWidth = 10;
    private GuiTextField configNameTextField;
    private GuiTextField configDescriptionField;
    private GuiTextField configUUIDField;
    private GuiTextField configSeedField;
    private String newUUID = null;

    public ConfigWorldDataGui(WorldTypeNode node, ConfigWorldDataListGui par) {
        this.parent = par;
        this.title = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.world.title", (Object[])new Object[0]);
        this.origData = Huffstruct.dumpData(node);
        this.activeNode = new WorldTypeNode(Huffstruct.loadData(this.origData));
        this.booleanValues = new String[2];
        this.booleanValues[0] = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.boolean.false", (Object[])new Object[0]);
        this.booleanValues[1] = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.boolean.true", (Object[])new Object[0]);
        this.stateValues = new String[4];
        this.stateValues[0] = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.state.disabled", (Object[])new Object[0]);
        this.stateValues[1] = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.state.enabled", (Object[])new Object[0]);
        this.stateValues[2] = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.state.blocked", (Object[])new Object[0]);
        this.stateValues[3] = I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.state.forced", (Object[])new Object[0]);
        this.pngFiles = DefaultWorldGenerator.modSettingsDir.list((dir, name) -> name != null && name.endsWith(".png"));
        this.pngFiles = (String[])ArrayUtils.add((Object[])this.pngFiles, (int)0, (Object)"NONE");
        List<String> modes = PackModeInterface.getInterface().getPackModes();
        modes.add(0, "any");
        for (int i = 1; i < modes.size(); ++i) {
            modes.set(i, "packmode:" + modes.get(i));
        }
        this.packModes = modes.toArray(new String[0]);
    }

    private String quadStateToBtn(QuadStateTypeNode n) {
        switch (n.getValue()) {
            case STATE_DISABLED: {
                return this.stateValues[0];
            }
            case STATE_ENABLED: {
                return this.stateValues[1];
            }
            case STATE_BLOCKED: {
                return this.stateValues[2];
            }
            case STATE_FORCED: {
                return this.stateValues[3];
            }
        }
        return "";
    }

    private void setQuadStateFromBtn(QuadStateTypeNode n, String val) {
        if (val.equals(this.stateValues[0])) {
            n.setValue(QuadStateTypeNode.States.STATE_DISABLED);
        } else if (val.equals(this.stateValues[1])) {
            n.setValue(QuadStateTypeNode.States.STATE_ENABLED);
        } else if (val.equals(this.stateValues[2])) {
            n.setValue(QuadStateTypeNode.States.STATE_BLOCKED);
        } else if (val.equals(this.stateValues[3])) {
            n.setValue(QuadStateTypeNode.States.STATE_FORCED);
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.leftRow = this.field_146294_l / 7;
        this.rightRow = this.field_146294_l / 2 + 8;
        this.rowWidth = this.field_146294_l / 7 * 5 / 2 - 8;
        if (this.rowWidth < 175) {
            if (this.field_146294_l / 2 - 13 > 175) {
                this.leftRow = this.field_146294_l / 2 - 183;
                this.rowWidth = 175;
            } else {
                this.leftRow = 5;
                this.rightRow = this.field_146294_l / 2 + 8;
                this.rowWidth = this.field_146294_l / 2 - 13;
            }
        }
        if (this.rowWidth > 375) {
            this.leftRow = this.field_146294_l / 2 - 383;
            this.rowWidth = 375;
        }
        this.field_146292_n.add(new GuiButton(101, this.leftRow, this.field_146295_m - 28, this.rowWidth, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.revert", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(102, this.rightRow, this.field_146295_m - 28, this.rowWidth, 20, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.done", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiConfigStateButton(205, this.leftRow, 185, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.toggle.inlist", (Object[])new Object[0]), this.booleanValues, this.booleanValues[((BooleanTypeNode)this.activeNode.getField(WorldTypeNode.Fields.SHOW_IN_LIST)).getValue() ? 1 : 0]));
        this.field_146292_n.add(new GuiConfigStateButton(204, this.rightRow, 185, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.toggle.locked", (Object[])new Object[0]), this.booleanValues, this.booleanValues[((BooleanTypeNode)this.activeNode.getField(WorldTypeNode.Fields.LOCK_WORLD_TYPE)).getValue() ? 1 : 0]));
        String icon = ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.CONFIGURATION_IMAGE)).getValue();
        if (icon.equals("")) {
            icon = "NONE";
        }
        if (!ArrayUtils.contains((Object[])this.pngFiles, (Object)icon)) {
            this.pngFiles = (String[])ArrayUtils.add((Object[])this.pngFiles, (Object)icon);
        }
        this.field_146292_n.add(new GuiConfigStateButton(209, this.rightRow, 122, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.toggle.worldicon", (Object[])new Object[0]), this.pngFiles, icon));
        if (this.packModes.length > 1) {
            this.field_146292_n.add(new GuiConfigStateButton(214, this.rightRow, 4, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.toggle.packmode", (Object[])new Object[0]), this.packModes, ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.PACK_MODE)).getValue()));
        }
        this.field_146292_n.add(new GuiConfigStateButton(208, this.leftRow, 143, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.toggle.bonuschest", (Object[])new Object[0]), this.stateValues, this.quadStateToBtn((QuadStateTypeNode)this.activeNode.getField(WorldTypeNode.Fields.BONUS_CHEST_STATE))));
        this.field_146292_n.add(new GuiConfigStateButton(207, this.rightRow, 143, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.toggle.structures", (Object[])new Object[0]), this.stateValues, this.quadStateToBtn((QuadStateTypeNode)this.activeNode.getField(WorldTypeNode.Fields.STRUCTURE_STATE))));
        this.field_146292_n.add(new GuiButton(210, this.leftRow, 90, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.worldtype", (Object[])new Object[]{((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.WORLD_GENERATOR)).getValue()})));
        this.field_146292_n.add(new GuiButton(211, this.rightRow, 90, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.btn.customize", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(212, this.leftRow, 164, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.lst.commands", (Object[])new Object[]{((StringListTypeNode)this.activeNode.getField(WorldTypeNode.Fields.WORLD_LOAD_COMMANDS)).getValue().size()})));
        this.field_146292_n.add(new GuiButton(213, this.rightRow, 164, this.rowWidth, 18, I18n.func_135052_a((String)"defaultworldgenerator-port.config.lst.datapacks", (Object[])new Object[]{((StringListTypeNode)this.activeNode.getField(WorldTypeNode.Fields.DATA_PACKS)).getValue().size()})));
        this.configNameTextField = new GuiTextField(201, this.field_146289_q, this.leftRow, 37, this.rowWidth, 18);
        this.configNameTextField.func_146203_f(255);
        this.configNameTextField.func_146180_a(((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.CONFIGURATION_NAME)).getValue());
        this.configNameTextField.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.configNameTextField.func_146196_d();
        this.configDescriptionField = new GuiTextField(202, this.field_146289_q, this.leftRow, 69, this.rightRow + this.rowWidth - this.leftRow, 18);
        this.configDescriptionField.func_146203_f(512);
        this.configDescriptionField.func_146180_a(((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.CONFIGURATION_DESC)).getValue());
        this.configDescriptionField.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.configDescriptionField.func_146196_d();
        this.configUUIDField = new GuiTextField(203, this.field_146289_q, this.rightRow, 37, this.rowWidth, 18);
        this.configUUIDField.func_146203_f(64);
        this.configUUIDField.func_146180_a(((UuidTypeNode)this.activeNode.getField(WorldTypeNode.Fields.UUID)).getValue().toString());
        this.configUUIDField.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.configUUIDField.func_146196_d();
        this.configSeedField = new GuiTextField(206, this.field_146289_q, this.leftRow, 122, this.rowWidth, 18);
        this.configSeedField.func_146203_f(64);
        this.configSeedField.func_146180_a(((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.SEED)).getValue());
        this.configSeedField.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.configSeedField.func_146196_d();
        this.setCustomizeState();
    }

    private void setCustomizeState() {
        boolean enabled = false;
        for (GuiButton b : this.field_146292_n) {
            if (b.field_146127_k != 211) continue;
            String generator = ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.WORLD_GENERATOR)).getValue();
            for (WorldType w : WorldType.field_77139_a) {
                if (w == null || !w.func_77127_a().equals(generator)) continue;
                enabled = w.isCustomizable();
            }
            b.field_146124_l = enabled;
        }
    }

    private void launchCustomizeView() {
        String generator = ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.WORLD_GENERATOR)).getValue();
        for (WorldType w : WorldType.field_77139_a) {
            if (w == null || !w.func_77127_a().equals(generator) || !w.isCustomizable()) continue;
            class GuiFakeNewWorld
            extends GuiCreateWorld {
                GuiFakeNewWorld() {
                    super((GuiScreen)ConfigWorldDataGui.this);
                    this.field_146334_a = ((StringTypeNode)ConfigWorldDataGui.this.activeNode.getField(WorldTypeNode.Fields.CUSTOMIZATION_STRING)).getValue();
                }

                public void func_73866_w_() {
                    ((StringTypeNode)ConfigWorldDataGui.this.activeNode.getField(WorldTypeNode.Fields.CUSTOMIZATION_STRING)).setValue(this.field_146334_a);
                    this.field_146297_k.func_147108_a((GuiScreen)ConfigWorldDataGui.this);
                }
            }
            w.onCustomizeButton(this.field_146297_k, (GuiCreateWorld)new GuiFakeNewWorld());
        }
    }

    public void func_73876_c() {
        this.configNameTextField.func_146178_a();
        this.configDescriptionField.func_146178_a();
        if (this.newUUID != null && !this.configUUIDField.func_146206_l()) {
            this.newUUID = null;
            this.configUUIDField.func_146180_a(((UuidTypeNode)this.activeNode.getField(WorldTypeNode.Fields.UUID)).getValue().toString());
            this.configUUIDField.func_146193_g(0xFFFFFF);
        }
        this.configUUIDField.func_146178_a();
        this.configSeedField.func_146178_a();
        super.func_73876_c();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.configNameTextField.func_146192_a(mouseX, mouseY, mouseButton);
        this.configDescriptionField.func_146192_a(mouseX, mouseY, mouseButton);
        this.configUUIDField.func_146192_a(mouseX, mouseY, mouseButton);
        this.configSeedField.func_146192_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.configNameTextField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (this.configDescriptionField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (this.configUUIDField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (this.configSeedField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (keyCode == 1) {
            this.activeNode = new WorldTypeNode(Huffstruct.loadData(this.origData));
            this.parent.saveEdit(this.activeNode);
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 101: {
                this.activeNode = new WorldTypeNode(Huffstruct.loadData(this.origData));
                this.func_73866_w_();
                break;
            }
            case 102: {
                this.parent.saveEdit(this.activeNode);
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
                break;
            }
            case 205: {
                GuiConfigStateButton toggle = (GuiConfigStateButton)button;
                toggle.itterValue();
                if (toggle.getStateValue().equals(this.booleanValues[1])) {
                    ((BooleanTypeNode)this.activeNode.getField(WorldTypeNode.Fields.SHOW_IN_LIST)).setValue(true);
                    break;
                }
                ((BooleanTypeNode)this.activeNode.getField(WorldTypeNode.Fields.SHOW_IN_LIST)).setValue(false);
                break;
            }
            case 204: {
                GuiConfigStateButton toggle = (GuiConfigStateButton)button;
                toggle.itterValue();
                if (toggle.getStateValue().equals(this.booleanValues[1])) {
                    ((BooleanTypeNode)this.activeNode.getField(WorldTypeNode.Fields.LOCK_WORLD_TYPE)).setValue(true);
                    break;
                }
                ((BooleanTypeNode)this.activeNode.getField(WorldTypeNode.Fields.LOCK_WORLD_TYPE)).setValue(false);
                break;
            }
            case 209: {
                GuiConfigStateButton toggle = (GuiConfigStateButton)button;
                toggle.itterValue();
                if (!toggle.getStateValue().equals("NONE")) {
                    ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.CONFIGURATION_IMAGE)).setValue(toggle.getStateValue());
                    break;
                }
                ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.CONFIGURATION_IMAGE)).setValue("");
                break;
            }
            case 207: {
                GuiConfigStateButton toggle = (GuiConfigStateButton)button;
                toggle.itterValue();
                this.setQuadStateFromBtn((QuadStateTypeNode)this.activeNode.getField(WorldTypeNode.Fields.STRUCTURE_STATE), toggle.getStateValue());
                break;
            }
            case 208: {
                GuiConfigStateButton toggle = (GuiConfigStateButton)button;
                toggle.itterValue();
                this.setQuadStateFromBtn((QuadStateTypeNode)this.activeNode.getField(WorldTypeNode.Fields.BONUS_CHEST_STATE), toggle.getStateValue());
                break;
            }
            case 214: {
                GuiConfigStateButton toggle = (GuiConfigStateButton)button;
                toggle.itterValue();
                ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.PACK_MODE)).setValue(toggle.getStateValue());
                break;
            }
            case 210: {
                this.field_146297_k.func_147108_a((GuiScreen)new ConfigChooseWorldType(this, this.activeNode));
                break;
            }
            case 211: {
                this.launchCustomizeView();
                break;
            }
            case 213: {
                this.field_146297_k.func_147108_a((GuiScreen)new StringListGui(this, (StringListTypeNode)this.activeNode.getField(WorldTypeNode.Fields.DATA_PACKS), I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.list.datapacks", (Object[])new Object[0]), ConfigurationFile::safeFileName));
                break;
            }
            case 212: {
                this.field_146297_k.func_147108_a((GuiScreen)new StringListGui(this, (StringListTypeNode)this.activeNode.getField(WorldTypeNode.Fields.WORLD_LOAD_COMMANDS), I18n.func_135052_a((String)"defaultworldgenerator-port.config.gui.list.commands", (Object[])new Object[0]), null));
            }
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        switch (id) {
            case 201: {
                ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.CONFIGURATION_NAME)).setValue(value);
                break;
            }
            case 202: {
                ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.CONFIGURATION_DESC)).setValue(value);
                break;
            }
            case 203: {
                this.newUUID = value;
                try {
                    UUID inputed = UUID.fromString(this.newUUID);
                    ((UuidTypeNode)this.activeNode.getField(WorldTypeNode.Fields.UUID)).setValue(inputed);
                    this.configUUIDField.func_146193_g(0xFFFFFF);
                }
                catch (Exception e) {
                    this.configUUIDField.func_146193_g(0xFF8888);
                }
                break;
            }
            case 206: {
                ((StringTypeNode)this.activeNode.getField(WorldTypeNode.Fields.SEED)).setValue(value);
            }
        }
    }

    private void drawI18n(int x, int y, int color, String key) {
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)key, (Object[])new Object[0]), x, y, color);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        Gui.func_73734_a((int)0, (int)24, (int)this.field_146294_l, (int)this.field_146295_m, (int)0x55000000);
        this.func_73730_a(0, this.field_146294_l, 24, -16777216);
        if (this.packModes.length > 1) {
            this.func_73732_a(this.field_146289_q, this.title, this.leftRow + this.rowWidth / 2, 8, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 8, 0xFFFFFF);
        }
        this.drawI18n(this.leftRow, 26, 0xFFFFFF, "defaultworldgenerator-port.config.gui.world.name");
        this.configNameTextField.func_146194_f();
        this.drawI18n(this.leftRow, 58, 0xFFFFFF, "defaultworldgenerator-port.config.gui.world.desc");
        this.configDescriptionField.func_146194_f();
        this.drawI18n(this.rightRow, 26, 0xFFFFFF, "defaultworldgenerator-port.config.gui.world.uuid");
        this.configUUIDField.func_146194_f();
        this.drawI18n(this.leftRow, 111, 0xFFFFFF, "defaultworldgenerator-port.config.gui.world.seed");
        this.drawI18n(this.rightRow, 111, 0xFFFFFF, "defaultworldgenerator-port.config.gui.world.icon");
        this.configSeedField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }
}

