/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.ILootConditionConsumer;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.ILootGenerator;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomRanges;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.ValidationResults;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootPool {
    private final LootEntry[] field_186453_a;
    private final ILootCondition[] field_186454_b;
    private final Predicate<LootContext> field_216101_c;
    private final ILootFunction[] field_216102_d;
    private final BiFunction<ItemStack, LootContext, ItemStack> field_216103_e;
    private final IRandomRange field_186455_c;
    private final RandomValueRange field_186456_d;

    private LootPool(LootEntry[] lootEntryArray, ILootCondition[] iLootConditionArray, ILootFunction[] iLootFunctionArray, IRandomRange iRandomRange, RandomValueRange randomValueRange) {
        this.field_186453_a = lootEntryArray;
        this.field_186454_b = iLootConditionArray;
        this.field_216101_c = LootConditionManager.func_216305_a(iLootConditionArray);
        this.field_216102_d = iLootFunctionArray;
        this.field_216103_e = LootFunctionManager.func_216241_a(iLootFunctionArray);
        this.field_186455_c = iRandomRange;
        this.field_186456_d = randomValueRange;
    }

    private void func_216095_b(Consumer<ItemStack> consumer, LootContext lootContext) {
        Random random = lootContext.func_216032_b();
        ArrayList \u26032 = Lists.newArrayList();
        MutableInt \u26033 = new MutableInt();
        for (LootEntry lootEntry : this.field_186453_a) {
            lootEntry.expand(lootContext, iLootGenerator -> {
                int n = iLootGenerator.func_186361_a(lootContext.func_186491_f());
                if (n > 0) {
                    \u26032.add(iLootGenerator);
                    \u26033.add(n);
                }
            });
        }
        int n = \u26032.size();
        if (\u26033.intValue() == 0 || n == 0) {
            return;
        }
        if (n == 1) {
            ((ILootGenerator)\u26032.get(0)).func_216188_a(consumer, lootContext);
            return;
        }
        int n2 = random.nextInt(\u26033.intValue());
        for (ILootGenerator iLootGenerator2 : \u26032) {
            if ((n2 -= iLootGenerator2.func_186361_a(lootContext.func_186491_f())) >= 0) continue;
            iLootGenerator2.func_216188_a(consumer, lootContext);
            return;
        }
    }

    public void func_216091_a(Consumer<ItemStack> consumer, LootContext lootContext) {
        if (!this.field_216101_c.test(lootContext)) {
            return;
        }
        Consumer<ItemStack> consumer2 = ILootFunction.func_215858_a(this.field_216103_e, consumer, lootContext);
        Random \u26032 = lootContext.func_216032_b();
        int \u26033 = this.field_186455_c.func_186511_a(\u26032) + MathHelper.func_76141_d(this.field_186456_d.func_186507_b(\u26032) * lootContext.func_186491_f());
        for (int i = 0; i < \u26033; ++i) {
            this.func_216095_b(consumer2, lootContext);
        }
    }

    public void func_216099_a(ValidationResults validationResults, Function<ResourceLocation, LootTable> function, Set<ResourceLocation> set, LootParameterSet lootParameterSet) {
        int n;
        for (n = 0; n < this.field_186454_b.length; ++n) {
            this.field_186454_b[n].func_215856_a(validationResults.func_216108_b(".condition[" + n + "]"), function, set, lootParameterSet);
        }
        for (n = 0; n < this.field_216102_d.length; ++n) {
            this.field_216102_d[n].func_215856_a(validationResults.func_216108_b(".functions[" + n + "]"), function, set, lootParameterSet);
        }
        for (n = 0; n < this.field_186453_a.length; ++n) {
            this.field_186453_a[n].func_216142_a(validationResults.func_216108_b(".entries[" + n + "]"), function, set, lootParameterSet);
        }
    }

    public static Builder func_216096_a() {
        return new Builder();
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "loot pool");
            LootEntry[] \u26032 = JSONUtils.func_188174_a(jsonObject, "entries", jsonDeserializationContext, LootEntry[].class);
            ILootCondition[] \u26033 = JSONUtils.func_188177_a(jsonObject, "conditions", new ILootCondition[0], jsonDeserializationContext, ILootCondition[].class);
            ILootFunction[] \u26034 = JSONUtils.func_188177_a(jsonObject, "functions", new ILootFunction[0], jsonDeserializationContext, ILootFunction[].class);
            IRandomRange \u26035 = RandomRanges.func_216130_a(jsonObject.get("rolls"), jsonDeserializationContext);
            RandomValueRange \u26036 = JSONUtils.func_188177_a(jsonObject, "bonus_rolls", new RandomValueRange(0.0f, 0.0f), jsonDeserializationContext, RandomValueRange.class);
            return new LootPool(\u26032, \u26033, \u26034, \u26035, \u26036);
        }

        public JsonElement serialize(LootPool lootPool, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("rolls", RandomRanges.func_216131_a(lootPool.field_186455_c, jsonSerializationContext));
            jsonObject.add("entries", jsonSerializationContext.serialize((Object)lootPool.field_186453_a));
            if (lootPool.field_186456_d.func_186509_a() != 0.0f && lootPool.field_186456_d.func_186512_b() != 0.0f) {
                jsonObject.add("bonus_rolls", jsonSerializationContext.serialize((Object)lootPool.field_186456_d));
            }
            if (!ArrayUtils.isEmpty((Object[])lootPool.field_186454_b)) {
                jsonObject.add("conditions", jsonSerializationContext.serialize((Object)lootPool.field_186454_b));
            }
            if (!ArrayUtils.isEmpty((Object[])lootPool.field_216102_d)) {
                jsonObject.add("functions", jsonSerializationContext.serialize((Object)lootPool.field_216102_d));
            }
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootPool)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    public static class Builder
    implements ILootFunctionConsumer<Builder>,
    ILootConditionConsumer<Builder> {
        private final List<LootEntry> field_216047_a = Lists.newArrayList();
        private final List<ILootCondition> field_216048_b = Lists.newArrayList();
        private final List<ILootFunction> field_216049_c = Lists.newArrayList();
        private IRandomRange field_216050_d = new RandomValueRange(1.0f);
        private RandomValueRange field_216051_e = new RandomValueRange(0.0f, 0.0f);

        public Builder func_216046_a(IRandomRange iRandomRange) {
            this.field_216050_d = iRandomRange;
            return this;
        }

        @Override
        public Builder func_212862_c_() {
            return this;
        }

        public Builder func_216045_a(LootEntry.Builder<?> builder) {
            this.field_216047_a.add(builder.func_216081_b());
            return this;
        }

        @Override
        public Builder func_212840_b_(ILootCondition.IBuilder iBuilder) {
            this.field_216048_b.add(iBuilder.build());
            return this;
        }

        @Override
        public Builder func_212841_b_(ILootFunction.IBuilder iBuilder) {
            this.field_216049_c.add(iBuilder.func_216052_b());
            return this;
        }

        public LootPool func_216044_b() {
            if (this.field_216050_d == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new LootPool(this.field_216047_a.toArray(new LootEntry[0]), this.field_216048_b.toArray(new ILootCondition[0]), this.field_216049_c.toArray(new ILootFunction[0]), this.field_216050_d, this.field_216051_e);
        }

        @Override
        public /* synthetic */ Object func_212862_c_() {
            return this.func_212862_c_();
        }

        @Override
        public /* synthetic */ Object func_212841_b_(ILootFunction.IBuilder iBuilder) {
            return this.func_212841_b_(iBuilder);
        }

        @Override
        public /* synthetic */ Object func_212840_b_(ILootCondition.IBuilder iBuilder) {
            return this.func_212840_b_(iBuilder);
        }
    }
}

