/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.PillagerOutpostConfig;
import net.minecraft.world.gen.feature.structure.PillagerOutpostPieces;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PillagerOutpostStructure
extends ScatteredStructure<PillagerOutpostConfig> {
    private static final List<Biome.SpawnListEntry> field_214558_a = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_220350_aJ, 1, 1, 1)});

    public PillagerOutpostStructure(Function<Dynamic<?>, ? extends PillagerOutpostConfig> function) {
        super(function);
    }

    @Override
    public String func_143025_a() {
        return "Pillager_Outpost";
    }

    @Override
    public int func_202367_b() {
        return 3;
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_214558_a;
    }

    @Override
    public boolean func_202372_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2) {
        ChunkPos chunkPos = this.func_211744_a(chunkGenerator, random, n, n2, 0, 0);
        if (n == chunkPos.field_77276_a && n2 == chunkPos.field_77275_b) {
            int n3 = n >> 4;
            \u2603 = n2 >> 4;
            random.setSeed((long)(n3 ^ \u2603 << 4) ^ chunkGenerator.func_202089_c());
            random.nextInt();
            if (random.nextInt(5) != 0) {
                return false;
            }
            Biome \u26032 = chunkGenerator.func_202090_b().func_222364_a(new BlockPos((n << 4) + 9, 0, (n2 << 4) + 9));
            if (chunkGenerator.func_202094_a(\u26032, Feature.field_214536_b)) {
                for (\u2603 = n - 10; \u2603 <= n + 10; ++\u2603) {
                    for (\u2603 = n2 - 10; \u2603 <= n2 + 10; ++\u2603) {
                        if (!Feature.field_214550_p.func_202372_a(chunkGenerator, random, \u2603, \u2603)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    protected int func_202382_c() {
        return 165745296;
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structure, int n, int n2, Biome biome, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, biome, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome) {
            BlockPos blockPos = new BlockPos(n * 16, 90, n2 * 16);
            PillagerOutpostPieces.func_215139_a(chunkGenerator, templateManager, blockPos, this.field_75075_a, this.field_214631_d);
            this.func_202500_a();
        }
    }
}

