/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.OceanMonumentPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OceanMonumentStructure
extends Structure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> field_175803_h = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200761_A, 1, 2, 4)});

    public OceanMonumentStructure(Function<Dynamic<?>, ? extends NoFeatureConfig> function) {
        super(function);
    }

    @Override
    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2, int n3, int n4) {
        \u2603 = ((GenerationSettings)chunkGenerator.func_201496_a_()).func_202174_b();
        \u2603 = ((GenerationSettings)chunkGenerator.func_201496_a_()).func_202171_c();
        \u2603 = n + \u2603 * n3;
        \u2603 = n2 + \u2603 * n4;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 < 0 ? \u2603 - \u2603 + 1 : \u2603;
        \u2603 = \u2603 / \u2603;
        \u2603 = \u2603 / \u2603;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), \u2603, \u2603, 10387313);
        \u2603 *= \u2603;
        \u2603 *= \u2603;
        return new ChunkPos(\u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2, \u2603 += (random.nextInt(\u2603 - \u2603) + random.nextInt(\u2603 - \u2603)) / 2);
    }

    @Override
    public boolean func_202372_a(ChunkGenerator<?> chunkGenerator2, Random random, int n, int n2) {
        ChunkPos chunkPos = this.func_211744_a(chunkGenerator2, random, n, n2, 0, 0);
        if (n == chunkPos.field_77276_a && n2 == chunkPos.field_77275_b) {
            ChunkGenerator<?> chunkGenerator2;
            Set<Biome> set = chunkGenerator2.func_202090_b().func_201538_a(n * 16 + 9, n2 * 16 + 9, 16);
            for (Biome biome : set) {
                if (chunkGenerator2.func_202094_a(biome, Feature.field_202336_n)) continue;
                return false;
            }
            Set<Biome> \u26032 = chunkGenerator2.func_202090_b().func_201538_a(n * 16 + 9, n2 * 16 + 9, 29);
            for (Biome biome : \u26032) {
                if (biome.func_201856_r() == Biome.Category.OCEAN || biome.func_201856_r() == Biome.Category.RIVER) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    @Override
    public String func_143025_a() {
        return "Monument";
    }

    @Override
    public int func_202367_b() {
        return 8;
    }

    @Override
    public List<Biome.SpawnListEntry> func_202279_e() {
        return field_175803_h;
    }

    public static class Start
    extends StructureStart {
        private boolean field_175790_d;

        public Start(Structure<?> structure, int n, int n2, Biome biome, MutableBoundingBox mutableBoundingBox, int n3, long l) {
            super(structure, n, n2, biome, mutableBoundingBox, n3, l);
        }

        @Override
        public void func_214625_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, int n, int n2, Biome biome) {
            this.func_214633_b(n, n2);
        }

        private void func_214633_b(int n, int n2) {
            \u2603 = n * 16 - 29;
            \u2603 = n2 * 16 - 29;
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(this.field_214631_d);
            this.field_75075_a.add(new OceanMonumentPieces.MonumentBuilding(this.field_214631_d, \u2603, \u2603, direction));
            this.func_202500_a();
            this.field_175790_d = true;
        }

        @Override
        public void func_75068_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            if (!this.field_175790_d) {
                this.field_75075_a.clear();
                this.func_214633_b(this.func_143019_e(), this.func_143018_f());
            }
            super.func_75068_a(iWorld, random, mutableBoundingBox, chunkPos);
        }
    }
}

