/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagCollection<T> {
    private static final Logger field_199918_a = LogManager.getLogger();
    private static final Gson field_199919_b = new Gson();
    private static final int field_199920_c = ".json".length();
    private Map<ResourceLocation, Tag<T>> field_199921_d = ImmutableMap.of();
    private final Function<ResourceLocation, Optional<T>> field_200040_e;
    private final String field_199923_f;
    private final boolean field_200041_g;
    private final String field_200157_i;

    public TagCollection(Function<ResourceLocation, Optional<T>> function, String string, boolean bl, String string2) {
        this.field_200040_e = function;
        this.field_199923_f = string;
        this.field_200041_g = bl;
        this.field_200157_i = string2;
    }

    @Nullable
    public Tag<T> func_199910_a(ResourceLocation resourceLocation) {
        return this.field_199921_d.get(resourceLocation);
    }

    public Tag<T> func_199915_b(ResourceLocation resourceLocation) {
        Tag<T> tag = this.field_199921_d.get(resourceLocation);
        if (tag == null) {
            return new Tag(resourceLocation);
        }
        return tag;
    }

    public Collection<ResourceLocation> func_199908_a() {
        return this.field_199921_d.keySet();
    }

    public CompletableFuture<Map<ResourceLocation, Tag.Builder<T>>> func_219781_a(IResourceManager iResourceManager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap hashMap = Maps.newHashMap();
            for (ResourceLocation resourceLocation2 : iResourceManager.func_199003_a(this.field_199923_f, string -> string.endsWith(".json"))) {
                String string2 = resourceLocation2.func_110623_a();
                ResourceLocation \u26032 = new ResourceLocation(resourceLocation2.func_110624_b(), string2.substring(this.field_199923_f.length() + 1, string2.length() - field_199920_c));
                try {
                    for (IResource iResource : iResourceManager.func_199004_b(resourceLocation2)) {
                        try {
                            InputStream inputStream = iResource.func_199027_b();
                            Throwable throwable = null;
                            try {
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                                Throwable throwable2 = null;
                                try {
                                    JsonObject jsonObject = JSONUtils.func_193839_a(field_199919_b, bufferedReader, JsonObject.class);
                                    if (jsonObject == null) {
                                        field_199918_a.error("Couldn't load {} tag list {} from {} in data pack {} as it's empty or null", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation2, (Object)iResource.func_199026_d());
                                        continue;
                                    }
                                    hashMap.computeIfAbsent(\u26032, resourceLocation -> Util.func_200696_a(Tag.Builder.func_200047_a(), builder -> builder.func_200045_a(this.field_200041_g))).func_219783_a(this.field_200040_e, jsonObject);
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (bufferedReader == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            ((Reader)bufferedReader).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    ((Reader)bufferedReader).close();
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                inputStream.close();
                            }
                        }
                        catch (IOException | RuntimeException exception) {
                            field_199918_a.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation2, (Object)iResource.func_199026_d(), (Object)exception);
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)iResource);
                        }
                    }
                }
                catch (IOException iOException) {
                    field_199918_a.error("Couldn't read {} tag list {} from {}", (Object)this.field_200157_i, (Object)\u26032, (Object)resourceLocation2, (Object)iOException);
                }
            }
            return hashMap;
        }, executor);
    }

    public void func_219779_a(Map<ResourceLocation, Tag.Builder<T>> map) {
        HashMap hashMap = Maps.newHashMap();
        while (!map.isEmpty()) {
            boolean \u26034 = false;
            Iterator<Map.Entry<ResourceLocation, Tag.Builder<T>>> \u26032 = map.entrySet().iterator();
            while (\u26032.hasNext()) {
                Map.Entry<ResourceLocation, Tag.Builder<T>> entry = \u26032.next();
                Tag.Builder \u26033 = entry.getValue();
                if (!\u26033.func_200160_a(hashMap::get)) continue;
                \u26034 = true;
                ResourceLocation \u26035 = entry.getKey();
                hashMap.put(\u26035, \u26033.func_200051_a(\u26035));
                \u26032.remove();
            }
            if (\u26034) continue;
            map.forEach((resourceLocation, builder) -> field_199918_a.error("Couldn't load {} tag {} as it either references another tag that doesn't exist, or ultimately references itself", (Object)this.field_200157_i, resourceLocation));
            break;
        }
        map.forEach((resourceLocation, builder) -> hashMap.put(resourceLocation, builder.func_200051_a((ResourceLocation)resourceLocation)));
        this.func_223507_b(hashMap);
    }

    protected void func_223507_b(Map<ResourceLocation, Tag<T>> map) {
        this.field_199921_d = ImmutableMap.copyOf(map);
    }

    public Map<ResourceLocation, Tag<T>> func_200039_c() {
        return this.field_199921_d;
    }
}

