/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;

public class EnterBlockTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation field_192196_a = new ResourceLocation("enter_block");
    private final Map<PlayerAdvancements, Listeners> field_192197_b = Maps.newHashMap();

    @Override
    public ResourceLocation func_192163_a() {
        return field_192196_a;
    }

    @Override
    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_192197_b.get(playerAdvancements);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancements);
            this.field_192197_b.put(playerAdvancements, listeners);
        }
        listeners.func_192472_a(listener);
    }

    @Override
    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.field_192197_b.get(playerAdvancements);
        if (listeners != null) {
            listeners.func_192469_b(listener);
            if (listeners.func_192470_a()) {
                this.field_192197_b.remove(playerAdvancements);
            }
        }
    }

    @Override
    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.field_192197_b.remove(playerAdvancements);
    }

    @Override
    public Instance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
        Object object;
        Block \u26032 = null;
        if (jsonObject.has("block")) {
            object = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "block"));
            \u26032 = (Block)Registry.field_212618_g.func_218349_b((ResourceLocation)object).orElseThrow(() -> EnterBlockTrigger.func_215104_a((ResourceLocation)object));
        }
        object = null;
        if (jsonObject.has("state")) {
            if (\u26032 == null) {
                throw new JsonSyntaxException("Can't define block state without a specific block type");
            }
            StateContainer<Block, BlockState> \u26033 = \u26032.func_176194_O();
            for (Map.Entry entry2 : JSONUtils.func_152754_s(jsonObject, "state").entrySet()) {
                Map.Entry entry2;
                IProperty<?> iProperty = \u26033.func_185920_a((String)entry2.getKey());
                if (iProperty == null) {
                    throw new JsonSyntaxException("Unknown block state property '" + (String)entry2.getKey() + "' for block '" + Registry.field_212618_g.func_177774_c(\u26032) + "'");
                }
                String \u26034 = JSONUtils.func_151206_a((JsonElement)entry2.getValue(), (String)entry2.getKey());
                Optional<?> \u26035 = iProperty.func_185929_b(\u26034);
                if (\u26035.isPresent()) {
                    if (object == null) {
                        object = Maps.newHashMap();
                    }
                    object.put(iProperty, \u26035.get());
                    continue;
                }
                throw new JsonSyntaxException("Invalid block state value '" + \u26034 + "' for property '" + (String)entry2.getKey() + "' on block '" + Registry.field_212618_g.func_177774_c(\u26032) + "'");
            }
        }
        return new Instance(\u26032, (Map<IProperty<?>, Object>)object);
    }

    public void func_192193_a(ServerPlayerEntity serverPlayerEntity, BlockState blockState) {
        Listeners listeners = this.field_192197_b.get(serverPlayerEntity.func_192039_O());
        if (listeners != null) {
            listeners.func_192471_a(blockState);
        }
    }

    @Override
    public /* synthetic */ ICriterionInstance func_192166_a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
        return this.func_192166_a(jsonObject, jsonDeserializationContext);
    }

    private static /* synthetic */ JsonSyntaxException func_215104_a(ResourceLocation resourceLocation) {
        return new JsonSyntaxException("Unknown block type '" + resourceLocation + "'");
    }

    static class Listeners {
        private final PlayerAdvancements field_192473_a;
        private final Set<ICriterionTrigger.Listener<Instance>> field_192474_b = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.field_192473_a = playerAdvancements;
        }

        public boolean func_192470_a() {
            return this.field_192474_b.isEmpty();
        }

        public void func_192472_a(ICriterionTrigger.Listener<Instance> listener) {
            this.field_192474_b.add(listener);
        }

        public void func_192469_b(ICriterionTrigger.Listener<Instance> listener) {
            this.field_192474_b.remove(listener);
        }

        public void func_192471_a(BlockState blockState) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.field_192474_b) {
                if (!listener.func_192158_a().func_192260_a(blockState)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener<Instance> listener : list) {
                    listener.func_192159_a(this.field_192473_a);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        private final Block field_192261_a;
        private final Map<IProperty<?>, Object> field_192262_b;

        public Instance(@Nullable Block block, @Nullable Map<IProperty<?>, Object> map) {
            super(field_192196_a);
            this.field_192261_a = block;
            this.field_192262_b = map;
        }

        public static Instance func_203920_a(Block block) {
            return new Instance(block, null);
        }

        @Override
        public JsonElement func_200288_b() {
            JsonObject jsonObject = new JsonObject();
            if (this.field_192261_a != null) {
                jsonObject.addProperty("block", Registry.field_212618_g.func_177774_c(this.field_192261_a).toString());
                if (this.field_192262_b != null && !this.field_192262_b.isEmpty()) {
                    \u2603 = new JsonObject();
                    for (Map.Entry<IProperty<?>, Object> entry : this.field_192262_b.entrySet()) {
                        \u2603.addProperty(entry.getKey().func_177701_a(), Util.func_200269_a(entry.getKey(), entry.getValue()));
                    }
                    jsonObject.add("state", (JsonElement)\u2603);
                }
            }
            return jsonObject;
        }

        public boolean func_192260_a(BlockState blockState) {
            if (this.field_192261_a != null && blockState.func_177230_c() != this.field_192261_a) {
                return false;
            }
            if (this.field_192262_b != null) {
                for (Map.Entry<IProperty<?>, Object> entry : this.field_192262_b.entrySet()) {
                    if (blockState.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

