/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderingRegistry {
    private static final RenderingRegistry INSTANCE = new RenderingRegistry();
    private final Map<Class<? extends Entity>, IRenderFactory<? extends Entity>> entityRenderers = new ConcurrentHashMap<Class<? extends Entity>, IRenderFactory<? extends Entity>>();

    public static <T extends Entity> void registerEntityRenderingHandler(Class<T> entityClass, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.INSTANCE.entityRenderers.put(entityClass, renderFactory);
    }

    public static void loadEntityRenderers(EntityRendererManager manager) {
        RenderingRegistry.INSTANCE.entityRenderers.forEach((key, value) -> RenderingRegistry.register(manager, key, value));
    }

    private static <T extends Entity> void register(EntityRendererManager manager, Class<T> entityClass, IRenderFactory<?> renderFactory) {
        manager.func_217782_a(entityClass, renderFactory.createRenderFor(manager));
    }
}

