/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Random;
import java.util.function.LongFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddBambooForestLayer;
import net.minecraft.world.gen.layer.BiomeLayer;
import net.minecraft.world.gen.layer.EdgeBiomeLayer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IForgeWorldType {
    default public WorldType getWorldType() {
        return (WorldType)this;
    }

    default public void onGUICreateWorldPress() {
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void onCustomizeButton(Minecraft mc, CreateWorldScreen gui) {
        if (this == WorldType.field_77138_c) {
            mc.func_147108_a((Screen)new CreateFlatWorldScreen(gui, gui.field_146334_a));
        } else if (this == WorldType.field_205394_h) {
            mc.func_147108_a((Screen)new CreateBuffetWorldScreen(gui, gui.field_146334_a));
        }
    }

    default public boolean handleSlimeSpawnReduction(Random random, IWorld world) {
        return this == WorldType.field_77138_c ? random.nextInt(4) != 1 : false;
    }

    default public double getHorizon(World world) {
        return this == WorldType.field_77138_c ? 0.0 : 63.0;
    }

    default public double voidFadeMagnitude() {
        return this == WorldType.field_77138_c ? 1.0 : 0.03125;
    }

    default public float getCloudHeight() {
        return 128.0f;
    }

    default public ChunkGenerator<?> createChunkGenerator(World world) {
        return world.field_73011_w.func_186060_c();
    }

    default public <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> getBiomeLayer(IAreaFactory<T> parentLayer, OverworldGenSettings chunkSettings, LongFunction<C> contextFactory) {
        parentLayer = new BiomeLayer(this.getWorldType(), chunkSettings).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(200L), parentLayer);
        parentLayer = AddBambooForestLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), parentLayer);
        parentLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)parentLayer, (int)2, contextFactory);
        parentLayer = EdgeBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), parentLayer);
        return parentLayer;
    }
}

