/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelFontRenderer;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

final class FancyMissingModel
implements IUnbakedModel {
    private static final ResourceLocation font = new ResourceLocation("minecraft", "textures/font/ascii.png");
    private static final ResourceLocation font2 = new ResourceLocation("minecraft", "font/ascii");
    private static final TRSRTransformation smallTransformation = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
    private static final LoadingCache<VertexFormat, SimpleModelFontRenderer> fontCache = CacheBuilder.newBuilder().maximumSize(3L).build((CacheLoader)new CacheLoader<VertexFormat, SimpleModelFontRenderer>(){

        public SimpleModelFontRenderer load(VertexFormat format) throws Exception {
            Matrix4f m = new Matrix4f();
            m.m20 = 0.0078125f;
            m.m01 = m.m12 = -m.m20;
            m.m33 = 1.0f;
            m.setTranslation(new Vector3f(1.0f, 1.0039062f, 0.0f));
            return new SimpleModelFontRenderer(Minecraft.func_71410_x().field_71474_y, font, Minecraft.func_71410_x().func_110434_K(), false, m, format){};
        }
    });
    private final IUnbakedModel missingModel;
    private final String message;

    public FancyMissingModel(IUnbakedModel missingModel, String message) {
        this.missingModel = missingModel;
        this.message = message;
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        return ImmutableList.of((Object)font2);
    }

    public Collection<ResourceLocation> func_187965_e() {
        return Collections.emptyList();
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        IBakedModel bigMissing = this.missingModel.bake(bakery, spriteGetter, sprite, format);
        ModelStateComposition smallState = new ModelStateComposition(sprite.getState(), smallTransformation);
        IBakedModel smallMissing = this.missingModel.bake(bakery, spriteGetter, (ISprite)smallState, format);
        return new BakedModel(bigMissing, smallMissing, (SimpleModelFontRenderer)((Object)fontCache.getUnchecked((Object)format)), this.message, spriteGetter.apply(font2));
    }

    static final class BakedModel
    implements IBakedModel {
        private final SimpleModelFontRenderer fontRenderer;
        private final String message;
        private final TextureAtlasSprite fontTexture;
        private final IBakedModel missingModel;
        private final IBakedModel otherModel;
        private final boolean big;
        private ImmutableList<BakedQuad> quads;

        public BakedModel(IBakedModel bigMissing, IBakedModel smallMissing, SimpleModelFontRenderer fontRenderer, String message, TextureAtlasSprite fontTexture) {
            this.missingModel = bigMissing;
            this.otherModel = new BakedModel(smallMissing, fontRenderer, message, fontTexture, this);
            this.big = true;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public BakedModel(IBakedModel smallMissing, SimpleModelFontRenderer fontRenderer, String message, TextureAtlasSprite fontTexture, BakedModel big) {
            this.missingModel = smallMissing;
            this.otherModel = big;
            this.big = false;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                if (this.quads == null) {
                    int y;
                    this.fontRenderer.setSprite(this.fontTexture);
                    this.fontRenderer.setFillBlanks(true);
                    String[] lines = this.message.split("\\r?\\n");
                    ArrayList splitLines = Lists.newArrayList();
                    for (y = 0; y < lines.length; ++y) {
                        splitLines.addAll(this.fontRenderer.func_78271_c(lines[y], 128));
                    }
                    for (y = 0; y < splitLines.size(); ++y) {
                        String string = (String)splitLines.get(y);
                        float f = (float)y - (float)splitLines.size() / 2.0f;
                        ((Object)((Object)this.fontRenderer)).getClass();
                        this.fontRenderer.func_211126_b(string, 0.0f, f * 9.0f + 64.0f, -16711681);
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll((Iterable)this.missingModel.func_200117_a(state, side, rand));
                    builder.addAll(this.fontRenderer.build());
                    this.quads = builder.build();
                }
                return this.quads;
            }
            return this.missingModel.func_200117_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.fontTexture;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            TRSRTransformation transform = TRSRTransformation.identity();
            boolean big = true;
            switch (cameraTransformType) {
                case THIRD_PERSON_LEFT_HAND: {
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    break;
                }
                case FIRST_PERSON_LEFT_HAND: {
                    transform = new TRSRTransformation(new Vector3f(-0.62f, 0.5f, -0.5f), new Quat4f(1.0f, -1.0f, -1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    transform = new TRSRTransformation(new Vector3f(-0.5f, 0.5f, -0.5f), new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case HEAD: {
                    break;
                }
                case GUI: {
                    if (((Boolean)ForgeConfig.CLIENT.zoomInMissingModelTextInGui.get()).booleanValue()) {
                        transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), new Vector3f(4.0f, 4.0f, 4.0f), null);
                        big = false;
                        break;
                    }
                    transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = true;
                    break;
                }
                case FIXED: {
                    transform = new TRSRTransformation(null, new Quat4f(-1.0f, -1.0f, 1.0f, 1.0f), null, null);
                    break;
                }
            }
            if (big != this.big) {
                return Pair.of((Object)this.otherModel, (Object)transform.getMatrixVec());
            }
            return Pair.of((Object)this, (Object)transform.getMatrixVec());
        }
    }
}

