/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.settings.CloudOption;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class CloudRenderer
implements ISelectiveResourceReloadListener {
    private static final float PX_SIZE = 0.00390625f;
    private static final VertexFormat FORMAT = DefaultVertexFormats.field_181709_i;
    private static final int TOP_SECTIONS = 12;
    private static final int HEIGHT = 4;
    private static final float INSET = 0.001f;
    private static final float ALPHA = 0.8f;
    private static final boolean WIREFRAME = false;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final ResourceLocation texture = new ResourceLocation("textures/environment/clouds.png");
    private int displayList = -1;
    private VertexBuffer vbo;
    private CloudOption cloudMode = CloudOption.OFF;
    private int renderDistance = -1;
    private DynamicTexture COLOR_TEX = null;
    private int texW;
    private int texH;
    private static CloudRenderer cloudRenderer;

    public CloudRenderer() {
        ((IReloadableResourceManager)this.mc.func_195551_G()).func_219534_a((IFutureReloadListener)this);
    }

    private int getScale() {
        return this.cloudMode == CloudOption.FANCY ? 12 : 8;
    }

    private float ceilToScale(float value) {
        float scale = this.getScale();
        return (float)MathHelper.func_76123_f((float)(value / scale)) * scale;
    }

    private void vertices(BufferBuilder buffer) {
        float sectX0;
        boolean fancy = this.cloudMode == CloudOption.FANCY;
        float scale = this.getScale();
        float CULL_DIST = 2.0f * scale;
        float bCol = fancy ? 0.7f : 1.0f;
        float sectEnd = this.ceilToScale(this.renderDistance * 2 * 16);
        float sectStart = -sectEnd;
        float sectStep = this.ceilToScale(sectEnd * 2.0f / 12.0f);
        float sectPx = 0.00390625f / scale;
        buffer.func_181668_a(7, FORMAT);
        float sectX1 = sectX0 = sectStart;
        while (sectX1 < sectEnd) {
            float sectZ0;
            if ((sectX1 += sectStep) > sectEnd) {
                sectX1 = sectEnd;
            }
            float sectZ1 = sectZ0 = sectStart;
            while (sectZ1 < sectEnd) {
                if ((sectZ1 += sectStep) > sectEnd) {
                    sectZ1 = sectEnd;
                }
                float u0 = sectX0 * sectPx;
                float u1 = sectX1 * sectPx;
                float v0 = sectZ0 * sectPx;
                float v1 = sectZ1 * sectPx;
                buffer.func_181662_b((double)sectX0, 0.0, (double)sectZ0).func_187315_a((double)u0, (double)v0).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                buffer.func_181662_b((double)sectX1, 0.0, (double)sectZ0).func_187315_a((double)u1, (double)v0).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                buffer.func_181662_b((double)sectX1, 0.0, (double)sectZ1).func_187315_a((double)u1, (double)v1).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                buffer.func_181662_b((double)sectX0, 0.0, (double)sectZ1).func_187315_a((double)u0, (double)v1).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                if (fancy) {
                    float sliceCoord1;
                    float sliceCoord0;
                    buffer.func_181662_b((double)sectX0, 4.0, (double)sectZ0).func_187315_a((double)u0, (double)v0).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    buffer.func_181662_b((double)sectX0, 4.0, (double)sectZ1).func_187315_a((double)u0, (double)v1).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    buffer.func_181662_b((double)sectX1, 4.0, (double)sectZ1).func_187315_a((double)u1, (double)v1).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    buffer.func_181662_b((double)sectX1, 4.0, (double)sectZ0).func_187315_a((double)u1, (double)v0).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    float slice = sectX0;
                    while (slice < sectX1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -CULL_DIST) {
                            buffer.func_181662_b((double)(slice += 0.001f), 0.0, (double)sectZ1).func_187315_a((double)sliceCoord0, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)slice, 4.0, (double)sectZ1).func_187315_a((double)sliceCoord1, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)slice, 4.0, (double)sectZ0).func_187315_a((double)sliceCoord1, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)slice, 0.0, (double)sectZ0).func_187315_a((double)sliceCoord0, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= CULL_DIST)) continue;
                        buffer.func_181662_b((double)(slice -= 0.001f), 0.0, (double)sectZ0).func_187315_a((double)sliceCoord0, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)slice, 4.0, (double)sectZ0).func_187315_a((double)sliceCoord1, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)slice, 4.0, (double)sectZ1).func_187315_a((double)sliceCoord1, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)slice, 0.0, (double)sectZ1).func_187315_a((double)sliceCoord0, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        slice += 0.001f;
                    }
                    slice = sectZ0;
                    while (slice < sectZ1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -CULL_DIST) {
                            buffer.func_181662_b((double)sectX0, 0.0, (double)(slice += 0.001f)).func_187315_a((double)u0, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)sectX0, 4.0, (double)slice).func_187315_a((double)u0, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)sectX1, 4.0, (double)slice).func_187315_a((double)u1, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)sectX1, 0.0, (double)slice).func_187315_a((double)u1, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= CULL_DIST)) continue;
                        buffer.func_181662_b((double)sectX1, 0.0, (double)(slice -= 0.001f)).func_187315_a((double)u1, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)sectX1, 4.0, (double)slice).func_187315_a((double)u1, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)sectX0, 4.0, (double)slice).func_187315_a((double)u0, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)sectX0, 0.0, (double)slice).func_187315_a((double)u0, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        slice += 0.001f;
                    }
                }
                sectZ0 = sectZ1;
            }
            sectX0 = sectX1;
        }
    }

    private void dispose() {
        if (this.vbo != null) {
            this.vbo.func_177362_c();
            this.vbo = null;
        }
        if (this.displayList >= 0) {
            GLAllocation.func_74523_b((int)this.displayList);
            this.displayList = -1;
        }
    }

    private void build() {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        if (GLX.useVbo()) {
            this.vbo = new VertexBuffer(FORMAT);
        } else {
            this.displayList = GLAllocation.func_74526_a((int)1);
            GlStateManager.newList((int)this.displayList, (int)4864);
        }
        this.vertices(buffer);
        if (GLX.useVbo()) {
            buffer.func_178977_d();
            buffer.func_178965_a();
            this.vbo.func_181722_a(buffer.func_178966_f());
        } else {
            tess.func_78381_a();
            GlStateManager.endList();
        }
    }

    private int fullCoord(double coord, int scale) {
        return (int)coord / scale - (coord < 0.0 ? 1 : 0);
    }

    private boolean isBuilt() {
        return GLX.useVbo() ? this.vbo != null : this.displayList >= 0;
    }

    public void checkSettings() {
        boolean newEnabled;
        boolean bl = newEnabled = (Boolean)ForgeConfig.CLIENT.forgeCloudsEnabled.get() != false && this.mc.field_71474_y.func_216842_e() != CloudOption.OFF && this.mc.field_71441_e != null && this.mc.field_71441_e.field_73011_w.func_76569_d();
        if (this.isBuilt() && (!newEnabled || this.mc.field_71474_y.func_216842_e() != this.cloudMode || this.mc.field_71474_y.field_151451_c != this.renderDistance)) {
            this.dispose();
        }
        this.cloudMode = this.mc.field_71474_y.func_216842_e();
        this.renderDistance = this.mc.field_71474_y.field_151451_c;
        if (newEnabled && !this.isBuilt()) {
            this.build();
        }
    }

    public boolean render(int cloudTicks, float partialTicks) {
        int i;
        if (!this.isBuilt()) {
            return false;
        }
        Entity entity = this.mc.func_175606_aa();
        double totalOffset = (float)cloudTicks + partialTicks;
        double x = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + totalOffset * 0.03;
        double y = (double)this.mc.field_71441_e.field_73011_w.func_76571_f() - (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) + 0.33;
        double z = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        int scale = this.getScale();
        if (this.cloudMode == CloudOption.FANCY) {
            z += 0.33 * (double)scale;
        }
        int offU = this.fullCoord(x, scale);
        int offV = this.fullCoord(z, scale);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)((double)(offU * scale) - x), (double)y, (double)((double)(offV * scale) - z));
        GlStateManager.matrixMode((int)5890);
        GlStateManager.translatef((float)((float)(offU %= this.texW) * 0.00390625f), (float)((float)(offV %= this.texH) * 0.00390625f), (float)0.0f);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.disableCull();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Vec3d color = this.mc.field_71441_e.func_72824_f(partialTicks);
        float r = (float)color.field_72450_a;
        float g = (float)color.field_72448_b;
        float b = (float)color.field_72449_c;
        if (this.COLOR_TEX == null) {
            this.COLOR_TEX = new DynamicTexture(1, 1, false);
        }
        this.COLOR_TEX.func_195414_e().func_195700_a(0, 0, 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f));
        this.COLOR_TEX.func_110564_a();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.bindTexture((int)this.COLOR_TEX.func_110552_b());
        GlStateManager.enableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
        this.mc.field_71446_o.func_110577_a(this.texture);
        ByteBuffer buffer = Tessellator.func_178181_a().func_178180_c().func_178966_f();
        if (GLX.useVbo()) {
            this.vbo.func_177359_a();
            int stride = FORMAT.func_177338_f();
            GlStateManager.vertexPointer((int)3, (int)5126, (int)stride, (int)0);
            GlStateManager.enableClientState((int)32884);
            GlStateManager.texCoordPointer((int)2, (int)5126, (int)stride, (int)12);
            GlStateManager.enableClientState((int)32888);
            GlStateManager.colorPointer((int)4, (int)5121, (int)stride, (int)20);
            GlStateManager.enableClientState((int)32886);
        } else {
            buffer.limit(FORMAT.func_177338_f());
            for (i = 0; i < FORMAT.func_177345_h(); ++i) {
                ((VertexFormatElement)FORMAT.func_177343_g().get(i)).func_177375_c().preDraw(FORMAT, i, FORMAT.func_177338_f(), buffer);
            }
            buffer.position(0);
        }
        GlStateManager.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        if (GLX.useVbo()) {
            this.vbo.func_177358_a(7);
        } else {
            GlStateManager.callList((int)this.displayList);
        }
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (GLX.useVbo()) {
            this.vbo.func_177358_a(7);
            CloudRenderer cloudRenderer = this;
            cloudRenderer.vbo.func_177361_b();
        } else {
            GlStateManager.callList((int)this.displayList);
        }
        buffer.limit(0);
        for (i = 0; i < FORMAT.func_177345_h(); ++i) {
            ((VertexFormatElement)FORMAT.func_177343_g().get(i)).func_177375_c().postDraw(FORMAT, i, FORMAT.func_177338_f(), buffer);
        }
        buffer.position(0);
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
        GlStateManager.matrixMode((int)5890);
        GlStateManager.loadIdentity();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        return true;
    }

    private void reloadTextures() {
        if (this.mc.field_71446_o != null) {
            this.mc.field_71446_o.func_110577_a(this.texture);
            this.texW = GlStateManager.getTexLevelParameter((int)3553, (int)0, (int)4096);
            this.texH = GlStateManager.getTexLevelParameter((int)3553, (int)0, (int)4097);
        }
    }

    @Override
    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test(VanillaResourceType.TEXTURES)) {
            this.reloadTextures();
        }
    }

    private static CloudRenderer getCloudRenderer() {
        if (cloudRenderer == null) {
            cloudRenderer = new CloudRenderer();
        }
        return cloudRenderer;
    }

    public static void updateCloudSettings() {
        CloudRenderer.getCloudRenderer().checkSettings();
    }

    public static boolean renderClouds(int cloudTicks, float partialTicks, ClientWorld world, Minecraft client) {
        IRenderHandler renderer = world.field_73011_w.getCloudRenderer();
        if (renderer != null) {
            renderer.render(cloudTicks, partialTicks, world, client);
            return true;
        }
        return CloudRenderer.getCloudRenderer().render(cloudTicks, partialTicks);
    }
}

