/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;

public interface IWorldReader
extends IEnviromentBlockReader {
    default public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)this, pos);
    }

    default public boolean func_175710_j(BlockPos pos) {
        if (pos.func_177956_o() >= this.func_181545_F()) {
            return this.func_217337_f(pos);
        }
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), this.func_181545_F(), pos.func_177952_p());
        if (!this.func_217337_f(blockpos)) {
            return false;
        }
        BlockPos blockpos1 = blockpos.func_177977_b();
        while (blockpos1.func_177956_o() > pos.func_177956_o()) {
            BlockState blockstate = this.func_180495_p(blockpos1);
            if (blockstate.func_200016_a((IBlockReader)this, blockpos1) > 0 && !blockstate.func_185904_a().func_76224_d()) {
                return false;
            }
            blockpos1 = blockpos1.func_177977_b();
        }
        return true;
    }

    public int func_201669_a(BlockPos var1, int var2);

    @Nullable
    public IChunk func_217353_a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean func_217354_b(int var1, int var2);

    public BlockPos func_205770_a(Heightmap.Type var1, BlockPos var2);

    public int func_201676_a(Heightmap.Type var1, int var2, int var3);

    default public float func_205052_D(BlockPos pos) {
        return this.func_201675_m().func_177497_p()[this.func_201696_r(pos)];
    }

    public int func_175657_ab();

    public WorldBorder func_175723_af();

    public boolean func_195585_a(@Nullable Entity var1, VoxelShape var2);

    default public int func_175627_a(BlockPos pos, Direction direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)this, pos, direction);
    }

    public boolean func_201670_d();

    public int func_181545_F();

    default public IChunk func_217349_x(BlockPos pos) {
        return this.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    default public IChunk func_212866_a_(int chunkX, int chunkZ) {
        return this.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, true);
    }

    default public IChunk func_217348_a(int chunkX, int chunkZ, ChunkStatus requiredStatus) {
        return this.func_217353_a(chunkX, chunkZ, requiredStatus, true);
    }

    default public ChunkStatus func_217342_O() {
        return ChunkStatus.field_223226_a_;
    }

    default public boolean func_217350_a(BlockState blockStateIn, BlockPos pos, ISelectionContext selectionContext) {
        VoxelShape voxelshape = blockStateIn.func_215685_b((IBlockReader)this, pos, selectionContext);
        return voxelshape.func_197766_b() || this.func_195585_a(null, voxelshape.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    default public boolean func_217346_i(Entity entityIn) {
        return this.func_195585_a(entityIn, VoxelShapes.func_197881_a((AxisAlignedBB)entityIn.func_174813_aQ()));
    }

    default public boolean func_217351_c(AxisAlignedBB aabb) {
        return this.func_211156_a(null, aabb, Collections.emptySet());
    }

    default public boolean func_217345_j(Entity entityIn) {
        return this.func_211156_a(entityIn, entityIn.func_174813_aQ(), Collections.emptySet());
    }

    default public boolean func_195586_b(Entity entityIn, AxisAlignedBB aabb) {
        return this.func_211156_a(entityIn, aabb, Collections.emptySet());
    }

    default public boolean func_211156_a(@Nullable Entity entityIn, AxisAlignedBB aabb, Set<Entity> entitiesToIgnore) {
        return this.func_217352_b(entityIn, aabb, entitiesToIgnore).allMatch(VoxelShape::func_197766_b);
    }

    default public Stream<VoxelShape> func_223439_a(@Nullable Entity entityIn, AxisAlignedBB aabb, Set<Entity> entitiesToIgnore) {
        return Stream.empty();
    }

    default public Stream<VoxelShape> func_217352_b(@Nullable Entity entityIn, AxisAlignedBB aabb, Set<Entity> entitiesToIgnore) {
        return Streams.concat((Stream[])new Stream[]{this.func_223438_b(entityIn, aabb), this.func_223439_a(entityIn, aabb, entitiesToIgnore)});
    }

    default public Stream<VoxelShape> func_223438_b(final @Nullable Entity entityIn, AxisAlignedBB aabb) {
        int i = MathHelper.func_76128_c((double)(aabb.field_72340_a - 1.0E-7)) - 1;
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0E-7)) + 1;
        int k = MathHelper.func_76128_c((double)(aabb.field_72338_b - 1.0E-7)) - 1;
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0E-7)) + 1;
        int i1 = MathHelper.func_76128_c((double)(aabb.field_72339_c - 1.0E-7)) - 1;
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0E-7)) + 1;
        final ISelectionContext iselectioncontext = entityIn == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a(entityIn);
        final CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(i, k, i1, j, l, j1);
        final BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        final VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<VoxelShape>(Long.MAX_VALUE, 1280){
            boolean field_223028_a;
            {
                super(x0, x1);
                this.field_223028_a = entityIn == null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super VoxelShape> p_tryAdvance_1_) {
                VoxelShape voxelshape3;
                if (!this.field_223028_a) {
                    this.field_223028_a = true;
                    VoxelShape voxelshape1 = IWorldReader.this.func_175723_af().func_222521_a();
                    boolean flag = VoxelShapes.func_197879_c((VoxelShape)voxelshape1, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entityIn.func_174813_aQ().func_186664_h(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
                    boolean flag1 = VoxelShapes.func_197879_c((VoxelShape)voxelshape1, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entityIn.func_174813_aQ().func_186662_g(1.0E-7)), (IBooleanFunction)IBooleanFunction.field_223238_i_);
                    if (!flag && flag1) {
                        p_tryAdvance_1_.accept((VoxelShape)voxelshape1);
                        return true;
                    }
                }
                while (true) {
                    VoxelShape voxelshape2;
                    int i2;
                    int l1;
                    IChunk ichunk;
                    if (!cubecoordinateiterator.func_218301_a()) {
                        return false;
                    }
                    int j2 = cubecoordinateiterator.func_218304_b();
                    int k2 = cubecoordinateiterator.func_218302_c();
                    int l2 = cubecoordinateiterator.func_218303_d();
                    int k1 = cubecoordinateiterator.func_223473_e();
                    if (k1 == 3 || (ichunk = IWorldReader.this.func_217353_a(l1 = j2 >> 4, i2 = l2 >> 4, IWorldReader.this.func_217342_O(), false)) == null) continue;
                    blockpos$mutableblockpos.func_181079_c(j2, k2, l2);
                    BlockState blockstate = ichunk.func_180495_p((BlockPos)blockpos$mutableblockpos);
                    if ((k1 != 1 || blockstate.func_215704_f()) && (k1 != 2 || blockstate.func_177230_c() == Blocks.field_196603_bb) && VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)(voxelshape3 = (voxelshape2 = blockstate.func_215685_b((IBlockReader)IWorldReader.this, (BlockPos)blockpos$mutableblockpos, iselectioncontext)).func_197751_a((double)j2, (double)k2, (double)l2)), (IBooleanFunction)IBooleanFunction.field_223238_i_)) break;
                }
                p_tryAdvance_1_.accept((VoxelShape)voxelshape3);
                return true;
            }
        }, false);
    }

    default public boolean func_201671_F(BlockPos pos) {
        return this.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
    }

    default public boolean func_72953_d(AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        boolean flag;
                        BlockState blockstate = this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2));
                        if (blockstate.func_204520_s().func_206888_e()) continue;
                        boolean bl = flag = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    default public int func_201696_r(BlockPos pos) {
        return this.func_205049_d(pos, this.func_175657_ab());
    }

    default public int func_205049_d(BlockPos pos, int amount) {
        return pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000 ? this.func_201669_a(pos, amount) : 15;
    }

    @Deprecated
    default public boolean func_175667_e(BlockPos pos) {
        return this.func_217354_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    default public boolean isAreaLoaded(BlockPos center, int range) {
        return this.func_175707_a(center.func_177982_a(-range, -range, -range), center.func_177982_a(range, range, range));
    }

    @Deprecated
    default public boolean func_175707_a(BlockPos from, BlockPos to) {
        return this.func_217344_a(from.func_177958_n(), from.func_177956_o(), from.func_177952_p(), to.func_177958_n(), to.func_177956_o(), to.func_177952_p());
    }

    @Deprecated
    default public boolean func_217344_a(int p_217344_1_, int p_217344_2_, int p_217344_3_, int p_217344_4_, int p_217344_5_, int p_217344_6_) {
        if (p_217344_5_ >= 0 && p_217344_2_ < 256) {
            p_217344_3_ >>= 4;
            p_217344_4_ >>= 4;
            p_217344_6_ >>= 4;
            for (int i = p_217344_1_ >>= 4; i <= p_217344_4_; ++i) {
                for (int j = p_217344_3_; j <= p_217344_6_; ++j) {
                    if (this.func_217354_b(i, j)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public Dimension func_201675_m();
}

